import { ref, inject, computed, onUnmounted, getCurrentInstance } from 'vue';
export function useParent(key) {
  var parent = inject(key, null);

  if (parent) {
    var instance = getCurrentInstance();
    var {
      link: _link,
      unlink: _unlink,
      internalChildren
    } = parent;

    _link(instance);

    onUnmounted(() => _unlink(instance));
    var index = computed(() => internalChildren.indexOf(instance));
    return {
      parent,
      index
    };
  }

  return {
    parent: null,
    index: ref(-1)
  };
}