import { ref, onMounted } from 'vue';
import { inBrowser } from '../utils';
var overflowScrollReg = /scroll|auto/i;
var defaultRoot = inBrowser ? window : undefined;

function isElement(node) {
  var ELEMENT_NODE_TYPE = 1;
  return node.tagName !== 'HTML' && node.tagName !== 'BODY' && node.nodeType === ELEMENT_NODE_TYPE;
} // https://github.com/youzan/vant/issues/3823


export function getScrollParent(el, root = defaultRoot) {
  var node = el;

  while (node && node !== root && isElement(node)) {
    var {
      overflowY
    } = window.getComputedStyle(node);

    if (overflowScrollReg.test(overflowY)) {
      return node;
    }

    node = node.parentNode;
  }

  return root;
}
export function useScrollParent(el, root = defaultRoot) {
  var scrollParent = ref();
  onMounted(() => {
    if (el.value) {
      scrollParent.value = getScrollParent(el.value, root);
    }
  });
  return scrollParent;
}