import { ref } from 'vue';
import { inBrowser } from '../utils';
import { useEventListener } from '../useEventListener';
export function useWindowSize() {
  var width = ref(inBrowser ? window.innerWidth : 0);
  var height = ref(inBrowser ? window.innerHeight : 0);

  var onResize = () => {
    width.value = window.innerWidth;
    height.value = window.innerHeight;
  };

  useEventListener('resize', onResize);
  useEventListener('orientationchange', onResize);
  return {
    width,
    height
  };
}