export var inBrowser = typeof window !== 'undefined';
var root = inBrowser ? window : global;
var prev = Date.now();

function rafPolyfill(fn) {
  var curr = Date.now();
  var ms = Math.max(0, 16 - (curr - prev));
  var id = setTimeout(fn, ms);
  prev = curr + ms;
  return id;
}

export function raf(fn) {
  var requestAnimationFrame = root.requestAnimationFrame || rafPolyfill;
  return requestAnimationFrame.call(root, fn);
}
export function cancelRaf(id) {
  var cancelAnimationFrame = root.cancelAnimationFrame || root.clearTimeout;
  cancelAnimationFrame.call(root, id);
} // double raf for animation

export function doubleRaf(fn) {
  raf(() => raf(fn));
}