"use strict";

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

(function (global, factory) {
  (typeof exports === "undefined" ? "undefined" : _typeof(exports)) === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('vega'), require('vega-lite')) : typeof define === 'function' && define.amd ? define(['vega', 'vega-lite'], factory) : (global = global || self, global.vegaEmbed = factory(global.vega, global.vegaLite));
})(void 0, function (vegaImport, vegaLiteImport) {
  'use strict';

  var name = "vega-embed";
  var version = "6.8.0";
  var description = "Publish Vega visualizations as embedded web components.";
  var keywords = ["vega", "data", "visualization", "component", "embed"];
  var repository = {
    type: "git",
    url: "http://github.com/vega/vega-embed.git"
  };
  var author = {
    name: "UW Interactive Data Lab",
    url: "http://idl.cs.washington.edu"
  };
  var contributors = [{
    name: "Dominik Moritz",
    url: "https://www.domoritz.de"
  }];
  var license = "BSD-3-Clause";
  var main = "build/vega-embed.js";
  var module = "build/src/embed.js";
  var unpkg = "build/vega-embed.min.js";
  var jsdelivr = "build/vega-embed.min.js";
  var types = "build/src/embed.d.ts";
  var devDependencies = {
    "@rollup/plugin-commonjs": "11.1.0",
    "@rollup/plugin-json": "^4.0.3",
    "@rollup/plugin-node-resolve": "^7.1.3",
    "@types/jest": "^25.2.1",
    "@types/semver": "^7.1.0",
    "browser-sync": "^2.26.7",
    concurrently: "^5.2.0",
    jest: "^26.0.1",
    "jest-canvas-mock": "^2.2.0",
    "node-sass": "^4.14.1",
    rollup: "^2.8.2",
    terser: "^4.6.13",
    typescript: "~3.8.3",
    vega: "^5.10.0",
    "vega-lite": "^4.7.0",
    "vega-lite-dev-config": "^0.10.0"
  };
  var peerDependencies = {
    vega: "^5.8.0",
    "vega-lite": "*"
  };
  var dependencies = {
    "fast-json-patch": "^3.0.0-1",
    "json-stringify-pretty-compact": "^2.0.0",
    semver: "^7.3.2",
    "vega-schema-url-parser": "^1.1.0",
    "vega-themes": "^2.8.3",
    "vega-tooltip": "^0.23.0"
  };
  var scripts = {
    "tsc:src": "tsc -p tsconfig.src.json",
    prebuild: "yarn build:style && yarn tsc:src",
    build: "rollup -c",
    "build:style": "./build-style.sh",
    clean: "rm -rf build && rm -f src/style.ts && mkdir build",
    postbuild: "terser build/vega-embed.js -cm > build/vega-embed.min.js && beemo babel build/vega-embed.js --out-dir build-es5 --config-file ./babel.config.js",
    prepublishOnly: "yarn clean && yarn build",
    preversion: "yarn lint && yarn test",
    serve: "browser-sync start --directory -s -f build *.html",
    start: "yarn build && concurrently --kill-others -n Server,Typescript,Rollup 'yarn serve' 'yarn tsc:src -w' 'rollup -c -w'",
    pretest: "yarn build:style",
    test: "jest",
    "test:inspect": "node --inspect-brk ./node_modules/.bin/jest --runInBand",
    prepare: "beemo create-config",
    prettierbase: "beemo prettier '*.{css,html}'",
    eslintbase: "beemo eslint",
    format: "yarn eslintbase --fix && yarn prettierbase --write",
    lint: "yarn eslintbase && yarn prettierbase --check"
  };
  var beemo = {
    module: "vega-lite-dev-config",
    drivers: ["prettier", "eslint", "babel"],
    prettier: {
      ignore: ["src/style.ts", "README.md"]
    }
  };
  var jest = {
    testURL: "http://localhost/",
    setupFiles: ["jest-canvas-mock"],
    transform: {
      "^.+\\.tsx?$": "ts-jest"
    },
    testRegex: "(/__tests__/.*|(\\.|/)(test|spec))\\.(jsx?|tsx?)$",
    moduleFileExtensions: ["ts", "tsx", "js", "jsx", "json", "node"],
    testPathIgnorePatterns: ["node_modules", "<rootDir>/build", "src"]
  };
  var pkg = {
    name: name,
    version: version,
    description: description,
    keywords: keywords,
    repository: repository,
    author: author,
    contributors: contributors,
    license: license,
    main: main,
    module: module,
    unpkg: unpkg,
    jsdelivr: jsdelivr,
    types: types,
    devDependencies: devDependencies,
    peerDependencies: peerDependencies,
    dependencies: dependencies,
    scripts: scripts,
    beemo: beemo,
    jest: jest
  };
  /*! *****************************************************************************
  Copyright (c) Microsoft Corporation.
    Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.
    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** */

  function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function (resolve) {
        resolve(value);
      });
    }

    return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }

      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }

      function step(result) {
        result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
      }

      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  }
  /*!
   * https://github.com/Starcounter-Jack/JSON-Patch
   * (c) 2017 Joachim Wester
   * MIT license
   */


  var __extends = undefined && undefined.__extends || function () {
    var _extendStatics = function extendStatics(d, b) {
      _extendStatics = Object.setPrototypeOf || {
        __proto__: []
      } instanceof Array && function (d, b) {
        d.__proto__ = b;
      } || function (d, b) {
        for (var p in b) {
          if (b.hasOwnProperty(p)) d[p] = b[p];
        }
      };

      return _extendStatics(d, b);
    };

    return function (d, b) {
      _extendStatics(d, b);

      function __() {
        this.constructor = d;
      }

      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();

  var _hasOwnProperty = Object.prototype.hasOwnProperty;

  function hasOwnProperty(obj, key) {
    return _hasOwnProperty.call(obj, key);
  }

  function _objectKeys(obj) {
    if (Array.isArray(obj)) {
      var keys = new Array(obj.length);

      for (var k = 0; k < keys.length; k++) {
        keys[k] = "" + k;
      }

      return keys;
    }

    if (Object.keys) {
      return Object.keys(obj);
    }

    var keys = [];

    for (var i in obj) {
      if (hasOwnProperty(obj, i)) {
        keys.push(i);
      }
    }

    return keys;
  }
  /**
  * Deeply clone the object.
  * https://jsperf.com/deep-copy-vs-json-stringify-json-parse/25 (recursiveDeepCopy)
  * @param  {any} obj value to clone
  * @return {any} cloned obj
  */


  function _deepClone(obj) {
    switch (_typeof(obj)) {
      case "object":
        return JSON.parse(JSON.stringify(obj));
      //Faster than ES5 clone - http://jsperf.com/deep-cloning-of-objects/5

      case "undefined":
        return null;
      //this is how JSON.stringify behaves for array items

      default:
        return obj;
      //no need to clone primitives
    }
  } //3x faster than cached /^\d+$/.test(str)


  function isInteger(str) {
    var i = 0;
    var len = str.length;
    var charCode;

    while (i < len) {
      charCode = str.charCodeAt(i);

      if (charCode >= 48 && charCode <= 57) {
        i++;
        continue;
      }

      return false;
    }

    return true;
  }
  /**
  * Escapes a json pointer path
  * @param path The raw pointer
  * @return the Escaped path
  */


  function escapePathComponent(path) {
    if (path.indexOf('/') === -1 && path.indexOf('~') === -1) return path;
    return path.replace(/~/g, '~0').replace(/\//g, '~1');
  }
  /**
   * Unescapes a json pointer path
   * @param path The escaped pointer
   * @return The unescaped path
   */


  function unescapePathComponent(path) {
    return path.replace(/~1/g, '/').replace(/~0/g, '~');
  }
  /**
  * Recursively checks whether an object has any undefined values inside.
  */


  function hasUndefined(obj) {
    if (obj === undefined) {
      return true;
    }

    if (obj) {
      if (Array.isArray(obj)) {
        for (var i = 0, len = obj.length; i < len; i++) {
          if (hasUndefined(obj[i])) {
            return true;
          }
        }
      } else if (_typeof(obj) === "object") {
        var objKeys = _objectKeys(obj);

        var objKeysLength = objKeys.length;

        for (var i = 0; i < objKeysLength; i++) {
          if (hasUndefined(obj[objKeys[i]])) {
            return true;
          }
        }
      }
    }

    return false;
  }

  function patchErrorMessageFormatter(message, args) {
    var messageParts = [message];

    for (var key in args) {
      var value = _typeof(args[key]) === 'object' ? JSON.stringify(args[key], null, 2) : args[key]; // pretty print

      if (typeof value !== 'undefined') {
        messageParts.push(key + ": " + value);
      }
    }

    return messageParts.join('\n');
  }

  var PatchError =
  /** @class */
  function (_super) {
    __extends(PatchError, _super);

    function PatchError(message, name, index, operation, tree) {
      var _newTarget = this.constructor;

      var _this = _super.call(this, patchErrorMessageFormatter(message, {
        name: name,
        index: index,
        operation: operation,
        tree: tree
      })) || this;

      _this.name = name;
      _this.index = index;
      _this.operation = operation;
      _this.tree = tree;
      Object.setPrototypeOf(_this, _newTarget.prototype); // restore prototype chain, see https://stackoverflow.com/a/48342359

      _this.message = patchErrorMessageFormatter(message, {
        name: name,
        index: index,
        operation: operation,
        tree: tree
      });
      return _this;
    }

    return PatchError;
  }(Error);

  var JsonPatchError = PatchError;
  var deepClone = _deepClone;
  /* We use a Javascript hash to store each
   function. Each hash entry (property) uses
   the operation identifiers specified in rfc6902.
   In this way, we can map each patch operation
   to its dedicated function in efficient way.
   */

  /* The operations applicable to an object */

  var objOps = {
    add: function add(obj, key, document) {
      obj[key] = this.value;
      return {
        newDocument: document
      };
    },
    remove: function remove(obj, key, document) {
      var removed = obj[key];
      delete obj[key];
      return {
        newDocument: document,
        removed: removed
      };
    },
    replace: function replace(obj, key, document) {
      var removed = obj[key];
      obj[key] = this.value;
      return {
        newDocument: document,
        removed: removed
      };
    },
    move: function move(obj, key, document) {
      /* in case move target overwrites an existing value,
      return the removed value, this can be taxing performance-wise,
      and is potentially unneeded */
      var removed = getValueByPointer(document, this.path);

      if (removed) {
        removed = _deepClone(removed);
      }

      var originalValue = applyOperation(document, {
        op: "remove",
        path: this.from
      }).removed;
      applyOperation(document, {
        op: "add",
        path: this.path,
        value: originalValue
      });
      return {
        newDocument: document,
        removed: removed
      };
    },
    copy: function copy(obj, key, document) {
      var valueToCopy = getValueByPointer(document, this.from); // enforce copy by value so further operations don't affect source (see issue #177)

      applyOperation(document, {
        op: "add",
        path: this.path,
        value: _deepClone(valueToCopy)
      });
      return {
        newDocument: document
      };
    },
    test: function test(obj, key, document) {
      return {
        newDocument: document,
        test: _areEquals(obj[key], this.value)
      };
    },
    _get: function _get(obj, key, document) {
      this.value = obj[key];
      return {
        newDocument: document
      };
    }
  };
  /* The operations applicable to an array. Many are the same as for the object */

  var arrOps = {
    add: function add(arr, i, document) {
      if (isInteger(i)) {
        arr.splice(i, 0, this.value);
      } else {
        // array props
        arr[i] = this.value;
      } // this may be needed when using '-' in an array


      return {
        newDocument: document,
        index: i
      };
    },
    remove: function remove(arr, i, document) {
      var removedList = arr.splice(i, 1);
      return {
        newDocument: document,
        removed: removedList[0]
      };
    },
    replace: function replace(arr, i, document) {
      var removed = arr[i];
      arr[i] = this.value;
      return {
        newDocument: document,
        removed: removed
      };
    },
    move: objOps.move,
    copy: objOps.copy,
    test: objOps.test,
    _get: objOps._get
  };
  /**
   * Retrieves a value from a JSON document by a JSON pointer.
   * Returns the value.
   *
   * @param document The document to get the value from
   * @param pointer an escaped JSON pointer
   * @return The retrieved value
   */

  function getValueByPointer(document, pointer) {
    if (pointer == '') {
      return document;
    }

    var getOriginalDestination = {
      op: "_get",
      path: pointer
    };
    applyOperation(document, getOriginalDestination);
    return getOriginalDestination.value;
  }
  /**
   * Apply a single JSON Patch Operation on a JSON document.
   * Returns the {newDocument, result} of the operation.
   * It modifies the `document` and `operation` objects - it gets the values by reference.
   * If you would like to avoid touching your values, clone them:
   * `jsonpatch.applyOperation(document, jsonpatch._deepClone(operation))`.
   *
   * @param document The document to patch
   * @param operation The operation to apply
   * @param validateOperation `false` is without validation, `true` to use default jsonpatch's validation, or you can pass a `validateOperation` callback to be used for validation.
   * @param mutateDocument Whether to mutate the original document or clone it before applying
   * @param banPrototypeModifications Whether to ban modifications to `__proto__`, defaults to `true`.
   * @return `{newDocument, result}` after the operation
   */


  function applyOperation(document, operation, validateOperation, mutateDocument, banPrototypeModifications, index) {
    if (validateOperation === void 0) {
      validateOperation = false;
    }

    if (mutateDocument === void 0) {
      mutateDocument = true;
    }

    if (banPrototypeModifications === void 0) {
      banPrototypeModifications = true;
    }

    if (index === void 0) {
      index = 0;
    }

    if (validateOperation) {
      if (typeof validateOperation == 'function') {
        validateOperation(operation, 0, document, operation.path);
      } else {
        validator(operation, 0);
      }
    }
    /* ROOT OPERATIONS */


    if (operation.path === "") {
      var returnValue = {
        newDocument: document
      };

      if (operation.op === 'add') {
        returnValue.newDocument = operation.value;
        return returnValue;
      } else if (operation.op === 'replace') {
        returnValue.newDocument = operation.value;
        returnValue.removed = document; //document we removed

        return returnValue;
      } else if (operation.op === 'move' || operation.op === 'copy') {
        // it's a move or copy to root
        returnValue.newDocument = getValueByPointer(document, operation.from); // get the value by json-pointer in `from` field

        if (operation.op === 'move') {
          // report removed item
          returnValue.removed = document;
        }

        return returnValue;
      } else if (operation.op === 'test') {
        returnValue.test = _areEquals(document, operation.value);

        if (returnValue.test === false) {
          throw new JsonPatchError("Test operation failed", 'TEST_OPERATION_FAILED', index, operation, document);
        }

        returnValue.newDocument = document;
        return returnValue;
      } else if (operation.op === 'remove') {
        // a remove on root
        returnValue.removed = document;
        returnValue.newDocument = null;
        return returnValue;
      } else if (operation.op === '_get') {
        operation.value = document;
        return returnValue;
      } else {
        /* bad operation */
        if (validateOperation) {
          throw new JsonPatchError('Operation `op` property is not one of operations defined in RFC-6902', 'OPERATION_OP_INVALID', index, operation, document);
        } else {
          return returnValue;
        }
      }
    }
    /* END ROOT OPERATIONS */
    else {
        if (!mutateDocument) {
          document = _deepClone(document);
        }

        var path = operation.path || "";
        var keys = path.split('/');
        var obj = document;
        var t = 1; //skip empty element - http://jsperf.com/to-shift-or-not-to-shift

        var len = keys.length;
        var existingPathFragment = undefined;
        var key = void 0;
        var validateFunction = void 0;

        if (typeof validateOperation == 'function') {
          validateFunction = validateOperation;
        } else {
          validateFunction = validator;
        }

        while (true) {
          key = keys[t];

          if (banPrototypeModifications && key == '__proto__') {
            throw new TypeError('JSON-Patch: modifying `__proto__` prop is banned for security reasons, if this was on purpose, please set `banPrototypeModifications` flag false and pass it to this function. More info in fast-json-patch README');
          }

          if (validateOperation) {
            if (existingPathFragment === undefined) {
              if (obj[key] === undefined) {
                existingPathFragment = keys.slice(0, t).join('/');
              } else if (t == len - 1) {
                existingPathFragment = operation.path;
              }

              if (existingPathFragment !== undefined) {
                validateFunction(operation, 0, document, existingPathFragment);
              }
            }
          }

          t++;

          if (Array.isArray(obj)) {
            if (key === '-') {
              key = obj.length;
            } else {
              if (validateOperation && !isInteger(key)) {
                throw new JsonPatchError("Expected an unsigned base-10 integer value, making the new referenced value the array element with the zero-based index", "OPERATION_PATH_ILLEGAL_ARRAY_INDEX", index, operation, document);
              } // only parse key when it's an integer for `arr.prop` to work
              else if (isInteger(key)) {
                  key = ~~key;
                }
            }

            if (t >= len) {
              if (validateOperation && operation.op === "add" && key > obj.length) {
                throw new JsonPatchError("The specified index MUST NOT be greater than the number of elements in the array", "OPERATION_VALUE_OUT_OF_BOUNDS", index, operation, document);
              }

              var returnValue = arrOps[operation.op].call(operation, obj, key, document); // Apply patch

              if (returnValue.test === false) {
                throw new JsonPatchError("Test operation failed", 'TEST_OPERATION_FAILED', index, operation, document);
              }

              return returnValue;
            }
          } else {
            if (key && key.indexOf('~') != -1) {
              key = unescapePathComponent(key);
            }

            if (t >= len) {
              var returnValue = objOps[operation.op].call(operation, obj, key, document); // Apply patch

              if (returnValue.test === false) {
                throw new JsonPatchError("Test operation failed", 'TEST_OPERATION_FAILED', index, operation, document);
              }

              return returnValue;
            }
          }

          obj = obj[key];
        }
      }
  }
  /**
   * Apply a full JSON Patch array on a JSON document.
   * Returns the {newDocument, result} of the patch.
   * It modifies the `document` object and `patch` - it gets the values by reference.
   * If you would like to avoid touching your values, clone them:
   * `jsonpatch.applyPatch(document, jsonpatch._deepClone(patch))`.
   *
   * @param document The document to patch
   * @param patch The patch to apply
   * @param validateOperation `false` is without validation, `true` to use default jsonpatch's validation, or you can pass a `validateOperation` callback to be used for validation.
   * @param mutateDocument Whether to mutate the original document or clone it before applying
   * @param banPrototypeModifications Whether to ban modifications to `__proto__`, defaults to `true`.
   * @return An array of `{newDocument, result}` after the patch
   */


  function applyPatch(document, patch, validateOperation, mutateDocument, banPrototypeModifications) {
    if (mutateDocument === void 0) {
      mutateDocument = true;
    }

    if (banPrototypeModifications === void 0) {
      banPrototypeModifications = true;
    }

    if (validateOperation) {
      if (!Array.isArray(patch)) {
        throw new JsonPatchError('Patch sequence must be an array', 'SEQUENCE_NOT_AN_ARRAY');
      }
    }

    if (!mutateDocument) {
      document = _deepClone(document);
    }

    var results = new Array(patch.length);

    for (var i = 0, length_1 = patch.length; i < length_1; i++) {
      // we don't need to pass mutateDocument argument because if it was true, we already deep cloned the object, we'll just pass `true`
      results[i] = applyOperation(document, patch[i], validateOperation, true, banPrototypeModifications, i);
      document = results[i].newDocument; // in case root was replaced
    }

    results.newDocument = document;
    return results;
  }
  /**
   * Apply a single JSON Patch Operation on a JSON document.
   * Returns the updated document.
   * Suitable as a reducer.
   *
   * @param document The document to patch
   * @param operation The operation to apply
   * @return The updated document
   */


  function applyReducer(document, operation, index) {
    var operationResult = applyOperation(document, operation);

    if (operationResult.test === false) {
      // failed test
      throw new JsonPatchError("Test operation failed", 'TEST_OPERATION_FAILED', index, operation, document);
    }

    return operationResult.newDocument;
  }
  /**
   * Validates a single operation. Called from `jsonpatch.validate`. Throws `JsonPatchError` in case of an error.
   * @param {object} operation - operation object (patch)
   * @param {number} index - index of operation in the sequence
   * @param {object} [document] - object where the operation is supposed to be applied
   * @param {string} [existingPathFragment] - comes along with `document`
   */


  function validator(operation, index, document, existingPathFragment) {
    if (_typeof(operation) !== 'object' || operation === null || Array.isArray(operation)) {
      throw new JsonPatchError('Operation is not an object', 'OPERATION_NOT_AN_OBJECT', index, operation, document);
    } else if (!objOps[operation.op]) {
      throw new JsonPatchError('Operation `op` property is not one of operations defined in RFC-6902', 'OPERATION_OP_INVALID', index, operation, document);
    } else if (typeof operation.path !== 'string') {
      throw new JsonPatchError('Operation `path` property is not a string', 'OPERATION_PATH_INVALID', index, operation, document);
    } else if (operation.path.indexOf('/') !== 0 && operation.path.length > 0) {
      // paths that aren't empty string should start with "/"
      throw new JsonPatchError('Operation `path` property must start with "/"', 'OPERATION_PATH_INVALID', index, operation, document);
    } else if ((operation.op === 'move' || operation.op === 'copy') && typeof operation.from !== 'string') {
      throw new JsonPatchError('Operation `from` property is not present (applicable in `move` and `copy` operations)', 'OPERATION_FROM_REQUIRED', index, operation, document);
    } else if ((operation.op === 'add' || operation.op === 'replace' || operation.op === 'test') && operation.value === undefined) {
      throw new JsonPatchError('Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)', 'OPERATION_VALUE_REQUIRED', index, operation, document);
    } else if ((operation.op === 'add' || operation.op === 'replace' || operation.op === 'test') && hasUndefined(operation.value)) {
      throw new JsonPatchError('Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)', 'OPERATION_VALUE_CANNOT_CONTAIN_UNDEFINED', index, operation, document);
    } else if (document) {
      if (operation.op == "add") {
        var pathLen = operation.path.split("/").length;
        var existingPathLen = existingPathFragment.split("/").length;

        if (pathLen !== existingPathLen + 1 && pathLen !== existingPathLen) {
          throw new JsonPatchError('Cannot perform an `add` operation at the desired path', 'OPERATION_PATH_CANNOT_ADD', index, operation, document);
        }
      } else if (operation.op === 'replace' || operation.op === 'remove' || operation.op === '_get') {
        if (operation.path !== existingPathFragment) {
          throw new JsonPatchError('Cannot perform the operation at a path that does not exist', 'OPERATION_PATH_UNRESOLVABLE', index, operation, document);
        }
      } else if (operation.op === 'move' || operation.op === 'copy') {
        var existingValue = {
          op: "_get",
          path: operation.from,
          value: undefined
        };
        var error = validate([existingValue], document);

        if (error && error.name === 'OPERATION_PATH_UNRESOLVABLE') {
          throw new JsonPatchError('Cannot perform the operation from a path that does not exist', 'OPERATION_FROM_UNRESOLVABLE', index, operation, document);
        }
      }
    }
  }
  /**
   * Validates a sequence of operations. If `document` parameter is provided, the sequence is additionally validated against the object document.
   * If error is encountered, returns a JsonPatchError object
   * @param sequence
   * @param document
   * @returns {JsonPatchError|undefined}
   */


  function validate(sequence, document, externalValidator) {
    try {
      if (!Array.isArray(sequence)) {
        throw new JsonPatchError('Patch sequence must be an array', 'SEQUENCE_NOT_AN_ARRAY');
      }

      if (document) {
        //clone document and sequence so that we can safely try applying operations
        applyPatch(_deepClone(document), _deepClone(sequence), externalValidator || true);
      } else {
        externalValidator = externalValidator || validator;

        for (var i = 0; i < sequence.length; i++) {
          externalValidator(sequence[i], i, document, undefined);
        }
      }
    } catch (e) {
      if (e instanceof JsonPatchError) {
        return e;
      } else {
        throw e;
      }
    }
  } // based on https://github.com/epoberezkin/fast-deep-equal
  // MIT License
  // Copyright (c) 2017 Evgeny Poberezkin
  // Permission is hereby granted, free of charge, to any person obtaining a copy
  // of this software and associated documentation files (the "Software"), to deal
  // in the Software without restriction, including without limitation the rights
  // to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  // copies of the Software, and to permit persons to whom the Software is
  // furnished to do so, subject to the following conditions:
  // The above copyright notice and this permission notice shall be included in all
  // copies or substantial portions of the Software.
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  // OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  // SOFTWARE.


  function _areEquals(a, b) {
    if (a === b) return true;

    if (a && b && _typeof(a) == 'object' && _typeof(b) == 'object') {
      var arrA = Array.isArray(a),
          arrB = Array.isArray(b),
          i,
          length,
          key;

      if (arrA && arrB) {
        length = a.length;
        if (length != b.length) return false;

        for (i = length; i-- !== 0;) {
          if (!_areEquals(a[i], b[i])) return false;
        }

        return true;
      }

      if (arrA != arrB) return false;
      var keys = Object.keys(a);
      length = keys.length;
      if (length !== Object.keys(b).length) return false;

      for (i = length; i-- !== 0;) {
        if (!b.hasOwnProperty(keys[i])) return false;
      }

      for (i = length; i-- !== 0;) {
        key = keys[i];
        if (!_areEquals(a[key], b[key])) return false;
      }

      return true;
    }

    return a !== a && b !== b;
  }

  var core = /*#__PURE__*/Object.freeze({
    __proto__: null,
    JsonPatchError: JsonPatchError,
    deepClone: deepClone,
    getValueByPointer: getValueByPointer,
    applyOperation: applyOperation,
    applyPatch: applyPatch,
    applyReducer: applyReducer,
    validator: validator,
    validate: validate,
    _areEquals: _areEquals
  });
  /*!
   * https://github.com/Starcounter-Jack/JSON-Patch
   * (c) 2017 Joachim Wester
   * MIT license
   */

  var beforeDict = new WeakMap();

  var Mirror =
  /** @class */
  function () {
    function Mirror(obj) {
      this.observers = new Map();
      this.obj = obj;
    }

    return Mirror;
  }();

  var ObserverInfo =
  /** @class */
  function () {
    function ObserverInfo(callback, observer) {
      this.callback = callback;
      this.observer = observer;
    }

    return ObserverInfo;
  }();

  function getMirror(obj) {
    return beforeDict.get(obj);
  }

  function getObserverFromMirror(mirror, callback) {
    return mirror.observers.get(callback);
  }

  function removeObserverFromMirror(mirror, observer) {
    mirror.observers.delete(observer.callback);
  }
  /**
   * Detach an observer from an object
   */


  function unobserve(root, observer) {
    observer.unobserve();
  }
  /**
   * Observes changes made to an object, which can then be retrieved using generate
   */


  function observe(obj, callback) {
    var patches = [];
    var observer;
    var mirror = getMirror(obj);

    if (!mirror) {
      mirror = new Mirror(obj);
      beforeDict.set(obj, mirror);
    } else {
      var observerInfo = getObserverFromMirror(mirror, callback);
      observer = observerInfo && observerInfo.observer;
    }

    if (observer) {
      return observer;
    }

    observer = {};
    mirror.value = _deepClone(obj);

    if (callback) {
      observer.callback = callback;
      observer.next = null;

      var dirtyCheck = function dirtyCheck() {
        generate(observer);
      };

      var fastCheck = function fastCheck() {
        clearTimeout(observer.next);
        observer.next = setTimeout(dirtyCheck);
      };

      if (typeof window !== 'undefined') {
        //not Node
        window.addEventListener('mouseup', fastCheck);
        window.addEventListener('keyup', fastCheck);
        window.addEventListener('mousedown', fastCheck);
        window.addEventListener('keydown', fastCheck);
        window.addEventListener('change', fastCheck);
      }
    }

    observer.patches = patches;
    observer.object = obj;

    observer.unobserve = function () {
      generate(observer);
      clearTimeout(observer.next);
      removeObserverFromMirror(mirror, observer);

      if (typeof window !== 'undefined') {
        window.removeEventListener('mouseup', fastCheck);
        window.removeEventListener('keyup', fastCheck);
        window.removeEventListener('mousedown', fastCheck);
        window.removeEventListener('keydown', fastCheck);
        window.removeEventListener('change', fastCheck);
      }
    };

    mirror.observers.set(callback, new ObserverInfo(callback, observer));
    return observer;
  }
  /**
   * Generate an array of patches from an observer
   */


  function generate(observer, invertible) {
    if (invertible === void 0) {
      invertible = false;
    }

    var mirror = beforeDict.get(observer.object);

    _generate(mirror.value, observer.object, observer.patches, "", invertible);

    if (observer.patches.length) {
      applyPatch(mirror.value, observer.patches);
    }

    var temp = observer.patches;

    if (temp.length > 0) {
      observer.patches = [];

      if (observer.callback) {
        observer.callback(temp);
      }
    }

    return temp;
  } // Dirty check if obj is different from mirror, generate patches and update mirror


  function _generate(mirror, obj, patches, path, invertible) {
    if (obj === mirror) {
      return;
    }

    if (typeof obj.toJSON === "function") {
      obj = obj.toJSON();
    }

    var newKeys = _objectKeys(obj);

    var oldKeys = _objectKeys(mirror);

    var deleted = false; //if ever "move" operation is implemented here, make sure this test runs OK: "should not generate the same patch twice (move)"

    for (var t = oldKeys.length - 1; t >= 0; t--) {
      var key = oldKeys[t];
      var oldVal = mirror[key];

      if (hasOwnProperty(obj, key) && !(obj[key] === undefined && oldVal !== undefined && Array.isArray(obj) === false)) {
        var newVal = obj[key];

        if (_typeof(oldVal) == "object" && oldVal != null && _typeof(newVal) == "object" && newVal != null) {
          _generate(oldVal, newVal, patches, path + "/" + escapePathComponent(key), invertible);
        } else {
          if (oldVal !== newVal) {
            if (invertible) {
              patches.push({
                op: "test",
                path: path + "/" + escapePathComponent(key),
                value: _deepClone(oldVal)
              });
            }

            patches.push({
              op: "replace",
              path: path + "/" + escapePathComponent(key),
              value: _deepClone(newVal)
            });
          }
        }
      } else if (Array.isArray(mirror) === Array.isArray(obj)) {
        if (invertible) {
          patches.push({
            op: "test",
            path: path + "/" + escapePathComponent(key),
            value: _deepClone(oldVal)
          });
        }

        patches.push({
          op: "remove",
          path: path + "/" + escapePathComponent(key)
        });
        deleted = true; // property has been deleted
      } else {
        if (invertible) {
          patches.push({
            op: "test",
            path: path,
            value: mirror
          });
        }

        patches.push({
          op: "replace",
          path: path,
          value: obj
        });
      }
    }

    if (!deleted && newKeys.length == oldKeys.length) {
      return;
    }

    for (var t = 0; t < newKeys.length; t++) {
      var key = newKeys[t];

      if (!hasOwnProperty(mirror, key) && obj[key] !== undefined) {
        patches.push({
          op: "add",
          path: path + "/" + escapePathComponent(key),
          value: _deepClone(obj[key])
        });
      }
    }
  }
  /**
   * Create an array of patches from the differences in two objects
   */


  function compare(tree1, tree2, invertible) {
    if (invertible === void 0) {
      invertible = false;
    }

    var patches = [];

    _generate(tree1, tree2, patches, '', invertible);

    return patches;
  }

  var duplex = /*#__PURE__*/Object.freeze({
    __proto__: null,
    unobserve: unobserve,
    observe: observe,
    generate: generate,
    compare: compare
  });
  Object.assign({}, core, duplex, {
    JsonPatchError: PatchError,
    deepClone: _deepClone,
    escapePathComponent: escapePathComponent,
    unescapePathComponent: unescapePathComponent
  }); // Note: This regex matches even invalid JSON strings, but since we’re
  // working on the output of `JSON.stringify` we know that only valid strings
  // are present (unless the user supplied a weird `options.indent` but in
  // that case we don’t care since the output would be invalid anyway).

  var stringOrChar = /("(?:[^\\"]|\\.)*")|[:,]/g;

  var jsonStringifyPrettyCompact = function stringify(passedObj, options) {
    var indent, maxLength, replacer;
    options = options || {};
    indent = JSON.stringify([1], undefined, options.indent === undefined ? 2 : options.indent).slice(2, -3);
    maxLength = indent === "" ? Infinity : options.maxLength === undefined ? 80 : options.maxLength;
    replacer = options.replacer;
    return function _stringify(obj, currentIndent, reserved) {
      // prettier-ignore
      var end, index, items, key, keyPart, keys, length, nextIndent, prettified, start, string, value;

      if (obj && typeof obj.toJSON === "function") {
        obj = obj.toJSON();
      }

      string = JSON.stringify(obj, replacer);

      if (string === undefined) {
        return string;
      }

      length = maxLength - currentIndent.length - reserved;

      if (string.length <= length) {
        prettified = string.replace(stringOrChar, function (match, stringLiteral) {
          return stringLiteral || match + " ";
        });

        if (prettified.length <= length) {
          return prettified;
        }
      }

      if (replacer != null) {
        obj = JSON.parse(string);
        replacer = undefined;
      }

      if (_typeof(obj) === "object" && obj !== null) {
        nextIndent = currentIndent + indent;
        items = [];
        index = 0;

        if (Array.isArray(obj)) {
          start = "[";
          end = "]";
          length = obj.length;

          for (; index < length; index++) {
            items.push(_stringify(obj[index], nextIndent, index === length - 1 ? 0 : 1) || "null");
          }
        } else {
          start = "{";
          end = "}";
          keys = Object.keys(obj);
          length = keys.length;

          for (; index < length; index++) {
            key = keys[index];
            keyPart = JSON.stringify(key) + ": ";
            value = _stringify(obj[key], nextIndent, keyPart.length + (index === length - 1 ? 0 : 1));

            if (value !== undefined) {
              items.push(keyPart + value);
            }
          }
        }

        if (items.length > 0) {
          return [start, indent + items.join(",\n" + nextIndent), end].join("\n" + currentIndent);
        }
      }

      return string;
    }(passedObj, "", 0);
  };

  function unwrapExports(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
    return module = {
      exports: {}
    }, fn(module, module.exports), module.exports;
  } // Note: this is the semver.org version of the spec that it implements
  // Not necessarily the package version of this code.


  var SEMVER_SPEC_VERSION = '2.0.0';
  var MAX_LENGTH = 256;
  var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER ||
  /* istanbul ignore next */
  9007199254740991; // Max safe segment length for coercion.

  var MAX_SAFE_COMPONENT_LENGTH = 16;
  var constants = {
    SEMVER_SPEC_VERSION: SEMVER_SPEC_VERSION,
    MAX_LENGTH: MAX_LENGTH,
    MAX_SAFE_INTEGER: MAX_SAFE_INTEGER,
    MAX_SAFE_COMPONENT_LENGTH: MAX_SAFE_COMPONENT_LENGTH
  };
  var debug = (typeof process === "undefined" ? "undefined" : _typeof(process)) === 'object' && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? function () {
    var _console;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return (_console = console).error.apply(_console, ['SEMVER'].concat(args));
  } : function () {};
  var debug_1 = debug;
  var re_1 = createCommonjsModule(function (module, exports) {
    var MAX_SAFE_COMPONENT_LENGTH = constants.MAX_SAFE_COMPONENT_LENGTH;
    exports = module.exports = {}; // The actual regexps go on exports.re

    var re = exports.re = [];
    var src = exports.src = [];
    var t = exports.t = {};
    var R = 0;

    var createToken = function createToken(name, value, isGlobal) {
      var index = R++;
      debug_1(index, value);
      t[name] = index;
      src[index] = value;
      re[index] = new RegExp(value, isGlobal ? 'g' : undefined);
    }; // The following Regular Expressions can be used for tokenizing,
    // validating, and parsing SemVer version strings.
    // ## Numeric Identifier
    // A single `0`, or a non-zero digit followed by zero or more digits.


    createToken('NUMERICIDENTIFIER', '0|[1-9]\\d*');
    createToken('NUMERICIDENTIFIERLOOSE', '[0-9]+'); // ## Non-numeric Identifier
    // Zero or more digits, followed by a letter or hyphen, and then zero or
    // more letters, digits, or hyphens.

    createToken('NONNUMERICIDENTIFIER', '\\d*[a-zA-Z-][a-zA-Z0-9-]*'); // ## Main Version
    // Three dot-separated numeric identifiers.

    createToken('MAINVERSION', "(".concat(src[t.NUMERICIDENTIFIER], ")\\.") + "(".concat(src[t.NUMERICIDENTIFIER], ")\\.") + "(".concat(src[t.NUMERICIDENTIFIER], ")"));
    createToken('MAINVERSIONLOOSE', "(".concat(src[t.NUMERICIDENTIFIERLOOSE], ")\\.") + "(".concat(src[t.NUMERICIDENTIFIERLOOSE], ")\\.") + "(".concat(src[t.NUMERICIDENTIFIERLOOSE], ")")); // ## Pre-release Version Identifier
    // A numeric identifier, or a non-numeric identifier.

    createToken('PRERELEASEIDENTIFIER', "(?:".concat(src[t.NUMERICIDENTIFIER], "|").concat(src[t.NONNUMERICIDENTIFIER], ")"));
    createToken('PRERELEASEIDENTIFIERLOOSE', "(?:".concat(src[t.NUMERICIDENTIFIERLOOSE], "|").concat(src[t.NONNUMERICIDENTIFIER], ")")); // ## Pre-release Version
    // Hyphen, followed by one or more dot-separated pre-release version
    // identifiers.

    createToken('PRERELEASE', "(?:-(".concat(src[t.PRERELEASEIDENTIFIER], "(?:\\.").concat(src[t.PRERELEASEIDENTIFIER], ")*))"));
    createToken('PRERELEASELOOSE', "(?:-?(".concat(src[t.PRERELEASEIDENTIFIERLOOSE], "(?:\\.").concat(src[t.PRERELEASEIDENTIFIERLOOSE], ")*))")); // ## Build Metadata Identifier
    // Any combination of digits, letters, or hyphens.

    createToken('BUILDIDENTIFIER', '[0-9A-Za-z-]+'); // ## Build Metadata
    // Plus sign, followed by one or more period-separated build metadata
    // identifiers.

    createToken('BUILD', "(?:\\+(".concat(src[t.BUILDIDENTIFIER], "(?:\\.").concat(src[t.BUILDIDENTIFIER], ")*))")); // ## Full Version String
    // A main version, followed optionally by a pre-release version and
    // build metadata.
    // Note that the only major, minor, patch, and pre-release sections of
    // the version string are capturing groups.  The build metadata is not a
    // capturing group, because it should not ever be used in version
    // comparison.

    createToken('FULLPLAIN', "v?".concat(src[t.MAINVERSION]).concat(src[t.PRERELEASE], "?").concat(src[t.BUILD], "?"));
    createToken('FULL', "^".concat(src[t.FULLPLAIN], "$")); // like full, but allows v1.2.3 and =1.2.3, which people do sometimes.
    // also, 1.0.0alpha1 (prerelease without the hyphen) which is pretty
    // common in the npm registry.

    createToken('LOOSEPLAIN', "[v=\\s]*".concat(src[t.MAINVERSIONLOOSE]).concat(src[t.PRERELEASELOOSE], "?").concat(src[t.BUILD], "?"));
    createToken('LOOSE', "^".concat(src[t.LOOSEPLAIN], "$"));
    createToken('GTLT', '((?:<|>)?=?)'); // Something like "2.*" or "1.2.x".
    // Note that "x.x" is a valid xRange identifer, meaning "any version"
    // Only the first item is strictly required.

    createToken('XRANGEIDENTIFIERLOOSE', "".concat(src[t.NUMERICIDENTIFIERLOOSE], "|x|X|\\*"));
    createToken('XRANGEIDENTIFIER', "".concat(src[t.NUMERICIDENTIFIER], "|x|X|\\*"));
    createToken('XRANGEPLAIN', "[v=\\s]*(".concat(src[t.XRANGEIDENTIFIER], ")") + "(?:\\.(".concat(src[t.XRANGEIDENTIFIER], ")") + "(?:\\.(".concat(src[t.XRANGEIDENTIFIER], ")") + "(?:".concat(src[t.PRERELEASE], ")?").concat(src[t.BUILD], "?") + ")?)?");
    createToken('XRANGEPLAINLOOSE', "[v=\\s]*(".concat(src[t.XRANGEIDENTIFIERLOOSE], ")") + "(?:\\.(".concat(src[t.XRANGEIDENTIFIERLOOSE], ")") + "(?:\\.(".concat(src[t.XRANGEIDENTIFIERLOOSE], ")") + "(?:".concat(src[t.PRERELEASELOOSE], ")?").concat(src[t.BUILD], "?") + ")?)?");
    createToken('XRANGE', "^".concat(src[t.GTLT], "\\s*").concat(src[t.XRANGEPLAIN], "$"));
    createToken('XRANGELOOSE', "^".concat(src[t.GTLT], "\\s*").concat(src[t.XRANGEPLAINLOOSE], "$")); // Coercion.
    // Extract anything that could conceivably be a part of a valid semver

    createToken('COERCE', "".concat('(^|[^\\d])' + '(\\d{1,').concat(MAX_SAFE_COMPONENT_LENGTH, "})") + "(?:\\.(\\d{1,".concat(MAX_SAFE_COMPONENT_LENGTH, "}))?") + "(?:\\.(\\d{1,".concat(MAX_SAFE_COMPONENT_LENGTH, "}))?") + "(?:$|[^\\d])");
    createToken('COERCERTL', src[t.COERCE], true); // Tilde ranges.
    // Meaning is "reasonably at or greater than"

    createToken('LONETILDE', '(?:~>?)');
    createToken('TILDETRIM', "(\\s*)".concat(src[t.LONETILDE], "\\s+"), true);
    exports.tildeTrimReplace = '$1~';
    createToken('TILDE', "^".concat(src[t.LONETILDE]).concat(src[t.XRANGEPLAIN], "$"));
    createToken('TILDELOOSE', "^".concat(src[t.LONETILDE]).concat(src[t.XRANGEPLAINLOOSE], "$")); // Caret ranges.
    // Meaning is "at least and backwards compatible with"

    createToken('LONECARET', '(?:\\^)');
    createToken('CARETTRIM', "(\\s*)".concat(src[t.LONECARET], "\\s+"), true);
    exports.caretTrimReplace = '$1^';
    createToken('CARET', "^".concat(src[t.LONECARET]).concat(src[t.XRANGEPLAIN], "$"));
    createToken('CARETLOOSE', "^".concat(src[t.LONECARET]).concat(src[t.XRANGEPLAINLOOSE], "$")); // A simple gt/lt/eq thing, or just "" to indicate "any version"

    createToken('COMPARATORLOOSE', "^".concat(src[t.GTLT], "\\s*(").concat(src[t.LOOSEPLAIN], ")$|^$"));
    createToken('COMPARATOR', "^".concat(src[t.GTLT], "\\s*(").concat(src[t.FULLPLAIN], ")$|^$")); // An expression to strip any whitespace between the gtlt and the thing
    // it modifies, so that `> 1.2.3` ==> `>1.2.3`

    createToken('COMPARATORTRIM', "(\\s*)".concat(src[t.GTLT], "\\s*(").concat(src[t.LOOSEPLAIN], "|").concat(src[t.XRANGEPLAIN], ")"), true);
    exports.comparatorTrimReplace = '$1$2$3'; // Something like `1.2.3 - 1.2.4`
    // Note that these all use the loose form, because they'll be
    // checked against either the strict or loose comparator form
    // later.

    createToken('HYPHENRANGE', "^\\s*(".concat(src[t.XRANGEPLAIN], ")") + "\\s+-\\s+" + "(".concat(src[t.XRANGEPLAIN], ")") + "\\s*$");
    createToken('HYPHENRANGELOOSE', "^\\s*(".concat(src[t.XRANGEPLAINLOOSE], ")") + "\\s+-\\s+" + "(".concat(src[t.XRANGEPLAINLOOSE], ")") + "\\s*$"); // Star ranges basically just allow anything at all.

    createToken('STAR', '(<|>)?=?\\s*\\*'); // >=0.0.0 is like a star

    createToken('GTE0', '^\\s*>=\\s*0\.0\.0\\s*$');
    createToken('GTE0PRE', '^\\s*>=\\s*0\.0\.0-0\\s*$');
  });
  var re_2 = re_1.re;
  var re_3 = re_1.src;
  var re_4 = re_1.t;
  var re_5 = re_1.tildeTrimReplace;
  var re_6 = re_1.caretTrimReplace;
  var re_7 = re_1.comparatorTrimReplace;
  var numeric = /^[0-9]+$/;

  var compareIdentifiers = function compareIdentifiers(a, b) {
    var anum = numeric.test(a);
    var bnum = numeric.test(b);

    if (anum && bnum) {
      a = +a;
      b = +b;
    }

    return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
  };

  var rcompareIdentifiers = function rcompareIdentifiers(a, b) {
    return compareIdentifiers(b, a);
  };

  var identifiers = {
    compareIdentifiers: compareIdentifiers,
    rcompareIdentifiers: rcompareIdentifiers
  };
  var MAX_LENGTH$1 = constants.MAX_LENGTH,
      MAX_SAFE_INTEGER$1 = constants.MAX_SAFE_INTEGER;
  var re = re_1.re,
      t = re_1.t;
  var compareIdentifiers$1 = identifiers.compareIdentifiers;

  var SemVer = /*#__PURE__*/function () {
    function SemVer(version, options) {
      _classCallCheck(this, SemVer);

      if (!options || _typeof(options) !== 'object') {
        options = {
          loose: !!options,
          includePrerelease: false
        };
      }

      if (version instanceof SemVer) {
        if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
          return version;
        } else {
          version = version.version;
        }
      } else if (typeof version !== 'string') {
        throw new TypeError("Invalid Version: ".concat(version));
      }

      if (version.length > MAX_LENGTH$1) {
        throw new TypeError("version is longer than ".concat(MAX_LENGTH$1, " characters"));
      }

      debug_1('SemVer', version, options);
      this.options = options;
      this.loose = !!options.loose; // this isn't actually relevant for versions, but keep it so that we
      // don't run into trouble passing this.options around.

      this.includePrerelease = !!options.includePrerelease;
      var m = version.trim().match(options.loose ? re[t.LOOSE] : re[t.FULL]);

      if (!m) {
        throw new TypeError("Invalid Version: ".concat(version));
      }

      this.raw = version; // these are actually numbers

      this.major = +m[1];
      this.minor = +m[2];
      this.patch = +m[3];

      if (this.major > MAX_SAFE_INTEGER$1 || this.major < 0) {
        throw new TypeError('Invalid major version');
      }

      if (this.minor > MAX_SAFE_INTEGER$1 || this.minor < 0) {
        throw new TypeError('Invalid minor version');
      }

      if (this.patch > MAX_SAFE_INTEGER$1 || this.patch < 0) {
        throw new TypeError('Invalid patch version');
      } // numberify any prerelease numeric ids


      if (!m[4]) {
        this.prerelease = [];
      } else {
        this.prerelease = m[4].split('.').map(function (id) {
          if (/^[0-9]+$/.test(id)) {
            var num = +id;

            if (num >= 0 && num < MAX_SAFE_INTEGER$1) {
              return num;
            }
          }

          return id;
        });
      }

      this.build = m[5] ? m[5].split('.') : [];
      this.format();
    }

    _createClass(SemVer, [{
      key: "format",
      value: function format() {
        this.version = "".concat(this.major, ".").concat(this.minor, ".").concat(this.patch);

        if (this.prerelease.length) {
          this.version += "-".concat(this.prerelease.join('.'));
        }

        return this.version;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.version;
      }
    }, {
      key: "compare",
      value: function compare(other) {
        debug_1('SemVer.compare', this.version, this.options, other);

        if (!(other instanceof SemVer)) {
          if (typeof other === 'string' && other === this.version) {
            return 0;
          }

          other = new SemVer(other, this.options);
        }

        if (other.version === this.version) {
          return 0;
        }

        return this.compareMain(other) || this.comparePre(other);
      }
    }, {
      key: "compareMain",
      value: function compareMain(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        }

        return compareIdentifiers$1(this.major, other.major) || compareIdentifiers$1(this.minor, other.minor) || compareIdentifiers$1(this.patch, other.patch);
      }
    }, {
      key: "comparePre",
      value: function comparePre(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        } // NOT having a prerelease is > having one


        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }

        var i = 0;

        do {
          var a = this.prerelease[i];
          var b = other.prerelease[i];
          debug_1('prerelease compare', i, a, b);

          if (a === undefined && b === undefined) {
            return 0;
          } else if (b === undefined) {
            return 1;
          } else if (a === undefined) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers$1(a, b);
          }
        } while (++i);
      }
    }, {
      key: "compareBuild",
      value: function compareBuild(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        }

        var i = 0;

        do {
          var a = this.build[i];
          var b = other.build[i];
          debug_1('prerelease compare', i, a, b);

          if (a === undefined && b === undefined) {
            return 0;
          } else if (b === undefined) {
            return 1;
          } else if (a === undefined) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers$1(a, b);
          }
        } while (++i);
      } // preminor will bump the version up to the next minor release, and immediately
      // down to pre-release. premajor and prepatch work the same way.

    }, {
      key: "inc",
      value: function inc(release, identifier) {
        switch (release) {
          case 'premajor':
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc('pre', identifier);
            break;

          case 'preminor':
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc('pre', identifier);
            break;

          case 'prepatch':
            // If this is already a prerelease, it will bump to the next version
            // drop any prereleases that might already exist, since they are not
            // relevant at this point.
            this.prerelease.length = 0;
            this.inc('patch', identifier);
            this.inc('pre', identifier);
            break;
          // If the input is a non-prerelease version, this acts the same as
          // prepatch.

          case 'prerelease':
            if (this.prerelease.length === 0) {
              this.inc('patch', identifier);
            }

            this.inc('pre', identifier);
            break;

          case 'major':
            // If this is a pre-major version, bump up to the same major version.
            // Otherwise increment major.
            // 1.0.0-5 bumps to 1.0.0
            // 1.1.0 bumps to 2.0.0
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }

            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;

          case 'minor':
            // If this is a pre-minor version, bump up to the same minor version.
            // Otherwise increment minor.
            // 1.2.0-5 bumps to 1.2.0
            // 1.2.1 bumps to 1.3.0
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }

            this.patch = 0;
            this.prerelease = [];
            break;

          case 'patch':
            // If this is not a pre-release version, it will increment the patch.
            // If it is a pre-release it will bump up to the same patch version.
            // 1.2.0-5 patches to 1.2.0
            // 1.2.0 patches to 1.2.1
            if (this.prerelease.length === 0) {
              this.patch++;
            }

            this.prerelease = [];
            break;
          // This probably shouldn't be used publicly.
          // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.

          case 'pre':
            if (this.prerelease.length === 0) {
              this.prerelease = [0];
            } else {
              var i = this.prerelease.length;

              while (--i >= 0) {
                if (typeof this.prerelease[i] === 'number') {
                  this.prerelease[i]++;
                  i = -2;
                }
              }

              if (i === -1) {
                // didn't increment anything
                this.prerelease.push(0);
              }
            }

            if (identifier) {
              // 1.2.0-beta.1 bumps to 1.2.0-beta.2,
              // 1.2.0-beta.fooblz or 1.2.0-beta bumps to 1.2.0-beta.0
              if (this.prerelease[0] === identifier) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = [identifier, 0];
                }
              } else {
                this.prerelease = [identifier, 0];
              }
            }

            break;

          default:
            throw new Error("invalid increment argument: ".concat(release));
        }

        this.format();
        this.raw = this.version;
        return this;
      }
    }]);

    return SemVer;
  }();

  var semver = SemVer;
  var MAX_LENGTH$2 = constants.MAX_LENGTH;
  var re$1 = re_1.re,
      t$1 = re_1.t;

  var parse = function parse(version, options) {
    if (!options || _typeof(options) !== 'object') {
      options = {
        loose: !!options,
        includePrerelease: false
      };
    }

    if (version instanceof semver) {
      return version;
    }

    if (typeof version !== 'string') {
      return null;
    }

    if (version.length > MAX_LENGTH$2) {
      return null;
    }

    var r = options.loose ? re$1[t$1.LOOSE] : re$1[t$1.FULL];

    if (!r.test(version)) {
      return null;
    }

    try {
      return new semver(version, options);
    } catch (er) {
      return null;
    }
  };

  var parse_1 = parse;

  var valid = function valid(version, options) {
    var v = parse_1(version, options);
    return v ? v.version : null;
  };

  var valid_1 = valid;

  var clean = function clean(version, options) {
    var s = parse_1(version.trim().replace(/^[=v]+/, ''), options);
    return s ? s.version : null;
  };

  var clean_1 = clean;

  var inc = function inc(version, release, options, identifier) {
    if (typeof options === 'string') {
      identifier = options;
      options = undefined;
    }

    try {
      return new semver(version, options).inc(release, identifier).version;
    } catch (er) {
      return null;
    }
  };

  var inc_1 = inc;

  var compare$1 = function compare$1(a, b, loose) {
    return new semver(a, loose).compare(new semver(b, loose));
  };

  var compare_1 = compare$1;

  var eq = function eq(a, b, loose) {
    return compare_1(a, b, loose) === 0;
  };

  var eq_1 = eq;

  var diff = function diff(version1, version2) {
    if (eq_1(version1, version2)) {
      return null;
    } else {
      var v1 = parse_1(version1);
      var v2 = parse_1(version2);
      var hasPre = v1.prerelease.length || v2.prerelease.length;
      var prefix = hasPre ? 'pre' : '';
      var defaultResult = hasPre ? 'prerelease' : '';

      for (var key in v1) {
        if (key === 'major' || key === 'minor' || key === 'patch') {
          if (v1[key] !== v2[key]) {
            return prefix + key;
          }
        }
      }

      return defaultResult; // may be undefined
    }
  };

  var diff_1 = diff;

  var major = function major(a, loose) {
    return new semver(a, loose).major;
  };

  var major_1 = major;

  var minor = function minor(a, loose) {
    return new semver(a, loose).minor;
  };

  var minor_1 = minor;

  var patch = function patch(a, loose) {
    return new semver(a, loose).patch;
  };

  var patch_1 = patch;

  var prerelease = function prerelease(version, options) {
    var parsed = parse_1(version, options);
    return parsed && parsed.prerelease.length ? parsed.prerelease : null;
  };

  var prerelease_1 = prerelease;

  var rcompare = function rcompare(a, b, loose) {
    return compare_1(b, a, loose);
  };

  var rcompare_1 = rcompare;

  var compareLoose = function compareLoose(a, b) {
    return compare_1(a, b, true);
  };

  var compareLoose_1 = compareLoose;

  var compareBuild = function compareBuild(a, b, loose) {
    var versionA = new semver(a, loose);
    var versionB = new semver(b, loose);
    return versionA.compare(versionB) || versionA.compareBuild(versionB);
  };

  var compareBuild_1 = compareBuild;

  var sort = function sort(list, loose) {
    return list.sort(function (a, b) {
      return compareBuild_1(a, b, loose);
    });
  };

  var sort_1 = sort;

  var rsort = function rsort(list, loose) {
    return list.sort(function (a, b) {
      return compareBuild_1(b, a, loose);
    });
  };

  var rsort_1 = rsort;

  var gt = function gt(a, b, loose) {
    return compare_1(a, b, loose) > 0;
  };

  var gt_1 = gt;

  var lt = function lt(a, b, loose) {
    return compare_1(a, b, loose) < 0;
  };

  var lt_1 = lt;

  var neq = function neq(a, b, loose) {
    return compare_1(a, b, loose) !== 0;
  };

  var neq_1 = neq;

  var gte = function gte(a, b, loose) {
    return compare_1(a, b, loose) >= 0;
  };

  var gte_1 = gte;

  var lte = function lte(a, b, loose) {
    return compare_1(a, b, loose) <= 0;
  };

  var lte_1 = lte;

  var cmp = function cmp(a, op, b, loose) {
    switch (op) {
      case '===':
        if (_typeof(a) === 'object') a = a.version;
        if (_typeof(b) === 'object') b = b.version;
        return a === b;

      case '!==':
        if (_typeof(a) === 'object') a = a.version;
        if (_typeof(b) === 'object') b = b.version;
        return a !== b;

      case '':
      case '=':
      case '==':
        return eq_1(a, b, loose);

      case '!=':
        return neq_1(a, b, loose);

      case '>':
        return gt_1(a, b, loose);

      case '>=':
        return gte_1(a, b, loose);

      case '<':
        return lt_1(a, b, loose);

      case '<=':
        return lte_1(a, b, loose);

      default:
        throw new TypeError("Invalid operator: ".concat(op));
    }
  };

  var cmp_1 = cmp;
  var re$2 = re_1.re,
      t$2 = re_1.t;

  var coerce = function coerce(version, options) {
    if (version instanceof semver) {
      return version;
    }

    if (typeof version === 'number') {
      version = String(version);
    }

    if (typeof version !== 'string') {
      return null;
    }

    options = options || {};
    var match = null;

    if (!options.rtl) {
      match = version.match(re$2[t$2.COERCE]);
    } else {
      // Find the right-most coercible string that does not share
      // a terminus with a more left-ward coercible string.
      // Eg, '1.2.3.4' wants to coerce '2.3.4', not '3.4' or '4'
      //
      // Walk through the string checking with a /g regexp
      // Manually set the index so as to pick up overlapping matches.
      // Stop when we get a match that ends at the string end, since no
      // coercible string can be more right-ward without the same terminus.
      var next;

      while ((next = re$2[t$2.COERCERTL].exec(version)) && (!match || match.index + match[0].length !== version.length)) {
        if (!match || next.index + next[0].length !== match.index + match[0].length) {
          match = next;
        }

        re$2[t$2.COERCERTL].lastIndex = next.index + next[1].length + next[2].length;
      } // leave it in a clean state


      re$2[t$2.COERCERTL].lastIndex = -1;
    }

    if (match === null) return null;
    return parse_1("".concat(match[2], ".").concat(match[3] || '0', ".").concat(match[4] || '0'), options);
  };

  var coerce_1 = coerce; // hoisted class for cyclic dependency

  var Range = /*#__PURE__*/function () {
    function Range(range, options) {
      var _this2 = this;

      _classCallCheck(this, Range);

      if (!options || _typeof(options) !== 'object') {
        options = {
          loose: !!options,
          includePrerelease: false
        };
      }

      if (range instanceof Range) {
        if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
          return range;
        } else {
          return new Range(range.raw, options);
        }
      }

      if (range instanceof comparator) {
        // just put it in the set and return
        this.raw = range.value;
        this.set = [[range]];
        this.format();
        return this;
      }

      this.options = options;
      this.loose = !!options.loose;
      this.includePrerelease = !!options.includePrerelease; // First, split based on boolean or ||

      this.raw = range;
      this.set = range.split(/\s*\|\|\s*/) // map the range to a 2d array of comparators
      .map(function (range) {
        return _this2.parseRange(range.trim());
      }) // throw out any comparator lists that are empty
      // this generally means that it was not a valid range, which is allowed
      // in loose mode, but will still throw if the WHOLE range is invalid.
      .filter(function (c) {
        return c.length;
      });

      if (!this.set.length) {
        throw new TypeError("Invalid SemVer Range: ".concat(range));
      }

      this.format();
    }

    _createClass(Range, [{
      key: "format",
      value: function format() {
        this.range = this.set.map(function (comps) {
          return comps.join(' ').trim();
        }).join('||').trim();
        return this.range;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.range;
      }
    }, {
      key: "parseRange",
      value: function parseRange(range) {
        var _this3 = this;

        var loose = this.options.loose;
        range = range.trim(); // `1.2.3 - 1.2.4` => `>=1.2.3 <=1.2.4`

        var hr = loose ? re$3[t$3.HYPHENRANGELOOSE] : re$3[t$3.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug_1('hyphen replace', range); // `> 1.2.3 < 1.2.5` => `>1.2.3 <1.2.5`

        range = range.replace(re$3[t$3.COMPARATORTRIM], comparatorTrimReplace);
        debug_1('comparator trim', range, re$3[t$3.COMPARATORTRIM]); // `~ 1.2.3` => `~1.2.3`

        range = range.replace(re$3[t$3.TILDETRIM], tildeTrimReplace); // `^ 1.2.3` => `^1.2.3`

        range = range.replace(re$3[t$3.CARETTRIM], caretTrimReplace); // normalize spaces

        range = range.split(/\s+/).join(' '); // At this point, the range is completely trimmed and
        // ready to be split into comparators.

        var compRe = loose ? re$3[t$3.COMPARATORLOOSE] : re$3[t$3.COMPARATOR];
        return range.split(' ').map(function (comp) {
          return parseComparator(comp, _this3.options);
        }).join(' ').split(/\s+/).map(function (comp) {
          return replaceGTE0(comp, _this3.options);
        }) // in loose mode, throw out any that are not valid comparators
        .filter(this.options.loose ? function (comp) {
          return !!comp.match(compRe);
        } : function () {
          return true;
        }).map(function (comp) {
          return new comparator(comp, _this3.options);
        });
      }
    }, {
      key: "intersects",
      value: function intersects(range, options) {
        if (!(range instanceof Range)) {
          throw new TypeError('a Range is required');
        }

        return this.set.some(function (thisComparators) {
          return isSatisfiable(thisComparators, options) && range.set.some(function (rangeComparators) {
            return isSatisfiable(rangeComparators, options) && thisComparators.every(function (thisComparator) {
              return rangeComparators.every(function (rangeComparator) {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      } // if ANY of the sets match ALL of its comparators, then pass

    }, {
      key: "test",
      value: function test(version) {
        if (!version) {
          return false;
        }

        if (typeof version === 'string') {
          try {
            version = new semver(version, this.options);
          } catch (er) {
            return false;
          }
        }

        for (var i = 0; i < this.set.length; i++) {
          if (testSet(this.set[i], version, this.options)) {
            return true;
          }
        }

        return false;
      }
    }]);

    return Range;
  }();

  var range = Range;
  var re$3 = re_1.re,
      t$3 = re_1.t,
      comparatorTrimReplace = re_1.comparatorTrimReplace,
      tildeTrimReplace = re_1.tildeTrimReplace,
      caretTrimReplace = re_1.caretTrimReplace; // take a set of comparators and determine whether there
  // exists a version which can satisfy it

  var isSatisfiable = function isSatisfiable(comparators, options) {
    var result = true;
    var remainingComparators = comparators.slice();
    var testComparator = remainingComparators.pop();

    while (result && remainingComparators.length) {
      result = remainingComparators.every(function (otherComparator) {
        return testComparator.intersects(otherComparator, options);
      });
      testComparator = remainingComparators.pop();
    }

    return result;
  }; // comprised of xranges, tildes, stars, and gtlt's at this point.
  // already replaced the hyphen ranges
  // turn into a set of JUST comparators.


  var parseComparator = function parseComparator(comp, options) {
    debug_1('comp', comp, options);
    comp = replaceCarets(comp, options);
    debug_1('caret', comp);
    comp = replaceTildes(comp, options);
    debug_1('tildes', comp);
    comp = replaceXRanges(comp, options);
    debug_1('xrange', comp);
    comp = replaceStars(comp, options);
    debug_1('stars', comp);
    return comp;
  };

  var isX = function isX(id) {
    return !id || id.toLowerCase() === 'x' || id === '*';
  }; // ~, ~> --> * (any, kinda silly)
  // ~2, ~2.x, ~2.x.x, ~>2, ~>2.x ~>2.x.x --> >=2.0.0 <3.0.0-0
  // ~2.0, ~2.0.x, ~>2.0, ~>2.0.x --> >=2.0.0 <2.1.0-0
  // ~1.2, ~1.2.x, ~>1.2, ~>1.2.x --> >=1.2.0 <1.3.0-0
  // ~1.2.3, ~>1.2.3 --> >=1.2.3 <1.3.0-0
  // ~1.2.0, ~>1.2.0 --> >=1.2.0 <1.3.0-0


  var replaceTildes = function replaceTildes(comp, options) {
    return comp.trim().split(/\s+/).map(function (comp) {
      return replaceTilde(comp, options);
    }).join(' ');
  };

  var replaceTilde = function replaceTilde(comp, options) {
    var r = options.loose ? re$3[t$3.TILDELOOSE] : re$3[t$3.TILDE];
    return comp.replace(r, function (_, M, m, p, pr) {
      debug_1('tilde', comp, _, M, m, p, pr);
      var ret;

      if (isX(M)) {
        ret = '';
      } else if (isX(m)) {
        ret = ">=".concat(M, ".0.0 <").concat(+M + 1, ".0.0-0");
      } else if (isX(p)) {
        // ~1.2 == >=1.2.0 <1.3.0-0
        ret = ">=".concat(M, ".").concat(m, ".0 <").concat(M, ".").concat(+m + 1, ".0-0");
      } else if (pr) {
        debug_1('replaceTilde pr', pr);
        ret = ">=".concat(M, ".").concat(m, ".").concat(p, "-").concat(pr, " <").concat(M, ".").concat(+m + 1, ".0-0");
      } else {
        // ~1.2.3 == >=1.2.3 <1.3.0-0
        ret = ">=".concat(M, ".").concat(m, ".").concat(p, " <").concat(M, ".").concat(+m + 1, ".0-0");
      }

      debug_1('tilde return', ret);
      return ret;
    });
  }; // ^ --> * (any, kinda silly)
  // ^2, ^2.x, ^2.x.x --> >=2.0.0 <3.0.0-0
  // ^2.0, ^2.0.x --> >=2.0.0 <3.0.0-0
  // ^1.2, ^1.2.x --> >=1.2.0 <2.0.0-0
  // ^1.2.3 --> >=1.2.3 <2.0.0-0
  // ^1.2.0 --> >=1.2.0 <2.0.0-0


  var replaceCarets = function replaceCarets(comp, options) {
    return comp.trim().split(/\s+/).map(function (comp) {
      return replaceCaret(comp, options);
    }).join(' ');
  };

  var replaceCaret = function replaceCaret(comp, options) {
    debug_1('caret', comp, options);
    var r = options.loose ? re$3[t$3.CARETLOOSE] : re$3[t$3.CARET];
    var z = options.includePrerelease ? '-0' : '';
    return comp.replace(r, function (_, M, m, p, pr) {
      debug_1('caret', comp, _, M, m, p, pr);
      var ret;

      if (isX(M)) {
        ret = '';
      } else if (isX(m)) {
        ret = ">=".concat(M, ".0.0").concat(z, " <").concat(+M + 1, ".0.0-0");
      } else if (isX(p)) {
        if (M === '0') {
          ret = ">=".concat(M, ".").concat(m, ".0").concat(z, " <").concat(M, ".").concat(+m + 1, ".0-0");
        } else {
          ret = ">=".concat(M, ".").concat(m, ".0").concat(z, " <").concat(+M + 1, ".0.0-0");
        }
      } else if (pr) {
        debug_1('replaceCaret pr', pr);

        if (M === '0') {
          if (m === '0') {
            ret = ">=".concat(M, ".").concat(m, ".").concat(p, "-").concat(pr, " <").concat(M, ".").concat(m, ".").concat(+p + 1, "-0");
          } else {
            ret = ">=".concat(M, ".").concat(m, ".").concat(p, "-").concat(pr, " <").concat(M, ".").concat(+m + 1, ".0-0");
          }
        } else {
          ret = ">=".concat(M, ".").concat(m, ".").concat(p, "-").concat(pr, " <").concat(+M + 1, ".0.0-0");
        }
      } else {
        debug_1('no pr');

        if (M === '0') {
          if (m === '0') {
            ret = ">=".concat(M, ".").concat(m, ".").concat(p).concat(z, " <").concat(M, ".").concat(m, ".").concat(+p + 1, "-0");
          } else {
            ret = ">=".concat(M, ".").concat(m, ".").concat(p).concat(z, " <").concat(M, ".").concat(+m + 1, ".0-0");
          }
        } else {
          ret = ">=".concat(M, ".").concat(m, ".").concat(p, " <").concat(+M + 1, ".0.0-0");
        }
      }

      debug_1('caret return', ret);
      return ret;
    });
  };

  var replaceXRanges = function replaceXRanges(comp, options) {
    debug_1('replaceXRanges', comp, options);
    return comp.split(/\s+/).map(function (comp) {
      return replaceXRange(comp, options);
    }).join(' ');
  };

  var replaceXRange = function replaceXRange(comp, options) {
    comp = comp.trim();
    var r = options.loose ? re$3[t$3.XRANGELOOSE] : re$3[t$3.XRANGE];
    return comp.replace(r, function (ret, gtlt, M, m, p, pr) {
      debug_1('xRange', comp, ret, gtlt, M, m, p, pr);
      var xM = isX(M);
      var xm = xM || isX(m);
      var xp = xm || isX(p);
      var anyX = xp;

      if (gtlt === '=' && anyX) {
        gtlt = '';
      } // if we're including prereleases in the match, then we need
      // to fix this to -0, the lowest possible prerelease value


      pr = options.includePrerelease ? '-0' : '';

      if (xM) {
        if (gtlt === '>' || gtlt === '<') {
          // nothing is allowed
          ret = '<0.0.0-0';
        } else {
          // nothing is forbidden
          ret = '*';
        }
      } else if (gtlt && anyX) {
        // we know patch is an x, because we have any x at all.
        // replace X with 0
        if (xm) {
          m = 0;
        }

        p = 0;

        if (gtlt === '>') {
          // >1 => >=2.0.0
          // >1.2 => >=1.3.0
          gtlt = '>=';

          if (xm) {
            M = +M + 1;
            m = 0;
            p = 0;
          } else {
            m = +m + 1;
            p = 0;
          }
        } else if (gtlt === '<=') {
          // <=0.7.x is actually <0.8.0, since any 0.7.x should
          // pass.  Similarly, <=7.x is actually <8.0.0, etc.
          gtlt = '<';

          if (xm) {
            M = +M + 1;
          } else {
            m = +m + 1;
          }
        }

        if (gtlt === '<') pr = '-0';
        ret = "".concat(gtlt + M, ".").concat(m, ".").concat(p).concat(pr);
      } else if (xm) {
        ret = ">=".concat(M, ".0.0").concat(pr, " <").concat(+M + 1, ".0.0-0");
      } else if (xp) {
        ret = ">=".concat(M, ".").concat(m, ".0").concat(pr, " <").concat(M, ".").concat(+m + 1, ".0-0");
      }

      debug_1('xRange return', ret);
      return ret;
    });
  }; // Because * is AND-ed with everything else in the comparator,
  // and '' means "any version", just remove the *s entirely.


  var replaceStars = function replaceStars(comp, options) {
    debug_1('replaceStars', comp, options); // Looseness is ignored here.  star is always as loose as it gets!

    return comp.trim().replace(re$3[t$3.STAR], '');
  };

  var replaceGTE0 = function replaceGTE0(comp, options) {
    debug_1('replaceGTE0', comp, options);
    return comp.trim().replace(re$3[options.includePrerelease ? t$3.GTE0PRE : t$3.GTE0], '');
  }; // This function is passed to string.replace(re[t.HYPHENRANGE])
  // M, m, patch, prerelease, build
  // 1.2 - 3.4.5 => >=1.2.0 <=3.4.5
  // 1.2.3 - 3.4 => >=1.2.0 <3.5.0-0 Any 3.4.x will do
  // 1.2 - 3.4 => >=1.2.0 <3.5.0-0


  var hyphenReplace = function hyphenReplace(incPr) {
    return function ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) {
      if (isX(fM)) {
        from = '';
      } else if (isX(fm)) {
        from = ">=".concat(fM, ".0.0").concat(incPr ? '-0' : '');
      } else if (isX(fp)) {
        from = ">=".concat(fM, ".").concat(fm, ".0").concat(incPr ? '-0' : '');
      } else if (fpr) {
        from = ">=".concat(from);
      } else {
        from = ">=".concat(from).concat(incPr ? '-0' : '');
      }

      if (isX(tM)) {
        to = '';
      } else if (isX(tm)) {
        to = "<".concat(+tM + 1, ".0.0-0");
      } else if (isX(tp)) {
        to = "<".concat(tM, ".").concat(+tm + 1, ".0-0");
      } else if (tpr) {
        to = "<=".concat(tM, ".").concat(tm, ".").concat(tp, "-").concat(tpr);
      } else if (incPr) {
        to = "<".concat(tM, ".").concat(tm, ".").concat(+tp + 1, "-0");
      } else {
        to = "<=".concat(to);
      }

      return "".concat(from, " ").concat(to).trim();
    };
  };

  var testSet = function testSet(set, version, options) {
    for (var i = 0; i < set.length; i++) {
      if (!set[i].test(version)) {
        return false;
      }
    }

    if (version.prerelease.length && !options.includePrerelease) {
      // Find the set of versions that are allowed to have prereleases
      // For example, ^1.2.3-pr.1 desugars to >=1.2.3-pr.1 <2.0.0
      // That should allow `1.2.3-pr.2` to pass.
      // However, `1.2.4-alpha.notready` should NOT be allowed,
      // even though it's within the range set by the comparators.
      for (var _i = 0; _i < set.length; _i++) {
        debug_1(set[_i].semver);

        if (set[_i].semver === comparator.ANY) {
          continue;
        }

        if (set[_i].semver.prerelease.length > 0) {
          var allowed = set[_i].semver;

          if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
            return true;
          }
        }
      } // Version has a -pre, but it's not one of the ones we like.


      return false;
    }

    return true;
  };

  var ANY = Symbol('SemVer ANY'); // hoisted class for cyclic dependency

  var Comparator = /*#__PURE__*/function () {
    _createClass(Comparator, null, [{
      key: "ANY",
      get: function get() {
        return ANY;
      }
    }]);

    function Comparator(comp, options) {
      _classCallCheck(this, Comparator);

      if (!options || _typeof(options) !== 'object') {
        options = {
          loose: !!options,
          includePrerelease: false
        };
      }

      if (comp instanceof Comparator) {
        if (comp.loose === !!options.loose) {
          return comp;
        } else {
          comp = comp.value;
        }
      }

      debug_1('comparator', comp, options);
      this.options = options;
      this.loose = !!options.loose;
      this.parse(comp);

      if (this.semver === ANY) {
        this.value = '';
      } else {
        this.value = this.operator + this.semver.version;
      }

      debug_1('comp', this);
    }

    _createClass(Comparator, [{
      key: "parse",
      value: function parse(comp) {
        var r = this.options.loose ? re$4[t$4.COMPARATORLOOSE] : re$4[t$4.COMPARATOR];
        var m = comp.match(r);

        if (!m) {
          throw new TypeError("Invalid comparator: ".concat(comp));
        }

        this.operator = m[1] !== undefined ? m[1] : '';

        if (this.operator === '=') {
          this.operator = '';
        } // if it literally is just '>' or '' then allow anything.


        if (!m[2]) {
          this.semver = ANY;
        } else {
          this.semver = new semver(m[2], this.options.loose);
        }
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.value;
      }
    }, {
      key: "test",
      value: function test(version) {
        debug_1('Comparator.test', version, this.options.loose);

        if (this.semver === ANY || version === ANY) {
          return true;
        }

        if (typeof version === 'string') {
          try {
            version = new semver(version, this.options);
          } catch (er) {
            return false;
          }
        }

        return cmp_1(version, this.operator, this.semver, this.options);
      }
    }, {
      key: "intersects",
      value: function intersects(comp, options) {
        if (!(comp instanceof Comparator)) {
          throw new TypeError('a Comparator is required');
        }

        if (!options || _typeof(options) !== 'object') {
          options = {
            loose: !!options,
            includePrerelease: false
          };
        }

        if (this.operator === '') {
          if (this.value === '') {
            return true;
          }

          return new range(comp.value, options).test(this.value);
        } else if (comp.operator === '') {
          if (comp.value === '') {
            return true;
          }

          return new range(this.value, options).test(comp.semver);
        }

        var sameDirectionIncreasing = (this.operator === '>=' || this.operator === '>') && (comp.operator === '>=' || comp.operator === '>');
        var sameDirectionDecreasing = (this.operator === '<=' || this.operator === '<') && (comp.operator === '<=' || comp.operator === '<');
        var sameSemVer = this.semver.version === comp.semver.version;
        var differentDirectionsInclusive = (this.operator === '>=' || this.operator === '<=') && (comp.operator === '>=' || comp.operator === '<=');
        var oppositeDirectionsLessThan = cmp_1(this.semver, '<', comp.semver, options) && (this.operator === '>=' || this.operator === '>') && (comp.operator === '<=' || comp.operator === '<');
        var oppositeDirectionsGreaterThan = cmp_1(this.semver, '>', comp.semver, options) && (this.operator === '<=' || this.operator === '<') && (comp.operator === '>=' || comp.operator === '>');
        return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
      }
    }]);

    return Comparator;
  }();

  var comparator = Comparator;
  var re$4 = re_1.re,
      t$4 = re_1.t;

  var satisfies = function satisfies(version, range$1, options) {
    try {
      range$1 = new range(range$1, options);
    } catch (er) {
      return false;
    }

    return range$1.test(version);
  };

  var satisfies_1 = satisfies; // Mostly just for testing and legacy API reasons

  var toComparators = function toComparators(range$1, options) {
    return new range(range$1, options).set.map(function (comp) {
      return comp.map(function (c) {
        return c.value;
      }).join(' ').trim().split(' ');
    });
  };

  var toComparators_1 = toComparators;

  var maxSatisfying = function maxSatisfying(versions, range$1, options) {
    var max = null;
    var maxSV = null;
    var rangeObj = null;

    try {
      rangeObj = new range(range$1, options);
    } catch (er) {
      return null;
    }

    versions.forEach(function (v) {
      if (rangeObj.test(v)) {
        // satisfies(v, range, options)
        if (!max || maxSV.compare(v) === -1) {
          // compare(max, v, true)
          max = v;
          maxSV = new semver(max, options);
        }
      }
    });
    return max;
  };

  var maxSatisfying_1 = maxSatisfying;

  var minSatisfying = function minSatisfying(versions, range$1, options) {
    var min = null;
    var minSV = null;
    var rangeObj = null;

    try {
      rangeObj = new range(range$1, options);
    } catch (er) {
      return null;
    }

    versions.forEach(function (v) {
      if (rangeObj.test(v)) {
        // satisfies(v, range, options)
        if (!min || minSV.compare(v) === 1) {
          // compare(min, v, true)
          min = v;
          minSV = new semver(min, options);
        }
      }
    });
    return min;
  };

  var minSatisfying_1 = minSatisfying;

  var minVersion = function minVersion(range$1, loose) {
    range$1 = new range(range$1, loose);
    var minver = new semver('0.0.0');

    if (range$1.test(minver)) {
      return minver;
    }

    minver = new semver('0.0.0-0');

    if (range$1.test(minver)) {
      return minver;
    }

    minver = null;

    for (var i = 0; i < range$1.set.length; ++i) {
      var comparators = range$1.set[i];
      comparators.forEach(function (comparator) {
        // Clone to avoid manipulating the comparator's semver object.
        var compver = new semver(comparator.semver.version);

        switch (comparator.operator) {
          case '>':
            if (compver.prerelease.length === 0) {
              compver.patch++;
            } else {
              compver.prerelease.push(0);
            }

            compver.raw = compver.format();

          /* fallthrough */

          case '':
          case '>=':
            if (!minver || gt_1(minver, compver)) {
              minver = compver;
            }

            break;

          case '<':
          case '<=':
            /* Ignore maximum versions */
            break;

          /* istanbul ignore next */

          default:
            throw new Error("Unexpected operation: ".concat(comparator.operator));
        }
      });
    }

    if (minver && range$1.test(minver)) {
      return minver;
    }

    return null;
  };

  var minVersion_1 = minVersion;

  var validRange = function validRange(range$1, options) {
    try {
      // Return '*' instead of '' so that truthiness works.
      // This will throw if it's invalid anyway
      return new range(range$1, options).range || '*';
    } catch (er) {
      return null;
    }
  };

  var valid$1 = validRange;
  var ANY$1 = comparator.ANY;

  var outside = function outside(version, range$1, hilo, options) {
    version = new semver(version, options);
    range$1 = new range(range$1, options);
    var gtfn, ltefn, ltfn, comp, ecomp;

    switch (hilo) {
      case '>':
        gtfn = gt_1;
        ltefn = lte_1;
        ltfn = lt_1;
        comp = '>';
        ecomp = '>=';
        break;

      case '<':
        gtfn = lt_1;
        ltefn = gte_1;
        ltfn = gt_1;
        comp = '<';
        ecomp = '<=';
        break;

      default:
        throw new TypeError('Must provide a hilo val of "<" or ">"');
    } // If it satisifes the range it is not outside


    if (satisfies_1(version, range$1, options)) {
      return false;
    } // From now on, variable terms are as if we're in "gtr" mode.
    // but note that everything is flipped for the "ltr" function.


    var _loop = function _loop(i) {
      var comparators = range$1.set[i];
      var high = null;
      var low = null;
      comparators.forEach(function (comparator$1) {
        if (comparator$1.semver === ANY$1) {
          comparator$1 = new comparator('>=0.0.0');
        }

        high = high || comparator$1;
        low = low || comparator$1;

        if (gtfn(comparator$1.semver, high.semver, options)) {
          high = comparator$1;
        } else if (ltfn(comparator$1.semver, low.semver, options)) {
          low = comparator$1;
        }
      }); // If the edge version comparator has a operator then our version
      // isn't outside it

      if (high.operator === comp || high.operator === ecomp) {
        return {
          v: false
        };
      } // If the lowest version comparator has an operator and our version
      // is less than it then it isn't higher than the range


      if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
        return {
          v: false
        };
      } else if (low.operator === ecomp && ltfn(version, low.semver)) {
        return {
          v: false
        };
      }
    };

    for (var i = 0; i < range$1.set.length; ++i) {
      var _ret = _loop(i);

      if (_typeof(_ret) === "object") return _ret.v;
    }

    return true;
  };

  var outside_1 = outside; // Determine if version is greater than all the versions possible in the range.

  var gtr = function gtr(version, range, options) {
    return outside_1(version, range, '>', options);
  };

  var gtr_1 = gtr; // Determine if version is less than all the versions possible in the range

  var ltr = function ltr(version, range, options) {
    return outside_1(version, range, '<', options);
  };

  var ltr_1 = ltr;

  var intersects = function intersects(r1, r2, options) {
    r1 = new range(r1, options);
    r2 = new range(r2, options);
    return r1.intersects(r2);
  };

  var intersects_1 = intersects; // given a set of versions and a range, create a "simplified" range
  // that includes the same versions that the original range does
  // If the original range is shorter than the simplified one, return that.

  var simplify = function simplify(versions, range, options) {
    var set = [];
    var min = null;
    var prev = null;
    var v = versions.sort(function (a, b) {
      return compare_1(a, b, options);
    });

    var _iterator = _createForOfIteratorHelper(v),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _version = _step.value;
        var included = satisfies_1(_version, range, options);

        if (included) {
          prev = _version;
          if (!min) min = _version;
        } else {
          if (prev) {
            set.push([min, prev]);
          }

          prev = null;
          min = null;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    if (min) set.push([min, null]);
    var ranges = [];

    for (var _i2 = 0, _set = set; _i2 < _set.length; _i2++) {
      var _set$_i = _slicedToArray(_set[_i2], 2),
          _min = _set$_i[0],
          max = _set$_i[1];

      if (_min === max) ranges.push(_min);else if (!max && _min === v[0]) ranges.push('*');else if (!max) ranges.push(">=".concat(_min));else if (_min === v[0]) ranges.push("<=".concat(max));else ranges.push("".concat(_min, " - ").concat(max));
    }

    var simplified = ranges.join(' || ');
    var original = typeof range.raw === 'string' ? range.raw : String(range);
    return simplified.length < original.length ? simplified : range;
  };

  var ANY$2 = comparator.ANY; // Complex range `r1 || r2 || ...` is a subset of `R1 || R2 || ...` iff:
  // - Every simple range `r1, r2, ...` is a subset of some `R1, R2, ...`
  //
  // Simple range `c1 c2 ...` is a subset of simple range `C1 C2 ...` iff:
  // - If c is only the ANY comparator
  //   - If C is only the ANY comparator, return true
  //   - Else return false
  // - Let EQ be the set of = comparators in c
  // - If EQ is more than one, return true (null set)
  // - Let GT be the highest > or >= comparator in c
  // - Let LT be the lowest < or <= comparator in c
  // - If GT and LT, and GT.semver > LT.semver, return true (null set)
  // - If EQ
  //   - If GT, and EQ does not satisfy GT, return true (null set)
  //   - If LT, and EQ does not satisfy LT, return true (null set)
  //   - If EQ satisfies every C, return true
  //   - Else return false
  // - If GT
  //   - If GT is lower than any > or >= comp in C, return false
  //   - If GT is >=, and GT.semver does not satisfy every C, return false
  // - If LT
  //   - If LT.semver is greater than that of any > comp in C, return false
  //   - If LT is <=, and LT.semver does not satisfy every C, return false
  // - If any C is a = range, and GT or LT are set, return false
  // - Else return true

  var subset = function subset(sub, dom, options) {
    sub = new range(sub, options);
    dom = new range(dom, options);
    var sawNonNull = false;

    var _iterator2 = _createForOfIteratorHelper(sub.set),
        _step2;

    try {
      OUTER: for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var simpleSub = _step2.value;

        var _iterator3 = _createForOfIteratorHelper(dom.set),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var simpleDom = _step3.value;
            var isSub = simpleSubset(simpleSub, simpleDom, options);
            sawNonNull = sawNonNull || isSub !== null;
            if (isSub) continue OUTER;
          } // the null set is a subset of everything, but null simple ranges in
          // a complex range should be ignored.  so if we saw a non-null range,
          // then we know this isn't a subset, but if EVERY simple range was null,
          // then it is a subset.

        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }

        if (sawNonNull) return false;
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    return true;
  };

  var simpleSubset = function simpleSubset(sub, dom, options) {
    if (sub.length === 1 && sub[0].semver === ANY$2) return dom.length === 1 && dom[0].semver === ANY$2;
    var eqSet = new Set();
    var gt, lt;

    var _iterator4 = _createForOfIteratorHelper(sub),
        _step4;

    try {
      for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
        var c = _step4.value;
        if (c.operator === '>' || c.operator === '>=') gt = higherGT(gt, c, options);else if (c.operator === '<' || c.operator === '<=') lt = lowerLT(lt, c, options);else eqSet.add(c.semver);
      }
    } catch (err) {
      _iterator4.e(err);
    } finally {
      _iterator4.f();
    }

    if (eqSet.size > 1) return null;
    var gtltComp;

    if (gt && lt) {
      gtltComp = compare_1(gt.semver, lt.semver, options);
      if (gtltComp > 0) return null;else if (gtltComp === 0 && (gt.operator !== '>=' || lt.operator !== '<=')) return null;
    } // will iterate one or zero times


    var _iterator5 = _createForOfIteratorHelper(eqSet),
        _step5;

    try {
      for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
        var _eq = _step5.value;
        if (gt && !satisfies_1(_eq, String(gt), options)) return null;
        if (lt && !satisfies_1(_eq, String(lt), options)) return null;

        var _iterator7 = _createForOfIteratorHelper(dom),
            _step7;

        try {
          for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
            var _c2 = _step7.value;
            if (!satisfies_1(_eq, String(_c2), options)) return false;
          }
        } catch (err) {
          _iterator7.e(err);
        } finally {
          _iterator7.f();
        }

        return true;
      }
    } catch (err) {
      _iterator5.e(err);
    } finally {
      _iterator5.f();
    }

    var higher, lower;
    var hasDomLT, hasDomGT;

    var _iterator6 = _createForOfIteratorHelper(dom),
        _step6;

    try {
      for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
        var _c3 = _step6.value;
        hasDomGT = hasDomGT || _c3.operator === '>' || _c3.operator === '>=';
        hasDomLT = hasDomLT || _c3.operator === '<' || _c3.operator === '<=';

        if (gt) {
          if (_c3.operator === '>' || _c3.operator === '>=') {
            higher = higherGT(gt, _c3, options);
            if (higher === _c3) return false;
          } else if (gt.operator === '>=' && !satisfies_1(gt.semver, String(_c3), options)) return false;
        }

        if (lt) {
          if (_c3.operator === '<' || _c3.operator === '<=') {
            lower = lowerLT(lt, _c3, options);
            if (lower === _c3) return false;
          } else if (lt.operator === '<=' && !satisfies_1(lt.semver, String(_c3), options)) return false;
        }

        if (!_c3.operator && (lt || gt) && gtltComp !== 0) return false;
      } // if there was a < or >, and nothing in the dom, then must be false
      // UNLESS it was limited by another range in the other direction.
      // Eg, >1.0.0 <1.0.1 is still a subset of <2.0.0

    } catch (err) {
      _iterator6.e(err);
    } finally {
      _iterator6.f();
    }

    if (gt && hasDomLT && !lt && gtltComp !== 0) return false;
    if (lt && hasDomGT && !gt && gtltComp !== 0) return false;
    return true;
  }; // >=1.2.3 is lower than >1.2.3


  var higherGT = function higherGT(a, b, options) {
    if (!a) return b;
    var comp = compare_1(a.semver, b.semver, options);
    return comp > 0 ? a : comp < 0 ? b : b.operator === '>' && a.operator === '>=' ? b : a;
  }; // <=1.2.3 is higher than <1.2.3


  var lowerLT = function lowerLT(a, b, options) {
    if (!a) return b;
    var comp = compare_1(a.semver, b.semver, options);
    return comp < 0 ? a : comp > 0 ? b : b.operator === '<' && a.operator === '<=' ? b : a;
  };

  var subset_1 = subset; // just pre-load all the stuff that index.js lazily exports

  var semver$1 = {
    re: re_1.re,
    src: re_1.src,
    tokens: re_1.t,
    SEMVER_SPEC_VERSION: constants.SEMVER_SPEC_VERSION,
    SemVer: semver,
    compareIdentifiers: identifiers.compareIdentifiers,
    rcompareIdentifiers: identifiers.rcompareIdentifiers,
    parse: parse_1,
    valid: valid_1,
    clean: clean_1,
    inc: inc_1,
    diff: diff_1,
    major: major_1,
    minor: minor_1,
    patch: patch_1,
    prerelease: prerelease_1,
    compare: compare_1,
    rcompare: rcompare_1,
    compareLoose: compareLoose_1,
    compareBuild: compareBuild_1,
    sort: sort_1,
    rsort: rsort_1,
    gt: gt_1,
    lt: lt_1,
    eq: eq_1,
    neq: neq_1,
    gte: gte_1,
    lte: lte_1,
    cmp: cmp_1,
    coerce: coerce_1,
    Comparator: comparator,
    Range: range,
    satisfies: satisfies_1,
    toComparators: toComparators_1,
    maxSatisfying: maxSatisfying_1,
    minSatisfying: minSatisfying_1,
    minVersion: minVersion_1,
    validRange: valid$1,
    outside: outside_1,
    gtr: gtr_1,
    ltr: ltr_1,
    intersects: intersects_1,
    simplifyRange: simplify,
    subset: subset_1
  };
  var semver_33 = semver$1.satisfies;
  var vegaSchemaUrlParser = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    /**
     * Parse a vega schema url into library and version.
     */

    function default_1(url) {
      var regex = /\/schema\/([\w-]+)\/([\w\.\-]+)\.json$/g;

      var _a = regex.exec(url).slice(1, 3),
          library = _a[0],
          version = _a[1];

      return {
        library: library,
        version: version
      };
    }

    exports.default = default_1;
  });
  var schemaParser = unwrapExports(vegaSchemaUrlParser);
  var name$1 = "vega-themes";
  var version$1 = "2.8.3";
  var description$1 = "Themes for stylized Vega and Vega-Lite visualizations.";
  var keywords$1 = ["vega", "vega-lite", "themes", "style"];
  var license$1 = "BSD-3-Clause";
  var author$1 = {
    name: "UW Interactive Data Lab",
    url: "https://idl.cs.washington.edu"
  };
  var contributors$1 = [{
    name: "Emily Gu",
    url: "https://github.com/emilygu"
  }, {
    name: "Arvind Satyanarayan",
    url: "http://arvindsatya.com"
  }, {
    name: "Jeffrey Heer",
    url: "https://idl.cs.washington.edu"
  }, {
    name: "Dominik Moritz",
    url: "https://www.domoritz.de"
  }];
  var main$1 = "build/vega-themes.js";
  var module$1 = "build/src/index.js";
  var unpkg$1 = "build/vega-themes.min.js";
  var jsdelivr$1 = "build/vega-themes.min.js";
  var typings = "build/src/index.d.ts";
  var repository$1 = {
    type: "git",
    url: "https://github.com/vega/vega-themes.git"
  };
  var scripts$1 = {
    prepare: "beemo create-config --silent",
    clean: "rm -rf build examples/build",
    prettierbase: "beemo prettier 'examples/*.{html,scss,css}'",
    eslintbase: "beemo eslint 'src/**/*.ts'",
    format: "yarn eslintbase --fix && yarn prettierbase --write",
    lint: "yarn eslintbase && yarn prettierbase --check",
    prebuild: "mkdir -p build",
    build: "tsc && rollup -c",
    postbuild: "terser build/vega-themes.js -cm > build/vega-themes.min.js",
    "deploy:gh": "yarn build && mkdir -p examples/build && rsync -r build/* examples/build && gh-pages -d examples",
    prepublishOnly: "yarn clean && yarn build",
    preversion: "yarn lint",
    serve: "browser-sync start -s -f build examples --serveStatic examples",
    start: "yarn build && concurrently --kill-others -n Server,Typescript,Rollup 'yarn serve' 'tsc -w' 'rollup -c -w'"
  };
  var devDependencies$1 = {
    "@rollup/plugin-json": "^4.0.2",
    "browser-sync": "^2.26.7",
    concurrently: "^5.1.0",
    "gh-pages": "^2.2.0",
    rollup: "^2.1.0",
    terser: "^4.6.7",
    typescript: "^3.8.3",
    vega: "^5.10.0",
    "vega-lite": "^4.8.1",
    "vega-lite-dev-config": "^0.5.0"
  };
  var peerDependencies$1 = {
    vega: "*",
    "vega-lite": "*"
  };
  var beemo$1 = {
    module: "vega-lite-dev-config",
    drivers: ["prettier", "eslint"]
  };
  var pkg$1 = {
    name: name$1,
    version: version$1,
    description: description$1,
    keywords: keywords$1,
    license: license$1,
    author: author$1,
    contributors: contributors$1,
    main: main$1,
    module: module$1,
    unpkg: unpkg$1,
    jsdelivr: jsdelivr$1,
    typings: typings,
    repository: repository$1,
    scripts: scripts$1,
    devDependencies: devDependencies$1,
    peerDependencies: peerDependencies$1,
    beemo: beemo$1
  };
  var lightColor = '#fff';
  var medColor = '#888';
  var darkTheme = {
    background: '#333',
    title: {
      color: lightColor
    },
    style: {
      'guide-label': {
        fill: lightColor
      },
      'guide-title': {
        fill: lightColor
      }
    },
    axis: {
      domainColor: lightColor,
      gridColor: medColor,
      tickColor: lightColor
    }
  };
  var markColor = '#4572a7';
  var excelTheme = {
    background: '#fff',
    arc: {
      fill: markColor
    },
    area: {
      fill: markColor
    },
    line: {
      stroke: markColor,
      strokeWidth: 2
    },
    path: {
      stroke: markColor
    },
    rect: {
      fill: markColor
    },
    shape: {
      stroke: markColor
    },
    symbol: {
      fill: markColor,
      strokeWidth: 1.5,
      size: 50
    },
    axis: {
      bandPosition: 0.5,
      grid: true,
      gridColor: '#000000',
      gridOpacity: 1,
      gridWidth: 0.5,
      labelPadding: 10,
      tickSize: 5,
      tickWidth: 0.5
    },
    axisBand: {
      grid: false,
      tickExtra: true
    },
    legend: {
      labelBaseline: 'middle',
      labelFontSize: 11,
      symbolSize: 50,
      symbolType: 'square'
    },
    range: {
      category: ['#4572a7', '#aa4643', '#8aa453', '#71598e', '#4598ae', '#d98445', '#94aace', '#d09393', '#b9cc98', '#a99cbc']
    }
  };
  var markColor$1 = '#30a2da';
  var axisColor = '#cbcbcb';
  var guideLabelColor = '#999';
  var guideTitleColor = '#333';
  var backgroundColor = '#f0f0f0';
  var blackTitle = '#333';
  var fiveThirtyEightTheme = {
    arc: {
      fill: markColor$1
    },
    area: {
      fill: markColor$1
    },
    axis: {
      domainColor: axisColor,
      grid: true,
      gridColor: axisColor,
      gridWidth: 1,
      labelColor: guideLabelColor,
      labelFontSize: 10,
      titleColor: guideTitleColor,
      tickColor: axisColor,
      tickSize: 10,
      titleFontSize: 14,
      titlePadding: 10,
      labelPadding: 4
    },
    axisBand: {
      grid: false
    },
    background: backgroundColor,
    group: {
      fill: backgroundColor
    },
    legend: {
      labelColor: blackTitle,
      labelFontSize: 11,
      padding: 1,
      symbolSize: 30,
      symbolType: 'square',
      titleColor: blackTitle,
      titleFontSize: 14,
      titlePadding: 10
    },
    line: {
      stroke: markColor$1,
      strokeWidth: 2
    },
    path: {
      stroke: markColor$1,
      strokeWidth: 0.5
    },
    rect: {
      fill: markColor$1
    },
    range: {
      category: ['#30a2da', '#fc4f30', '#e5ae38', '#6d904f', '#8b8b8b', '#b96db8', '#ff9e27', '#56cc60', '#52d2ca', '#52689e', '#545454', '#9fe4f8'],
      diverging: ['#cc0020', '#e77866', '#f6e7e1', '#d6e8ed', '#91bfd9', '#1d78b5'],
      heatmap: ['#d6e8ed', '#cee0e5', '#91bfd9', '#549cc6', '#1d78b5']
    },
    point: {
      filled: true,
      shape: 'circle'
    },
    shape: {
      stroke: markColor$1
    },
    bar: {
      binSpacing: 2,
      fill: markColor$1,
      stroke: null
    },
    title: {
      anchor: 'start',
      fontSize: 24,
      fontWeight: 600,
      offset: 20
    }
  };
  var markColor$2 = '#000';
  var ggplot2Theme = {
    group: {
      fill: '#e5e5e5'
    },
    arc: {
      fill: markColor$2
    },
    area: {
      fill: markColor$2
    },
    line: {
      stroke: markColor$2
    },
    path: {
      stroke: markColor$2
    },
    rect: {
      fill: markColor$2
    },
    shape: {
      stroke: markColor$2
    },
    symbol: {
      fill: markColor$2,
      size: 40
    },
    axis: {
      domain: false,
      grid: true,
      gridColor: '#FFFFFF',
      gridOpacity: 1,
      labelColor: '#7F7F7F',
      labelPadding: 4,
      tickColor: '#7F7F7F',
      tickSize: 5.67,
      titleFontSize: 16,
      titleFontWeight: 'normal'
    },
    legend: {
      labelBaseline: 'middle',
      labelFontSize: 11,
      symbolSize: 40
    },
    range: {
      category: ['#000000', '#7F7F7F', '#1A1A1A', '#999999', '#333333', '#B0B0B0', '#4D4D4D', '#C9C9C9', '#666666', '#DCDCDC']
    }
  };
  var headlineFontSize = 22;
  var headlineFontWeight = 'normal';
  var labelFont = 'Benton Gothic, sans-serif';
  var labelFontSize = 11.5;
  var labelFontWeight = 'normal';
  var markColor$3 = '#82c6df'; // const markHighlight = '#006d8f';
  // const markDemocrat = '#5789b8';
  // const markRepublican = '#d94f54';

  var titleFont = 'Benton Gothic Bold, sans-serif';
  var titleFontWeight = 'normal';
  var titleFontSize = 13;
  var colorSchemes = {
    'category-6': ['#ec8431', '#829eb1', '#c89d29', '#3580b1', '#adc839', '#ab7fb4'],
    'fire-7': ['#fbf2c7', '#f9e39c', '#f8d36e', '#f4bb6a', '#e68a4f', '#d15a40', '#ab4232'],
    'fireandice-6': ['#e68a4f', '#f4bb6a', '#f9e39c', '#dadfe2', '#a6b7c6', '#849eae'],
    'ice-7': ['#edefee', '#dadfe2', '#c4ccd2', '#a6b7c6', '#849eae', '#607785', '#47525d']
  };
  var latimesTheme = {
    background: '#ffffff',
    title: {
      anchor: 'start',
      color: '#000000',
      font: titleFont,
      fontSize: headlineFontSize,
      fontWeight: headlineFontWeight
    },
    arc: {
      fill: markColor$3
    },
    area: {
      fill: markColor$3
    },
    line: {
      stroke: markColor$3,
      strokeWidth: 2
    },
    path: {
      stroke: markColor$3
    },
    rect: {
      fill: markColor$3
    },
    shape: {
      stroke: markColor$3
    },
    symbol: {
      fill: markColor$3,
      size: 30
    },
    axis: {
      labelFont: labelFont,
      labelFontSize: labelFontSize,
      labelFontWeight: labelFontWeight,
      titleFont: titleFont,
      titleFontSize: titleFontSize,
      titleFontWeight: titleFontWeight
    },
    axisX: {
      labelAngle: 0,
      labelPadding: 4,
      tickSize: 3
    },
    axisY: {
      labelBaseline: 'middle',
      maxExtent: 45,
      minExtent: 45,
      tickSize: 2,
      titleAlign: 'left',
      titleAngle: 0,
      titleX: -45,
      titleY: -11
    },
    legend: {
      labelFont: labelFont,
      labelFontSize: labelFontSize,
      symbolType: 'square',
      titleFont: titleFont,
      titleFontSize: titleFontSize,
      titleFontWeight: titleFontWeight
    },
    range: {
      category: colorSchemes['category-6'],
      diverging: colorSchemes['fireandice-6'],
      heatmap: colorSchemes['fire-7'],
      ordinal: colorSchemes['fire-7'],
      ramp: colorSchemes['fire-7']
    }
  };
  var markColor$4 = '#ab5787';
  var axisColor$1 = '#979797';
  var quartzTheme = {
    background: '#f9f9f9',
    arc: {
      fill: markColor$4
    },
    area: {
      fill: markColor$4
    },
    line: {
      stroke: markColor$4
    },
    path: {
      stroke: markColor$4
    },
    rect: {
      fill: markColor$4
    },
    shape: {
      stroke: markColor$4
    },
    symbol: {
      fill: markColor$4,
      size: 30
    },
    axis: {
      domainColor: axisColor$1,
      domainWidth: 0.5,
      gridWidth: 0.2,
      labelColor: axisColor$1,
      tickColor: axisColor$1,
      tickWidth: 0.2,
      titleColor: axisColor$1
    },
    axisBand: {
      grid: false
    },
    axisX: {
      grid: true,
      tickSize: 10
    },
    axisY: {
      domain: false,
      grid: true,
      tickSize: 0
    },
    legend: {
      labelFontSize: 11,
      padding: 1,
      symbolSize: 30,
      symbolType: 'square'
    },
    range: {
      category: ['#ab5787', '#51b2e5', '#703c5c', '#168dd9', '#d190b6', '#00609f', '#d365ba', '#154866', '#666666', '#c4c4c4']
    }
  };
  var markColor$5 = '#3e5c69';
  var voxTheme = {
    background: '#fff',
    arc: {
      fill: markColor$5
    },
    area: {
      fill: markColor$5
    },
    line: {
      stroke: markColor$5
    },
    path: {
      stroke: markColor$5
    },
    rect: {
      fill: markColor$5
    },
    shape: {
      stroke: markColor$5
    },
    symbol: {
      fill: markColor$5
    },
    axis: {
      domainWidth: 0.5,
      grid: true,
      labelPadding: 2,
      tickSize: 5,
      tickWidth: 0.5,
      titleFontWeight: 'normal'
    },
    axisBand: {
      grid: false
    },
    axisX: {
      gridWidth: 0.2
    },
    axisY: {
      gridDash: [3],
      gridWidth: 0.4
    },
    legend: {
      labelFontSize: 11,
      padding: 1,
      symbolType: 'square'
    },
    range: {
      category: ['#3e5c69', '#6793a6', '#182429', '#0570b0', '#3690c0', '#74a9cf', '#a6bddb', '#e2ddf2']
    }
  };
  var markColor$6 = '#1696d2';
  var axisColor$2 = '#000000';
  var backgroundColor$1 = '#FFFFFF';
  var font = 'Lato';
  var labelFont$1 = 'Lato';
  var sourceFont = 'Lato';
  var gridColor = '#DEDDDD';
  var titleFontSize$1 = 18;
  var colorSchemes$1 = {
    'main-colors': ['#1696d2', '#d2d2d2', '#000000', '#fdbf11', '#ec008b', '#55b748', '#5c5859', '#db2b27'],
    'shades-blue': ['#CFE8F3', '#A2D4EC', '#73BFE2', '#46ABDB', '#1696D2', '#12719E', '#0A4C6A', '#062635'],
    'shades-gray': ['#F5F5F5', '#ECECEC', '#E3E3E3', '#DCDBDB', '#D2D2D2', '#9D9D9D', '#696969', '#353535'],
    'shades-yellow': ['#FFF2CF', '#FCE39E', '#FDD870', '#FCCB41', '#FDBF11', '#E88E2D', '#CA5800', '#843215'],
    'shades-magenta': ['#F5CBDF', '#EB99C2', '#E46AA7', '#E54096', '#EC008B', '#AF1F6B', '#761548', '#351123'],
    'shades-green': ['#DCEDD9', '#BCDEB4', '#98CF90', '#78C26D', '#55B748', '#408941', '#2C5C2D', '#1A2E19'],
    'shades-black': ['#D5D5D4', '#ADABAC', '#848081', '#5C5859', '#332D2F', '#262223', '#1A1717', '#0E0C0D'],
    'shades-red': ['#F8D5D4', '#F1AAA9', '#E9807D', '#E25552', '#DB2B27', '#A4201D', '#6E1614', '#370B0A'],
    'one-group': ['#1696d2', '#000000'],
    'two-groups-cat-1': ['#1696d2', '#000000'],
    'two-groups-cat-2': ['#1696d2', '#fdbf11'],
    'two-groups-cat-3': ['#1696d2', '#db2b27'],
    'two-groups-seq': ['#a2d4ec', '#1696d2'],
    'three-groups-cat': ['#1696d2', '#fdbf11', '#000000'],
    'three-groups-seq': ['#a2d4ec', '#1696d2', '#0a4c6a'],
    'four-groups-cat-1': ['#000000', '#d2d2d2', '#fdbf11', '#1696d2'],
    'four-groups-cat-2': ['#1696d2', '#ec0008b', '#fdbf11', '#5c5859'],
    'four-groups-seq': ['#cfe8f3', '#73bf42', '#1696d2', '#0a4c6a'],
    'five-groups-cat-1': ['#1696d2', '#fdbf11', '#d2d2d2', '#ec008b', '#000000'],
    'five-groups-cat-2': ['#1696d2', '#0a4c6a', '#d2d2d2', '#fdbf11', '#332d2f'],
    'five-groups-seq': ['#cfe8f3', '#73bf42', '#1696d2', '#0a4c6a', '#000000'],
    'six-groups-cat-1': ['#1696d2', '#ec008b', '#fdbf11', '#000000', '#d2d2d2', '#55b748'],
    'six-groups-cat-2': ['#1696d2', '#d2d2d2', '#ec008b', '#fdbf11', '#332d2f', '#0a4c6a'],
    'six-groups-seq': ['#cfe8f3', '#a2d4ec', '#73bfe2', '#46abdb', '#1696d2', '#12719e'],
    'diverging-colors': ['#ca5800', '#fdbf11', '#fdd870', '#fff2cf', '#cfe8f3', '#73bfe2', '#1696d2', '#0a4c6a']
  };
  var urbanInstituteTheme = {
    background: backgroundColor$1,
    title: {
      anchor: 'start',
      fontSize: titleFontSize$1,
      font: font
    },
    axisX: {
      domain: true,
      domainColor: axisColor$2,
      domainWidth: 1,
      grid: false,
      labelFontSize: 12,
      labelFont: labelFont$1,
      labelAngle: 0,
      tickColor: axisColor$2,
      tickSize: 5,
      titleFontSize: 12,
      titlePadding: 10,
      titleFont: font
    },
    axisY: {
      domain: false,
      domainWidth: 1,
      grid: true,
      gridColor: gridColor,
      gridWidth: 1,
      labelFontSize: 12,
      labelFont: labelFont$1,
      labelPadding: 8,
      ticks: false,
      titleFontSize: 12,
      titlePadding: 10,
      titleFont: font,
      titleAngle: 0,
      titleY: -10,
      titleX: 18
    },
    legend: {
      labelFontSize: 12,
      labelFont: labelFont$1,
      symbolSize: 100,
      titleFontSize: 12,
      titlePadding: 10,
      titleFont: font,
      orient: 'right',
      offset: 10
    },
    view: {
      stroke: 'transparent'
    },
    range: {
      category: colorSchemes$1['six-groups-cat-1'],
      diverging: colorSchemes$1['diverging-colors'],
      heatmap: colorSchemes$1['diverging-colors'],
      ordinal: colorSchemes$1['six-groups-seq'],
      ramp: colorSchemes$1['shades-blue']
    },
    area: {
      fill: markColor$6
    },
    rect: {
      fill: markColor$6
    },
    line: {
      color: markColor$6,
      stroke: markColor$6,
      strokeWidth: 5
    },
    trail: {
      color: markColor$6,
      stroke: markColor$6,
      strokeWidth: 0,
      size: 1
    },
    path: {
      stroke: markColor$6,
      strokeWidth: 0.5
    },
    point: {
      filled: true
    },
    text: {
      font: sourceFont,
      color: markColor$6,
      fontSize: 11,
      align: 'center',
      fontWeight: 400,
      size: 11
    },
    style: {
      bar: {
        fill: markColor$6,
        stroke: null
      }
    },
    arc: {
      fill: markColor$6
    },
    shape: {
      stroke: markColor$6
    },
    symbol: {
      fill: markColor$6,
      size: 30
    }
  };
  /**
   * Copyright 2020 Google LLC.
   *
   * Use of this source code is governed by a BSD-style
   * license that can be found in the LICENSE file or at
   * https://developers.google.com/open-source/licenses/bsd
   */

  var markColor$7 = '#3366CC';
  var gridColor$1 = '#ccc';
  var defaultFont = 'Arial, sans-serif';
  var googlechartsTheme = {
    arc: {
      fill: markColor$7
    },
    area: {
      fill: markColor$7
    },
    path: {
      stroke: markColor$7
    },
    rect: {
      fill: markColor$7
    },
    shape: {
      stroke: markColor$7
    },
    symbol: {
      stroke: markColor$7
    },
    circle: {
      fill: markColor$7
    },
    background: '#fff',
    padding: {
      top: 10,
      right: 10,
      bottom: 10,
      left: 10
    },
    style: {
      'guide-label': {
        font: defaultFont,
        fontSize: 12
      },
      'guide-title': {
        font: defaultFont,
        fontSize: 12
      },
      'group-title': {
        font: defaultFont,
        fontSize: 12
      }
    },
    title: {
      font: defaultFont,
      fontSize: 14,
      fontWeight: 'bold',
      dy: -3,
      anchor: 'start'
    },
    axis: {
      gridColor: gridColor$1,
      tickColor: gridColor$1,
      domain: false,
      grid: true
    },
    range: {
      category: ['#4285F4', '#DB4437', '#F4B400', '#0F9D58', '#AB47BC', '#00ACC1', '#FF7043', '#9E9D24', '#5C6BC0', '#F06292', '#00796B', '#C2185B'],
      heatmap: ['#c6dafc', '#5e97f6', '#2a56c6']
    }
  };
  var version$2 = pkg$1.version;
  var themes = /*#__PURE__*/Object.freeze({
    __proto__: null,
    version: version$2,
    dark: darkTheme,
    excel: excelTheme,
    fivethirtyeight: fiveThirtyEightTheme,
    ggplot2: ggplot2Theme,
    latimes: latimesTheme,
    quartz: quartzTheme,
    vox: voxTheme,
    urbaninstitute: urbanInstituteTheme,
    googlecharts: googlechartsTheme
  }); // generated with build-style.sh

  var defaultStyle = "#vg-tooltip-element {\n  visibility: hidden;\n  padding: 8px;\n  position: fixed;\n  z-index: 1000;\n  font-family: sans-serif;\n  font-size: 11px;\n  border-radius: 3px;\n  box-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);\n  /* The default theme is the light theme. */\n  background-color: rgba(255, 255, 255, 0.95);\n  border: 1px solid #d9d9d9;\n  color: black; }\n  #vg-tooltip-element.visible {\n    visibility: visible; }\n  #vg-tooltip-element h2 {\n    margin-top: 0;\n    margin-bottom: 10px;\n    font-size: 13px; }\n  #vg-tooltip-element img {\n    max-width: 200px;\n    max-height: 200px; }\n  #vg-tooltip-element table {\n    border-spacing: 0; }\n    #vg-tooltip-element table tr {\n      border: none; }\n      #vg-tooltip-element table tr td {\n        overflow: hidden;\n        text-overflow: ellipsis;\n        padding-top: 2px;\n        padding-bottom: 2px; }\n        #vg-tooltip-element table tr td.key {\n          color: #808080;\n          max-width: 150px;\n          text-align: right;\n          padding-right: 4px; }\n        #vg-tooltip-element table tr td.value {\n          display: block;\n          max-width: 300px;\n          max-height: 7em;\n          text-align: left; }\n  #vg-tooltip-element.dark-theme {\n    background-color: rgba(32, 32, 32, 0.9);\n    border: 1px solid #f5f5f5;\n    color: white; }\n    #vg-tooltip-element.dark-theme td.key {\n      color: #bfbfbf; }\n";
  var EL_ID = 'vg-tooltip-element';
  var DEFAULT_OPTIONS = {
    /**
     * X offset.
     */
    offsetX: 10,

    /**
     * Y offset.
     */
    offsetY: 10,

    /**
     * ID of the tooltip element.
     */
    id: EL_ID,

    /**
     * ID of the tooltip CSS style.
     */
    styleId: 'vega-tooltip-style',

    /**
     * The name of the theme. You can use the CSS class called [THEME]-theme to style the tooltips.
     *
     * There are two predefined themes: "light" (default) and "dark".
     */
    theme: 'light',

    /**
     * Do not use the default styles provided by Vega Tooltip. If you enable this option, you need to use your own styles. It is not necessary to disable the default style when using a custom theme.
     */
    disableDefaultStyle: false,

    /**
     * HTML sanitizer function that removes dangerous HTML to prevent XSS.
     *
     * This should be a function from string to string. You may replace it with a formatter such as a markdown formatter.
     */
    sanitize: escapeHTML,

    /**
     * The maximum recursion depth when printing objects in the tooltip.
     */
    maxDepth: 2
  };
  /**
   * Escape special HTML characters.
   *
   * @param value A value to convert to string and HTML-escape.
   */

  function escapeHTML(value) {
    return String(value).replace(/&/g, '&amp;').replace(/</g, '&lt;');
  }

  function createDefaultStyle(id) {
    // Just in case this id comes from a user, ensure these is no security issues
    if (!/^[A-Za-z]+[-:.\w]*$/.test(id)) {
      throw new Error('Invalid HTML ID');
    }

    return defaultStyle.toString().replace(EL_ID, id);
  }

  function accessor(fn, fields, name) {
    fn.fields = fields || [];
    fn.fname = name;
    return fn;
  }

  function error(message) {
    throw Error(message);
  }

  function splitAccessPath(p) {
    var path = [],
        q = null,
        b = 0,
        n = p.length,
        s = '',
        i,
        j,
        c;
    p = p + '';

    function push() {
      path.push(s + p.substring(i, j));
      s = '';
      i = j + 1;
    }

    for (i = j = 0; j < n; ++j) {
      c = p[j];

      if (c === '\\') {
        s += p.substring(i, j);
        s += p.substring(++j, ++j);
        i = j;
      } else if (c === q) {
        push();
        q = null;
        b = -1;
      } else if (q) {
        continue;
      } else if (i === b && c === '"') {
        i = j + 1;
        q = c;
      } else if (i === b && c === "'") {
        i = j + 1;
        q = c;
      } else if (c === '.' && !b) {
        if (j > i) {
          push();
        } else {
          i = j + 1;
        }
      } else if (c === '[') {
        if (j > i) push();
        b = i = j + 1;
      } else if (c === ']') {
        if (!b) error('Access path missing open bracket: ' + p);
        if (b > 0) push();
        b = 0;
        i = j + 1;
      }
    }

    if (b) error('Access path missing closing bracket: ' + p);
    if (q) error('Access path missing closing quote: ' + p);

    if (j > i) {
      j++;
      push();
    }

    return path;
  }

  var isArray = Array.isArray;

  function isObject(_) {
    return _ === Object(_);
  }

  function isString(_) {
    return typeof _ === 'string';
  }

  function $(x) {
    return isArray(x) ? '[' + x.map($) + ']' : isObject(x) || isString(x) ? // Output valid JSON and JS source strings.
    // See http://timelessrepo.com/json-isnt-a-javascript-subset
    JSON.stringify(x).replace("\u2028", "\\u2028").replace("\u2029", "\\u2029") : x;
  }

  function field(field, name) {
    var path = splitAccessPath(field),
        code = 'return _[' + path.map($).join('][') + '];';
    return accessor(Function('_', code), [field = path.length === 1 ? path[0] : field], name || field);
  }

  var empty = [];
  var id = field('id');
  var identity = accessor(function (_) {
    return _;
  }, empty, 'identity');
  var zero = accessor(function () {
    return 0;
  }, empty, 'zero');
  var one = accessor(function () {
    return 1;
  }, empty, 'one');
  var truthy = accessor(function () {
    return true;
  }, empty, 'true');
  var falsy = accessor(function () {
    return false;
  }, empty, 'false');

  var isLegalKey = function isLegalKey(key) {
    return key !== '__proto__';
  };

  function mergeConfig() {
    for (var _len2 = arguments.length, configs = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      configs[_key2] = arguments[_key2];
    }

    return configs.reduce(function (out, source) {
      for (var key in source) {
        if (key === 'signals') {
          // for signals, we merge the signals arrays
          // source signals take precedence over
          // existing signals with the same name
          out.signals = mergeNamed(out.signals, source.signals);
        } else {
          // otherwise, merge objects subject to recursion constraints
          // for legend block, recurse for the layout entry only
          // for style block, recurse for all properties
          // otherwise, no recursion: objects overwrite, no merging
          var r = key === 'legend' ? {
            layout: 1
          } : key === 'style' ? true : null;
          writeConfig(out, key, source[key], r);
        }
      }

      return out;
    }, {});
  }

  function writeConfig(output, key, value, recurse) {
    if (!isLegalKey(key)) return;
    var k, o;

    if (isObject(value) && !isArray(value)) {
      o = isObject(output[key]) ? output[key] : output[key] = {};

      for (k in value) {
        if (recurse && (recurse === true || recurse[k])) {
          writeConfig(o, k, value[k]);
        } else if (isLegalKey(k)) {
          o[k] = value[k];
        }
      }
    } else {
      output[key] = value;
    }
  }

  function mergeNamed(a, b) {
    if (a == null) return b;
    var map = {},
        out = [];

    function add(_) {
      if (!map[_.name]) {
        map[_.name] = 1;
        out.push(_);
      }
    }

    b.forEach(add);
    a.forEach(add);
    return out;
  }

  function isBoolean(_) {
    return typeof _ === 'boolean';
  }

  var __rest = undefined && undefined.__rest || function (s, e) {
    var t = {};

    for (var p in s) {
      if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
    }

    if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
    }
    return t;
  };
  /**
   * Format the value to be shown in the tooltip.
   *
   * @param value The value to show in the tooltip.
   * @param valueToHtml Function to convert a single cell value to an HTML string
   */


  function formatValue(value, valueToHtml, maxDepth) {
    if (isArray(value)) {
      return "[".concat(value.map(function (v) {
        return valueToHtml(isString(v) ? v : stringify(v, maxDepth));
      }).join(', '), "]");
    }

    if (isObject(value)) {
      var content = '';

      var _a2 = value,
          title = _a2.title,
          image = _a2.image,
          rest = __rest(_a2, ["title", "image"]);

      if (title) {
        content += "<h2>".concat(valueToHtml(title), "</h2>");
      }

      if (image) {
        content += "<img src=\"".concat(valueToHtml(image), "\">");
      }

      var keys = Object.keys(rest);

      if (keys.length > 0) {
        content += '<table>';

        var _iterator8 = _createForOfIteratorHelper(keys),
            _step8;

        try {
          for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
            var key = _step8.value;
            var val = rest[key]; // ignore undefined properties

            if (val === undefined) {
              continue;
            }

            if (isObject(val)) {
              val = stringify(val, maxDepth);
            }

            content += "<tr><td class=\"key\">".concat(valueToHtml(key), ":</td><td class=\"value\">").concat(valueToHtml(val), "</td></tr>");
          }
        } catch (err) {
          _iterator8.e(err);
        } finally {
          _iterator8.f();
        }

        content += "</table>";
      }

      return content || '{}'; // show empty object if there are no properties
    }

    return valueToHtml(value);
  }

  function replacer(maxDepth) {
    var stack = [];
    return function (key, value) {
      if (_typeof(value) !== 'object' || value === null) {
        return value;
      }

      var pos = stack.indexOf(this) + 1;
      stack.length = pos;

      if (stack.length > maxDepth) {
        return '[Object]';
      }

      if (stack.indexOf(value) >= 0) {
        return '[Circular]';
      }

      stack.push(value);
      return value;
    };
  }
  /**
   * Stringify any JS object to valid JSON
   */


  function stringify(obj, maxDepth) {
    return JSON.stringify(obj, replacer(maxDepth));
  }
  /**
   * Position the tooltip
   *
   * @param event The mouse event.
   * @param tooltipBox
   * @param offsetX Horizontal offset.
   * @param offsetY Vertical offset.
   */


  function calculatePosition(event, tooltipBox, offsetX, offsetY) {
    var x = event.clientX + offsetX;

    if (x + tooltipBox.width > window.innerWidth) {
      x = +event.clientX - offsetX - tooltipBox.width;
    }

    var y = event.clientY + offsetY;

    if (y + tooltipBox.height > window.innerHeight) {
      y = +event.clientY - offsetY - tooltipBox.height;
    }

    return {
      x: x,
      y: y
    };
  }
  /**
   * The tooltip handler class.
   */


  var Handler = /*#__PURE__*/function () {
    /**
     * Create the tooltip handler and initialize the element and style.
     *
     * @param options Tooltip Options
     */
    function Handler(options) {
      _classCallCheck(this, Handler);

      this.options = Object.assign(Object.assign({}, DEFAULT_OPTIONS), options);
      var elementId = this.options.id; // bind this to call

      this.call = this.tooltipHandler.bind(this); // prepend a default stylesheet for tooltips to the head

      if (!this.options.disableDefaultStyle && !document.getElementById(this.options.styleId)) {
        var style = document.createElement('style');
        style.setAttribute('id', this.options.styleId);
        style.innerHTML = createDefaultStyle(elementId);
        var head = document.head;

        if (head.childNodes.length > 0) {
          head.insertBefore(style, head.childNodes[0]);
        } else {
          head.appendChild(style);
        }
      } // append a div element that we use as a tooltip unless it already exists
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion


      this.el = document.getElementById(elementId);

      if (!this.el) {
        this.el = document.createElement('div');
        this.el.setAttribute('id', elementId);
        this.el.classList.add('vg-tooltip');
        document.body.appendChild(this.el);
      }
    }
    /**
     * The tooltip handler function.
     */


    _createClass(Handler, [{
      key: "tooltipHandler",
      value: function tooltipHandler(handler, event, item, value) {
        // console.log(handler, event, item, value);
        // hide tooltip for null, undefined, or empty string values
        if (value == null || value === '') {
          this.el.classList.remove('visible', "".concat(this.options.theme, "-theme"));
          return;
        } // set the tooltip content


        this.el.innerHTML = formatValue(value, this.options.sanitize, this.options.maxDepth); // make the tooltip visible

        this.el.classList.add('visible', "".concat(this.options.theme, "-theme"));

        var _calculatePosition = calculatePosition(event, this.el.getBoundingClientRect(), this.options.offsetX, this.options.offsetY),
            x = _calculatePosition.x,
            y = _calculatePosition.y;

        this.el.setAttribute('style', "top: ".concat(y, "px; left: ").concat(x, "px"));
      }
    }]);

    return Handler;
  }();
  /**
   * Open editor url in a new window, and pass a message.
   */


  function post(window, url, data) {
    var editor = window.open(url);
    var wait = 10000;
    var step = 250;

    var _URL = new URL(url),
        origin = _URL.origin; // eslint-disable-next-line no-bitwise


    var count = ~~(wait / step);

    function listen(evt) {
      if (evt.source === editor) {
        count = 0;
        window.removeEventListener('message', listen, false);
      }
    }

    window.addEventListener('message', listen, false); // send message
    // periodically resend until ack received or timeout

    function send() {
      if (count <= 0) {
        return;
      }

      editor.postMessage(data, origin);
      setTimeout(send, step);
      count -= 1;
    }

    setTimeout(send, step);
  } // generated with build-style.sh


  var embedStyle = ".vega-embed {\n  position: relative;\n  display: inline-block; }\n  .vega-embed.has-actions {\n    padding-right: 38px; }\n  .vega-embed details:not([open]) > :not(summary) {\n    display: none !important; }\n  .vega-embed summary {\n    list-style: none;\n    position: absolute;\n    top: 0;\n    right: 0;\n    padding: 6px;\n    z-index: 1000;\n    background: white;\n    box-shadow: 1px 1px 3px rgba(0, 0, 0, 0.1);\n    color: #1b1e23;\n    border: 1px solid #aaa;\n    border-radius: 999px;\n    opacity: 0.2;\n    transition: opacity 0.4s ease-in;\n    outline: none;\n    cursor: pointer;\n    line-height: 0px; }\n    .vega-embed summary::-webkit-details-marker {\n      display: none; }\n    .vega-embed summary:active {\n      box-shadow: #aaa 0px 0px 0px 1px inset; }\n    .vega-embed summary svg {\n      width: 14px;\n      height: 14px; }\n  .vega-embed details[open] summary {\n    opacity: 0.7; }\n  .vega-embed:hover summary,\n  .vega-embed:focus summary {\n    opacity: 1 !important;\n    transition: opacity 0.2s ease; }\n  .vega-embed .vega-actions {\n    position: absolute;\n    z-index: 1001;\n    top: 35px;\n    right: -9px;\n    display: flex;\n    flex-direction: column;\n    padding-bottom: 8px;\n    padding-top: 8px;\n    border-radius: 4px;\n    box-shadow: 0 2px 8px 0 rgba(0, 0, 0, 0.2);\n    border: 1px solid #d9d9d9;\n    background: white;\n    animation-duration: 0.15s;\n    animation-name: scale-in;\n    animation-timing-function: cubic-bezier(0.2, 0, 0.13, 1.5);\n    text-align: left; }\n    .vega-embed .vega-actions a {\n      padding: 8px 16px;\n      font-family: sans-serif;\n      font-size: 14px;\n      font-weight: 600;\n      white-space: nowrap;\n      color: #434a56;\n      text-decoration: none; }\n      .vega-embed .vega-actions a:hover {\n        background-color: #f7f7f9;\n        color: black; }\n    .vega-embed .vega-actions::before, .vega-embed .vega-actions::after {\n      content: \"\";\n      display: inline-block;\n      position: absolute; }\n    .vega-embed .vega-actions::before {\n      left: auto;\n      right: 14px;\n      top: -16px;\n      border: 8px solid #0000;\n      border-bottom-color: #d9d9d9; }\n    .vega-embed .vega-actions::after {\n      left: auto;\n      right: 15px;\n      top: -14px;\n      border: 7px solid #0000;\n      border-bottom-color: #fff; }\n\n.vega-embed-wrapper {\n  max-width: 100%;\n  overflow: scroll;\n  padding-right: 14px; }\n\n@keyframes scale-in {\n  from {\n    opacity: 0;\n    transform: scale(0.6); }\n  to {\n    opacity: 1;\n    transform: scale(1); } }\n"; // polyfill for IE

  if (!String.prototype.startsWith) {
    // eslint-disable-next-line no-extend-native,func-names
    String.prototype.startsWith = function (search, pos) {
      return this.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
    };
  }

  function isURL(s) {
    return s.startsWith('http://') || s.startsWith('https://') || s.startsWith('//');
  }

  function mergeDeep(dest) {
    for (var _len3 = arguments.length, src = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
      src[_key3 - 1] = arguments[_key3];
    }

    for (var _i3 = 0, _src = src; _i3 < _src.length; _i3++) {
      var s = _src[_i3];
      deepMerge_(dest, s);
    }

    return dest;
  }

  function deepMerge_(dest, src) {
    for (var _i4 = 0, _Object$keys = Object.keys(src); _i4 < _Object$keys.length; _i4++) {
      var property = _Object$keys[_i4];
      vegaImport.writeConfig(dest, property, src[property], true);
    }
  }

  var _a;

  var vega = vegaImport;
  var _vegaLite = vegaLiteImport; // For backwards compatibility with Vega-Lite before v4.

  var w = typeof window !== 'undefined' ? window : undefined;

  if (_vegaLite === undefined && ((_a = w === null || w === void 0 ? void 0 : w['vl']) === null || _a === void 0 ? void 0 : _a.compile)) {
    _vegaLite = w['vl'];
  }

  var DEFAULT_ACTIONS = {
    export: {
      svg: true,
      png: true
    },
    source: true,
    compiled: true,
    editor: true
  };
  var I18N = {
    CLICK_TO_VIEW_ACTIONS: 'Click to view actions',
    COMPILED_ACTION: 'View Compiled Vega',
    EDITOR_ACTION: 'Open in Vega Editor',
    PNG_ACTION: 'Save as PNG',
    SOURCE_ACTION: 'View Source',
    SVG_ACTION: 'Save as SVG'
  };
  var NAMES = {
    vega: 'Vega',
    'vega-lite': 'Vega-Lite'
  };
  var VERSION = {
    vega: vega.version,
    'vega-lite': _vegaLite ? _vegaLite.version : 'not available'
  };
  var PREPROCESSOR = {
    vega: function vega(vgSpec) {
      return vgSpec;
    },
    'vega-lite': function vegaLite(vlSpec, config) {
      return _vegaLite.compile(vlSpec, {
        config: config
      }).spec;
    }
  };
  var SVG_CIRCLES = "\n<svg viewBox=\"0 0 16 16\" fill=\"currentColor\" stroke=\"none\" stroke-width=\"1\" stroke-linecap=\"round\" stroke-linejoin=\"round\">\n  <circle r=\"2\" cy=\"8\" cx=\"2\"></circle>\n  <circle r=\"2\" cy=\"8\" cx=\"8\"></circle>\n  <circle r=\"2\" cy=\"8\" cx=\"14\"></circle>\n</svg>";

  function isTooltipHandler(h) {
    return typeof h === 'function';
  }

  function viewSource(source, sourceHeader, sourceFooter, mode) {
    var header = "<html><head>".concat(sourceHeader, "</head><body><pre><code class=\"json\">");
    var footer = "</code></pre>".concat(sourceFooter, "</body></html>");
    var win = window.open('');
    win.document.write(header + source + footer);
    win.document.title = "".concat(NAMES[mode], " JSON Source");
  }
  /**
   * Try to guess the type of spec.
   *
   * @param spec Vega or Vega-Lite spec.
   */


  function guessMode(spec, providedMode) {
    var _a; // Decide mode


    if (spec.$schema) {
      var parsed = schemaParser(spec.$schema);

      if (providedMode && providedMode !== parsed.library) {
        console.warn("The given visualization spec is written in ".concat(NAMES[parsed.library], ", but mode argument sets ").concat((_a = NAMES[providedMode]) !== null && _a !== void 0 ? _a : providedMode, "."));
      }

      var mode = parsed.library;

      if (!semver_33(VERSION[mode], "^".concat(parsed.version.slice(1)))) {
        console.warn("The input spec uses ".concat(NAMES[mode], " ").concat(parsed.version, ", but the current version of ").concat(NAMES[mode], " is v").concat(VERSION[mode], "."));
      }

      return mode;
    } // try to guess from the provided spec


    if ('mark' in spec || 'encoding' in spec || 'layer' in spec || 'hconcat' in spec || 'vconcat' in spec || 'facet' in spec || 'repeat' in spec) {
      return 'vega-lite';
    }

    if ('marks' in spec || 'signals' in spec || 'scales' in spec || 'axes' in spec) {
      return 'vega';
    }

    return providedMode !== null && providedMode !== void 0 ? providedMode : 'vega';
  }

  function isLoader(o) {
    return !!(o && 'load' in o);
  }
  /**
   * Embed a Vega visualization component in a web page. This function returns a promise.
   *
   * @param el        DOM element in which to place component (DOM node or CSS selector).
   * @param spec      String : A URL string from which to load the Vega specification.
   *                  Object : The Vega/Vega-Lite specification as a parsed JSON object.
   * @param opts       A JavaScript object containing options for embedding.
   */


  function embed(el, spec) {
    var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    var _a, _b, _c;

    return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var loader, parsedSpec, usermetaOpts, parsedOpts, mergedOpts;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              loader = isLoader(opts.loader) ? opts.loader : vega.loader(opts.loader); // load spec, config, and patch that are references by URLs

              if (!isString(spec)) {
                _context.next = 9;
                break;
              }

              _context.t1 = JSON;
              _context.next = 5;
              return loader.load(spec);

            case 5:
              _context.t2 = _context.sent;
              _context.t0 = _context.t1.parse.call(_context.t1, _context.t2);
              _context.next = 10;
              break;

            case 9:
              _context.t0 = spec;

            case 10:
              parsedSpec = _context.t0;
              _context.next = 13;
              return loadOpts((_a = parsedSpec.usermeta && parsedSpec.usermeta['embedOptions']) !== null && _a !== void 0 ? _a : {}, loader);

            case 13:
              usermetaOpts = _context.sent;
              _context.next = 16;
              return loadOpts(opts, loader);

            case 16:
              parsedOpts = _context.sent;
              mergedOpts = Object.assign(Object.assign({}, mergeDeep(parsedOpts, usermetaOpts)), {
                config: mergeConfig((_b = parsedOpts.config) !== null && _b !== void 0 ? _b : {}, (_c = usermetaOpts.config) !== null && _c !== void 0 ? _c : {})
              });
              _context.next = 20;
              return _embed(el, parsedSpec, mergedOpts, loader);

            case 20:
              return _context.abrupt("return", _context.sent);

            case 21:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));
  }

  function loadOpts(opt, loader) {
    var _a;

    return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var config, patch;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              if (!isString(opt.config)) {
                _context2.next = 8;
                break;
              }

              _context2.t1 = JSON;
              _context2.next = 4;
              return loader.load(opt.config);

            case 4:
              _context2.t2 = _context2.sent;
              _context2.t0 = _context2.t1.parse.call(_context2.t1, _context2.t2);
              _context2.next = 9;
              break;

            case 8:
              _context2.t0 = (_a = opt.config) !== null && _a !== void 0 ? _a : {};

            case 9:
              config = _context2.t0;

              if (!isString(opt.patch)) {
                _context2.next = 18;
                break;
              }

              _context2.t4 = JSON;
              _context2.next = 14;
              return loader.load(opt.patch);

            case 14:
              _context2.t5 = _context2.sent;
              _context2.t3 = _context2.t4.parse.call(_context2.t4, _context2.t5);
              _context2.next = 19;
              break;

            case 18:
              _context2.t3 = opt.patch;

            case 19:
              patch = _context2.t3;
              return _context2.abrupt("return", Object.assign(Object.assign(Object.assign({}, opt), patch ? {
                patch: patch
              } : {}), config ? {
                config: config
              } : {}));

            case 21:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }));
  }

  function _embed(el, spec) {
    var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var loader = arguments.length > 3 ? arguments[3] : undefined;

    var _a, _b, _c, _d, _e, _f;

    return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
      var config, actions, i18n, renderer, logLevel, downloadFileName, ID, style, mode, vgSpec, parsed, div, patch, runtime, view, handler, hover, _ref, hoverSet, updateSet, documentClickHandler, _wrapper, details, summary, ctrl, _loop2, _i5, _arr2, viewSourceLink, compileLink, editorUrl, editorLink, finalize;

      return regeneratorRuntime.wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              finalize = function _finalize() {
                if (documentClickHandler) {
                  document.removeEventListener('click', documentClickHandler);
                }

                view.finalize();
              };

              config = opts.theme ? mergeConfig(themes[opts.theme], (_a = opts.config) !== null && _a !== void 0 ? _a : {}) : opts.config;
              actions = isBoolean(opts.actions) ? opts.actions : mergeDeep({}, DEFAULT_ACTIONS, (_b = opts.actions) !== null && _b !== void 0 ? _b : {});
              i18n = Object.assign(Object.assign({}, I18N), opts.i18n);
              renderer = (_c = opts.renderer) !== null && _c !== void 0 ? _c : 'canvas';
              logLevel = (_d = opts.logLevel) !== null && _d !== void 0 ? _d : vega.Warn;
              downloadFileName = (_e = opts.downloadFileName) !== null && _e !== void 0 ? _e : 'visualization';

              if (opts.defaultStyle !== false) {
                // Add a default stylesheet to the head of the document.
                ID = 'vega-embed-style';

                if (!document.getElementById(ID)) {
                  style = document.createElement('style');
                  style.id = ID;
                  style.innerText = opts.defaultStyle === undefined || opts.defaultStyle === true ? embedStyle.toString() : opts.defaultStyle;
                  document.head.appendChild(style);
                }
              }

              mode = guessMode(spec, opts.mode);
              vgSpec = PREPROCESSOR[mode](spec, config);

              if (mode === 'vega-lite') {
                if (vgSpec.$schema) {
                  parsed = schemaParser(vgSpec.$schema);

                  if (!semver_33(VERSION.vega, "^".concat(parsed.version.slice(1)))) {
                    console.warn("The compiled spec uses Vega ".concat(parsed.version, ", but current version is v").concat(VERSION.vega, "."));
                  }
                }
              }

              div = typeof el === 'string' ? document.querySelector(el) : el;

              if (div) {
                _context4.next = 14;
                break;
              }

              throw Error("".concat(el, " does not exist"));

            case 14:
              div.classList.add('vega-embed');

              if (actions) {
                div.classList.add('has-actions');
              }

              div.innerHTML = ''; // clear container

              patch = opts.patch;

              if (patch) {
                if (patch instanceof Function) {
                  vgSpec = patch(vgSpec);
                } else {
                  vgSpec = applyPatch(vgSpec, patch, true, false).newDocument;
                }
              } // Set locale. Note that this is a global setting.


              if (opts.formatLocale) {
                vega.formatLocale(opts.formatLocale);
              }

              if (opts.timeFormatLocale) {
                vega.timeFormatLocale(opts.timeFormatLocale);
              } // Do not apply the config to Vega when we have already applied it to Vega-Lite.
              // This call may throw an Error if parsing fails.


              runtime = vega.parse(vgSpec, mode === 'vega-lite' ? {} : config);
              view = new vega.View(runtime, {
                loader: loader,
                logLevel: logLevel,
                renderer: renderer
              });

              if (opts.tooltip !== false) {
                if (isTooltipHandler(opts.tooltip)) {
                  handler = opts.tooltip;
                } else {
                  // user provided boolean true or tooltip options
                  handler = new Handler(opts.tooltip === true ? {} : opts.tooltip).call;
                }

                view.tooltip(handler);
              }

              hover = opts.hover;

              if (hover === undefined) {
                hover = mode === 'vega';
              }

              if (hover) {
                _ref = typeof hover === 'boolean' ? {} : hover, hoverSet = _ref.hoverSet, updateSet = _ref.updateSet;
                view.hover(hoverSet, updateSet);
              }

              if (opts) {
                if (opts.width != null) {
                  view.width(opts.width);
                }

                if (opts.height != null) {
                  view.height(opts.height);
                }

                if (opts.padding != null) {
                  view.padding(opts.padding);
                }
              }

              _context4.next = 30;
              return view.initialize(el).runAsync();

            case 30:
              if (actions !== false) {
                _wrapper = div;

                if (opts.defaultStyle !== false) {
                  details = document.createElement('details');
                  details.title = i18n.CLICK_TO_VIEW_ACTIONS;
                  div.append(details);
                  _wrapper = details;
                  summary = document.createElement('summary');
                  summary.innerHTML = SVG_CIRCLES;
                  details.append(summary);

                  documentClickHandler = function documentClickHandler(ev) {
                    if (!details.contains(ev.target)) {
                      details.removeAttribute('open');
                    }
                  };

                  document.addEventListener('click', documentClickHandler);
                }

                ctrl = document.createElement('div');

                _wrapper.append(ctrl);

                ctrl.classList.add('vega-actions'); // add 'Export' action

                if (actions === true || actions.export !== false) {
                  _loop2 = function _loop2() {
                    var ext = _arr2[_i5];

                    if (actions === true || actions.export === true || actions.export[ext]) {
                      var i18nExportAction = i18n["".concat(ext.toUpperCase(), "_ACTION")];
                      var exportLink = document.createElement('a');
                      exportLink.text = i18nExportAction;
                      exportLink.href = '#';
                      exportLink.target = '_blank';
                      exportLink.download = "".concat(downloadFileName, ".").concat(ext); // add link on mousedown so that it's correct when the click happens

                      exportLink.addEventListener('mousedown', function (e) {
                        return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
                          var url;
                          return regeneratorRuntime.wrap(function _callee3$(_context3) {
                            while (1) {
                              switch (_context3.prev = _context3.next) {
                                case 0:
                                  e.preventDefault();
                                  _context3.next = 3;
                                  return view.toImageURL(ext, opts.scaleFactor);

                                case 3:
                                  url = _context3.sent;
                                  this.href = url;

                                case 5:
                                case "end":
                                  return _context3.stop();
                              }
                            }
                          }, _callee3, this);
                        }));
                      });
                      ctrl.append(exportLink);
                    }
                  };

                  for (_i5 = 0, _arr2 = ['svg', 'png']; _i5 < _arr2.length; _i5++) {
                    _loop2();
                  }
                } // add 'View Source' action


                if (actions === true || actions.source !== false) {
                  viewSourceLink = document.createElement('a');
                  viewSourceLink.text = i18n.SOURCE_ACTION;
                  viewSourceLink.href = '#';
                  viewSourceLink.addEventListener('click', function (e) {
                    var _a, _b;

                    viewSource(jsonStringifyPrettyCompact(spec), (_a = opts.sourceHeader) !== null && _a !== void 0 ? _a : '', (_b = opts.sourceFooter) !== null && _b !== void 0 ? _b : '', mode);
                    e.preventDefault();
                  });
                  ctrl.append(viewSourceLink);
                } // add 'View Compiled' action


                if (mode === 'vega-lite' && (actions === true || actions.compiled !== false)) {
                  compileLink = document.createElement('a');
                  compileLink.text = i18n.COMPILED_ACTION;
                  compileLink.href = '#';
                  compileLink.addEventListener('click', function (e) {
                    var _a, _b;

                    viewSource(jsonStringifyPrettyCompact(vgSpec), (_a = opts.sourceHeader) !== null && _a !== void 0 ? _a : '', (_b = opts.sourceFooter) !== null && _b !== void 0 ? _b : '', 'vega');
                    e.preventDefault();
                  });
                  ctrl.append(compileLink);
                } // add 'Open in Vega Editor' action


                if (actions === true || actions.editor !== false) {
                  editorUrl = (_f = opts.editorUrl) !== null && _f !== void 0 ? _f : 'https://vega.github.io/editor/';
                  editorLink = document.createElement('a');
                  editorLink.text = i18n.EDITOR_ACTION;
                  editorLink.href = '#';
                  editorLink.addEventListener('click', function (e) {
                    post(window, editorUrl, {
                      config: config,
                      mode: mode,
                      renderer: renderer,
                      spec: jsonStringifyPrettyCompact(spec)
                    });
                    e.preventDefault();
                  });
                  ctrl.append(editorLink);
                }
              }

              return _context4.abrupt("return", {
                view: view,
                spec: spec,
                vgSpec: vgSpec,
                finalize: finalize
              });

            case 32:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4);
    }));
  }
  /**
   * Create a promise to an HTML Div element with an embedded Vega-Lite or Vega visualization.
   * The element has a value property with the view. By default all actions except for the editor action are disabled.
   *
   * The main use case is in [Observable](https://observablehq.com/).
   */


  function container(spec) {
    var opt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var _a;

    return __awaiter(this, void 0, void 0, /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
      var wrapper, div, actions, result;
      return regeneratorRuntime.wrap(function _callee5$(_context5) {
        while (1) {
          switch (_context5.prev = _context5.next) {
            case 0:
              wrapper = document.createElement('div');
              wrapper.classList.add('vega-embed-wrapper');
              div = document.createElement('div');
              wrapper.appendChild(div);
              actions = opt.actions === true || opt.actions === false ? opt.actions : Object.assign({
                export: true,
                source: false,
                compiled: true,
                editor: true
              }, (_a = opt.actions) !== null && _a !== void 0 ? _a : {});
              _context5.next = 7;
              return embed(div, spec, Object.assign({
                actions: actions
              }, opt !== null && opt !== void 0 ? opt : {}));

            case 7:
              result = _context5.sent;
              wrapper.value = result.view;
              return _context5.abrupt("return", wrapper);

            case 10:
            case "end":
              return _context5.stop();
          }
        }
      }, _callee5);
    }));
  }
  /**
   * Returns true if the object is an HTML element.
   */


  function isElement(obj) {
    return obj instanceof HTMLElement;
  }

  var wrapper = function wrapper() {
    if (arguments.length > 1 && (vegaImport.isString(arguments.length <= 0 ? undefined : arguments[0]) && !isURL(arguments.length <= 0 ? undefined : arguments[0]) || isElement(arguments.length <= 0 ? undefined : arguments[0]) || arguments.length === 3)) {
      return embed(arguments.length <= 0 ? undefined : arguments[0], arguments.length <= 1 ? undefined : arguments[1], arguments.length <= 2 ? undefined : arguments[2]);
    }

    return container(arguments.length <= 0 ? undefined : arguments[0], arguments.length <= 1 ? undefined : arguments[1]);
  };

  wrapper.vegaLite = _vegaLite;
  wrapper.vl = _vegaLite; // backwards compatibility

  wrapper.container = container;
  wrapper.embed = embed;
  wrapper.vega = vega;
  wrapper.default = embed;
  wrapper.version = pkg.version;
  return wrapper;
});