"use strict";
var chai_1 = require('chai');
var vl = require('../src/vl');
var util_1 = require('../test/util');
var inspect = require('util').inspect;
var fs = require('fs');
var path = require('path');
var validator = new util_1.zSchema({
    noEmptyArrays: true,
    noEmptyStrings: true
});
var vlSchema = require('../vega-lite-schema.json');
var vgSchema = require('../node_modules/vega/vega-schema.json');
function validateVL(spec) {
    var valid = validator.validate(spec, vlSchema);
    var errors = validator.getLastErrors();
    if (!valid) {
        console.log(inspect(errors, { depth: 10, colors: true }));
    }
    chai_1.assert(valid, errors && errors.map(function (err) { return err.message; }).join(', '));
}
function validateVega(spec) {
    var vegaSpec = vl.compile(spec).spec;
    var valid = validator.validate(vegaSpec, vgSchema);
    var errors = validator.getLastErrors();
    if (!valid) {
        console.log(vegaSpec.marks[0].marks[0].properties);
        console.log(inspect(errors, { depth: 10, colors: true }));
    }
    chai_1.assert(valid, errors && errors.map(function (err) { return err.message; }).join(', '));
}
describe('Examples', function () {
    var examples = fs.readdirSync('examples/specs');
    examples.forEach(function (example) {
        if (path.extname(example) !== '.json') {
            return;
        }
        var jsonSpec = JSON.parse(fs.readFileSync('examples/specs/' + example));
        describe(example, function () {
            it('should be valid vega-lite', function () {
                validateVL(jsonSpec);
            });
            it('should produce valid vega', function () {
                validateVega(jsonSpec);
            });
        });
    });
});
//# sourceMappingURL=examples.test.js.map