(function () {
    function trim(str) {
        return str.replace(/^\s+|\s+$/g, '');
    }
    d3.selectAll('h2, h3, h4, h5, h6').each(function () {
        var sel = d3.select(this);
        var link = sel.select('a');
        var name = sel.attr('id');
        var title = sel.text();
        sel.html('<a href="#' + name + '" class="anchor"><span class="octicon octicon-link"></span></a>' + trim(title));
    });
    function renderExample($target, text) {
        $target.classed('example', true);
        $target.text('');
        var vis = $target.append('div').attr('class', 'example-vis');
        var code = $target.append('pre').attr('class', 'example-code')
            .append('code').attr('class', 'json').text(text);
        hljs.highlightBlock(code.node());
        var spec = JSON.parse(text);
        if (spec.data.url) {
            spec.data.url = window.location.origin + BASEURL + '/' + spec.data.url;
        }
        vg.embed(vis.node(), {
            mode: 'vega-lite',
            spec: spec,
            renderer: 'svg',
            actions: {
                source: false,
                export: false
            }
        });
    }
    d3.selectAll('.vl-example').each(function () {
        var sel = d3.select(this);
        var name = sel.attr('data-name');
        if (name) {
            var dir = sel.attr('data-dir');
            var fullUrl = BASEURL + '/examples/specs/' + (dir ? (dir + '/') : '') + name + '.vl.json';
            d3.text(fullUrl, function (error, spec) {
                if (error) {
                    console.error(error);
                }
                else {
                    renderExample(sel, spec);
                }
            });
        }
        else {
            var spec = trim(sel.text());
            renderExample(sel, spec);
        }
    });
    if (d3.select('.gallery').empty() === false) {
        renderGallery();
    }
    function renderGallery() {
        d3.json(window.location.origin + BASEURL + '/examples/vl-examples.json', function (error, VL_SPECS) {
            if (error) {
                return console.warn(error);
            }
            d3.selectAll('div.gallery').each(function () {
                d3.select(this).call(renderGalleryGroup);
            });
            function renderGalleryGroup(selection) {
                var galleryGroupName = selection.attr('data-gallery-group');
                var galleryGroupSpecs;
                try {
                    galleryGroupSpecs = VL_SPECS[galleryGroupName];
                }
                catch (error) {
                    console.log(error.message);
                    return;
                }
                var viz = selection.selectAll('.imagegroup').data(galleryGroupSpecs);
                viz.exit().remove();
                var imageGroup = viz.enter()
                    .append('a')
                    .attr('class', 'imagegroup')
                    .attr('href', function (d) { return 'https://vega.github.io/vega-editor/?mode=vega-lite&spec=' + d.name; })
                    .attr('target', 'blank');
                imageGroup.append('div')
                    .attr('class', 'image')
                    .style('background-image', function (d) { return 'url(' + window.location.origin + BASEURL + '/examples/images/' + d.name + '.svg)'; })
                    .style('background-size', function (d) {
                    var bgSizeDefault = 'cover';
                    if (!d.galleryParameters || !d.galleryParameters.backgroundSize) {
                        return bgSizeDefault;
                    }
                    else {
                        return d.galleryParameters.backgroundSize;
                    }
                })
                    .style('background-position', function (d) {
                    var bgPositionDefault = 'center';
                    if (!d.galleryParameters || !d.galleryParameters.backgroundPosition) {
                        return bgPositionDefault;
                    }
                    else {
                        return d.galleryParameters.backgroundPosition;
                    }
                });
                imageGroup.append('div')
                    .attr('class', 'image-title')
                    .text(function (d) { return d.title; });
            }
        });
    }
})();
//# sourceMappingURL=main.js.map