import { DateTime } from './datetime';
export declare enum AxisOrient {
    TOP,
    RIGHT,
    LEFT,
    BOTTOM,
}
export interface AxisConfig {
    axisWidth?: number;
    layer?: string;
    offset?: number;
    axisColor?: string;
    grid?: boolean;
    gridColor?: string;
    gridDash?: number[];
    gridOpacity?: number;
    gridWidth?: number;
    labels?: boolean;
    labelAngle?: number;
    labelAlign?: string;
    labelBaseline?: string;
    labelMaxLength?: number;
    shortTimeLabels?: boolean;
    subdivide?: number;
    ticks?: number;
    tickColor?: string;
    tickLabelColor?: string;
    tickLabelFont?: string;
    tickLabelFontSize?: number;
    tickPadding?: number;
    tickSize?: number;
    tickSizeMajor?: number;
    tickSizeMinor?: number;
    tickSizeEnd?: number;
    tickWidth?: number;
    titleColor?: string;
    titleFont?: string;
    titleFontSize?: number;
    titleFontWeight?: string;
    titleOffset?: number;
    titleMaxLength?: number;
    characterWidth?: number;
    properties?: any;
}
export declare const defaultAxisConfig: AxisConfig;
export declare const defaultFacetAxisConfig: AxisConfig;
export interface Axis extends AxisConfig {
    labelAngle?: number;
    format?: string;
    orient?: AxisOrient;
    title?: string;
    values?: number[] | DateTime[];
}
