import { Mark } from './mark';
export declare enum Channel {
    X,
    Y,
    X2,
    Y2,
    ROW,
    COLUMN,
    SHAPE,
    SIZE,
    COLOR,
    TEXT,
    DETAIL,
    LABEL,
    PATH,
    ORDER,
    OPACITY,
}
export declare const X: Channel;
export declare const Y: Channel;
export declare const X2: Channel;
export declare const Y2: Channel;
export declare const ROW: Channel;
export declare const COLUMN: Channel;
export declare const SHAPE: Channel;
export declare const SIZE: Channel;
export declare const COLOR: Channel;
export declare const TEXT: Channel;
export declare const DETAIL: Channel;
export declare const LABEL: Channel;
export declare const PATH: Channel;
export declare const ORDER: Channel;
export declare const OPACITY: Channel;
export declare const CHANNELS: Channel[];
export declare const UNIT_CHANNELS: Channel[];
export declare const UNIT_SCALE_CHANNELS: Channel[];
export declare const NONSPATIAL_CHANNELS: Channel[];
export declare const NONSPATIAL_SCALE_CHANNELS: Channel[];
export declare const STACK_GROUP_CHANNELS: Channel[];
export interface SupportedMark {
    point?: boolean;
    tick?: boolean;
    rule?: boolean;
    circle?: boolean;
    square?: boolean;
    bar?: boolean;
    line?: boolean;
    area?: boolean;
    text?: boolean;
}
export declare function supportMark(channel: Channel, mark: Mark): boolean;
export declare function getSupportedMark(channel: Channel): SupportedMark;
export interface SupportedRole {
    measure: boolean;
    dimension: boolean;
}
export declare function getSupportedRole(channel: Channel): SupportedRole;
export declare function hasScale(channel: Channel): boolean;
