import { AxisOrient } from '../axis';
import { Channel } from '../channel';
import { DateTime } from '../datetime';
import { Dict } from '../util';
import { VgAxis } from '../vega.schema';
import { Model } from './model';
export declare function parseAxisComponent(model: Model, axisChannels: Channel[]): Dict<VgAxis>;
export declare function parseInnerAxis(channel: Channel, model: Model): VgAxis;
export declare function parseAxis(channel: Channel, model: Model): VgAxis;
export declare function format(model: Model, channel: Channel): string;
export declare function offset(model: Model, channel: Channel): number;
export declare function gridShow(model: Model, channel: Channel): boolean;
export declare function grid(model: Model, channel: Channel): boolean;
export declare function layer(model: Model, channel: Channel, def: any): string;
export declare function orient(model: Model, channel: Channel): AxisOrient;
export declare function ticks(model: Model, channel: Channel): number;
export declare function tickSize(model: Model, channel: Channel): number;
export declare function tickSizeEnd(model: Model, channel: Channel): number;
export declare function title(model: Model, channel: Channel): string;
export declare function titleOffset(model: Model, channel: Channel): number;
export declare function values(model: Model, channel: Channel): number[] | DateTime[];
export declare namespace properties {
    function axis(model: Model, channel: Channel, axisPropsSpec: any): any;
    function grid(model: Model, channel: Channel, gridPropsSpec: any): any;
    function labels(model: Model, channel: Channel, labelsSpec: any, def: any): any;
    function ticks(model: Model, channel: Channel, ticksPropsSpec: any): any;
    function title(model: Model, channel: Channel, titlePropsSpec: any): any;
}
