import { FieldDef } from '../../fielddef';
import { Formula } from '../../transform';
import { Dict, StringSet } from '../../util';
import { VgData, VgTransform } from '../../vega.schema';
import { FacetModel } from './../facet';
import { LayerModel } from './../layer';
import { Model } from './../model';
import { UnitModel } from './../unit';
export interface DataComponent {
    source: VgData;
    formatParse: Dict<string>;
    nullFilter: Dict<FieldDef>;
    calculate: Dict<Formula>;
    filter: string;
    bin: Dict<VgTransform[]>;
    timeUnit: Dict<VgTransform>;
    nonPositiveFilter: Dict<boolean>;
    stackScale: VgData;
    colorRank: Dict<VgTransform[]>;
    timeUnitDomain: StringSet;
    summary: SummaryComponent[];
}
export interface SummaryComponent {
    name: string;
    dimensions: StringSet;
    measures: Dict<StringSet>;
}
export declare function parseUnitData(model: UnitModel): DataComponent;
export declare function parseFacetData(model: FacetModel): DataComponent;
export declare function parseLayerData(model: LayerModel): DataComponent;
export declare function assembleData(model: Model, data: VgData[]): VgData[];
