"use strict";
var datetime_1 = require('../../datetime');
var fielddef_1 = require('../../fielddef');
var filter_1 = require('../../filter');
var type_1 = require('../../type');
var util_1 = require('../../util');
var formatParse;
(function (formatParse) {
    function parse(model) {
        var calcFieldMap = (model.calculate() || []).reduce(function (fieldMap, formula) {
            fieldMap[formula.field] = true;
            return fieldMap;
        }, {});
        var parseComponent = {};
        var filter = model.filter();
        if (!util_1.isArray(filter)) {
            filter = [filter];
        }
        filter.forEach(function (f) {
            var val = null;
            if (filter_1.isEqualFilter(f)) {
                val = f.equal;
            }
            else if (filter_1.isRangeFilter(f)) {
                val = f.range[0];
            }
            else if (filter_1.isOneOfFilter(f)) {
                val = (f.oneOf || f['in'])[0];
            }
            if (!!val) {
                if (datetime_1.isDateTime(val)) {
                    parseComponent[f['field']] = 'date';
                }
                else if (util_1.isNumber(val)) {
                    parseComponent[f['field']] = 'number';
                }
                else if (util_1.isString(val)) {
                    parseComponent[f['field']] = 'string';
                }
            }
        });
        model.forEach(function (fieldDef) {
            if (fieldDef.type === type_1.TEMPORAL) {
                parseComponent[fieldDef.field] = 'date';
            }
            else if (fieldDef.type === type_1.QUANTITATIVE) {
                if (fielddef_1.isCount(fieldDef) || calcFieldMap[fieldDef.field]) {
                    return;
                }
                parseComponent[fieldDef.field] = 'number';
            }
        });
        var data = model.data();
        if (data && data.format && data.format.parse) {
            var parse_1 = data.format.parse;
            util_1.keys(parse_1).forEach(function (field) {
                parseComponent[field] = parse_1[field];
            });
        }
        return parseComponent;
    }
    formatParse.parseUnit = parse;
    function parseFacet(model) {
        var parseComponent = parse(model);
        var childDataComponent = model.child().component.data;
        if (!childDataComponent.source && childDataComponent.formatParse) {
            util_1.extend(parseComponent, childDataComponent.formatParse);
            delete childDataComponent.formatParse;
        }
        return parseComponent;
    }
    formatParse.parseFacet = parseFacet;
    function parseLayer(model) {
        var parseComponent = parse(model);
        model.children().forEach(function (child) {
            var childDataComponent = child.component.data;
            if (model.compatibleSource(child) && !util_1.differ(childDataComponent.formatParse, parseComponent)) {
                util_1.extend(parseComponent, childDataComponent.formatParse);
                delete childDataComponent.formatParse;
            }
        });
        return parseComponent;
    }
    formatParse.parseLayer = parseLayer;
})(formatParse = exports.formatParse || (exports.formatParse = {}));
//# sourceMappingURL=formatparse.js.map