import { Channel } from '../channel';
import { Facet } from '../facet';
import { FieldDef } from '../fielddef';
import { FacetSpec } from '../spec';
import { VgData } from '../vega.schema';
import { Model } from './model';
export declare class FacetModel extends Model {
    private _facet;
    private _child;
    constructor(spec: FacetSpec, parent: Model, parentGivenName: string);
    private _initConfig(specConfig, parent);
    private _initFacet(facet);
    private _initScale(facet, config, child);
    private _initAxis(facet, config, child);
    facet(): Facet;
    has(channel: Channel): boolean;
    child(): Model;
    private hasSummary();
    dataTable(): string;
    fieldDef(channel: Channel): FieldDef;
    stack(): any;
    parseData(): void;
    parseSelectionData(): void;
    parseLayoutData(): void;
    parseScale(): void;
    parseMark(): void;
    parseAxis(): void;
    parseAxisGroup(): void;
    parseGridGroup(): void;
    parseLegend(): void;
    assembleParentGroupProperties(): any;
    assembleData(data: VgData[]): VgData[];
    assembleLayout(layoutData: VgData[]): VgData[];
    assembleMarks(): any[];
    channels(): Channel[];
    protected mapping(): Facet;
    isFacet(): boolean;
}
