import { Channel } from '../channel';
import { LayerSpec } from '../spec';
import { Model } from './model';
import { UnitModel } from './unit';
import { FieldDef } from '../fielddef';
import { VgData } from '../vega.schema';
export declare class LayerModel extends Model {
    private _children;
    private _width;
    private _height;
    constructor(spec: LayerSpec, parent: Model, parentGivenName: string);
    private _initConfig(specConfig, parent);
    readonly width: number;
    readonly height: number;
    has(channel: Channel): boolean;
    children(): UnitModel[];
    isOrdinalScale(channel: Channel): boolean;
    dataTable(): string;
    fieldDef(channel: Channel): FieldDef;
    stack(): any;
    parseData(): void;
    parseSelectionData(): void;
    parseLayoutData(): void;
    parseScale(): void;
    parseMark(): void;
    parseAxis(): void;
    parseAxisGroup(): any;
    parseGridGroup(): any;
    parseLegend(): void;
    assembleParentGroupProperties(): any;
    assembleData(data: VgData[]): VgData[];
    assembleLayout(layoutData: VgData[]): VgData[];
    assembleMarks(): any[];
    channels(): any[];
    protected mapping(): any;
    isLayer(): boolean;
    compatibleSource(child: UnitModel): boolean;
}
