import { Channel } from '../channel';
import { Config } from '../config';
import { DateTime } from '../datetime';
import { FieldDef } from '../fielddef';
import { Legend } from '../legend';
import { Dict } from '../util';
import { UnitModel } from './unit';
import { VgLegend } from '../vega.schema';
import { Bin } from '../bin';
export declare function parseLegendComponent(model: UnitModel): Dict<VgLegend>;
export declare function parseLegend(model: UnitModel, channel: Channel): VgLegend;
export declare function title(legend: Legend, fieldDef: FieldDef, config: Config): string;
export declare function values(legend: Legend): string[] | number[] | DateTime[];
export declare function useColorLegendScale(fieldDef: FieldDef): true | Bin;
export declare namespace properties {
    function symbols(fieldDef: FieldDef, symbolsSpec: any, model: UnitModel, channel: Channel): any;
    function labels(fieldDef: FieldDef, labelsSpec: any, model: UnitModel, channel: Channel): any;
    function title(fieldDef: FieldDef, titleSpec: any, model: UnitModel, channel: Channel): any;
}
