"use strict";
var channel_1 = require('../../channel');
var config_1 = require('../../config');
var fielddef_1 = require('../../fielddef');
var scale_1 = require('../../scale');
var util_1 = require('../../util');
var common_1 = require('../common');
var bar;
(function (bar) {
    function markType() {
        return 'rect';
    }
    bar.markType = markType;
    function properties(model) {
        var p = {};
        var orient = model.config().mark.orient;
        var stack = model.stack();
        var xFieldDef = model.encoding().x;
        var x2FieldDef = model.encoding().x2;
        var xIsMeasure = fielddef_1.isMeasure(xFieldDef) || fielddef_1.isMeasure(x2FieldDef);
        if (stack && channel_1.X === stack.fieldChannel) {
            p.x = {
                scale: model.scaleName(channel_1.X),
                field: model.field(channel_1.X, { suffix: 'start' })
            };
            p.x2 = {
                scale: model.scaleName(channel_1.X),
                field: model.field(channel_1.X, { suffix: 'end' })
            };
        }
        else if (xIsMeasure) {
            if (orient === config_1.Orient.HORIZONTAL) {
                if (model.has(channel_1.X)) {
                    p.x = {
                        scale: model.scaleName(channel_1.X),
                        field: model.field(channel_1.X)
                    };
                }
                else {
                    p.x = {
                        scale: model.scaleName(channel_1.X),
                        value: 0
                    };
                }
                if (model.has(channel_1.X2)) {
                    p.x2 = {
                        scale: model.scaleName(channel_1.X),
                        field: model.field(channel_1.X2)
                    };
                }
                else {
                    if (util_1.contains([scale_1.ScaleType.LOG, scale_1.ScaleType.TIME, scale_1.ScaleType.UTC], model.scale(channel_1.X).type) ||
                        model.scale(channel_1.X).zero === false) {
                        p.x2 = { value: 0 };
                    }
                    else {
                        p.x2 = {
                            scale: model.scaleName(channel_1.X),
                            value: 0
                        };
                    }
                }
            }
            else {
                p.xc = {
                    scale: model.scaleName(channel_1.X),
                    field: model.field(channel_1.X)
                };
                p.width = { value: sizeValue(model, channel_1.X) };
            }
        }
        else {
            if (model.has(channel_1.X)) {
                if (model.encoding().x.bin) {
                    if (model.has(channel_1.SIZE) && orient !== config_1.Orient.HORIZONTAL) {
                        p.xc = {
                            scale: model.scaleName(channel_1.X),
                            field: model.field(channel_1.X, { binSuffix: 'mid' })
                        };
                        p.width = {
                            scale: model.scaleName(channel_1.SIZE),
                            field: model.field(channel_1.SIZE)
                        };
                    }
                    else {
                        p.x = {
                            scale: model.scaleName(channel_1.X),
                            field: model.field(channel_1.X, { binSuffix: 'start' }),
                            offset: 1
                        };
                        p.x2 = {
                            scale: model.scaleName(channel_1.X),
                            field: model.field(channel_1.X, { binSuffix: 'end' })
                        };
                    }
                }
                else if (model.scale(channel_1.X).bandSize === scale_1.BANDSIZE_FIT) {
                    p.x = {
                        scale: model.scaleName(channel_1.X),
                        field: model.field(channel_1.X),
                        offset: 0.5
                    };
                }
                else {
                    p.xc = {
                        scale: model.scaleName(channel_1.X),
                        field: model.field(channel_1.X)
                    };
                }
            }
            else {
                p.x = { value: 0, offset: 2 };
            }
            p.width = model.has(channel_1.X) && model.scale(channel_1.X).bandSize === scale_1.BANDSIZE_FIT ? {
                scale: model.scaleName(channel_1.X),
                band: true,
                offset: -0.5
            } : model.has(channel_1.SIZE) && orient !== config_1.Orient.HORIZONTAL ? {
                scale: model.scaleName(channel_1.SIZE),
                field: model.field(channel_1.SIZE)
            } : {
                value: sizeValue(model, (channel_1.X))
            };
        }
        var yFieldDef = model.encoding().y;
        var y2FieldDef = model.encoding().y2;
        var yIsMeasure = fielddef_1.isMeasure(yFieldDef) || fielddef_1.isMeasure(y2FieldDef);
        if (stack && channel_1.Y === stack.fieldChannel) {
            p.y = {
                scale: model.scaleName(channel_1.Y),
                field: model.field(channel_1.Y, { suffix: 'start' })
            };
            p.y2 = {
                scale: model.scaleName(channel_1.Y),
                field: model.field(channel_1.Y, { suffix: 'end' })
            };
        }
        else if (yIsMeasure) {
            if (orient !== config_1.Orient.HORIZONTAL) {
                if (model.has(channel_1.Y)) {
                    p.y = {
                        scale: model.scaleName(channel_1.Y),
                        field: model.field(channel_1.Y)
                    };
                }
                else {
                    p.y = {
                        scale: model.scaleName(channel_1.Y),
                        value: 0
                    };
                }
                if (model.has(channel_1.Y2)) {
                    p.y2 = {
                        scale: model.scaleName(channel_1.Y),
                        field: model.field(channel_1.Y2)
                    };
                }
                else {
                    if (util_1.contains([scale_1.ScaleType.LOG, scale_1.ScaleType.TIME, scale_1.ScaleType.UTC], model.scale(channel_1.Y).type) ||
                        model.scale(channel_1.Y).zero === false) {
                        p.y2 = {
                            field: { group: 'height' }
                        };
                    }
                    else {
                        p.y2 = {
                            scale: model.scaleName(channel_1.Y),
                            value: 0
                        };
                    }
                }
            }
            else {
                p.yc = {
                    scale: model.scaleName(channel_1.Y),
                    field: model.field(channel_1.Y)
                };
                p.height = { value: sizeValue(model, channel_1.Y) };
            }
        }
        else {
            if (model.has(channel_1.Y)) {
                if (model.encoding().y.bin) {
                    if (model.has(channel_1.SIZE) && orient === config_1.Orient.HORIZONTAL) {
                        p.yc = {
                            scale: model.scaleName(channel_1.Y),
                            field: model.field(channel_1.Y, { binSuffix: 'mid' })
                        };
                        p.height = {
                            scale: model.scaleName(channel_1.SIZE),
                            field: model.field(channel_1.SIZE)
                        };
                    }
                    else {
                        p.y = {
                            scale: model.scaleName(channel_1.Y),
                            field: model.field(channel_1.Y, { binSuffix: 'start' })
                        };
                        p.y2 = {
                            scale: model.scaleName(channel_1.Y),
                            field: model.field(channel_1.Y, { binSuffix: 'end' }),
                            offset: 1
                        };
                    }
                }
                else if (model.scale(channel_1.Y).bandSize === scale_1.BANDSIZE_FIT) {
                    p.y = {
                        scale: model.scaleName(channel_1.Y),
                        field: model.field(channel_1.Y),
                        offset: 0.5
                    };
                }
                else {
                    p.yc = {
                        scale: model.scaleName(channel_1.Y),
                        field: model.field(channel_1.Y)
                    };
                }
            }
            else {
                p.y2 = {
                    field: { group: 'height' },
                    offset: -1
                };
            }
            p.height = model.has(channel_1.Y) && model.scale(channel_1.Y).bandSize === scale_1.BANDSIZE_FIT ? {
                scale: model.scaleName(channel_1.Y),
                band: true,
                offset: -0.5
            } : model.has(channel_1.SIZE) && orient === config_1.Orient.HORIZONTAL ? {
                scale: model.scaleName(channel_1.SIZE),
                field: model.field(channel_1.SIZE)
            } : {
                value: sizeValue(model, channel_1.Y)
            };
        }
        common_1.applyColorAndOpacity(p, model);
        return p;
    }
    bar.properties = properties;
    function sizeValue(model, channel) {
        var fieldDef = model.encoding().size;
        if (fieldDef && fieldDef.value !== undefined) {
            return fieldDef.value;
        }
        var markConfig = model.config().mark;
        if (markConfig.barSize) {
            return markConfig.barSize;
        }
        return model.isOrdinalScale(channel) ?
            model.scale(channel).bandSize - 1 :
            !model.has(channel) ?
                model.config().scale.bandSize - 1 :
                markConfig.barThinSize;
    }
})(bar = exports.bar || (exports.bar = {}));
//# sourceMappingURL=bar.js.map