import { Axis } from '../axis';
import { Channel } from '../channel';
import { Config, CellConfig } from '../config';
import { Data, DataTable } from '../data';
import { FieldDef, FieldRefOption } from '../fielddef';
import { Legend } from '../legend';
import { Scale } from '../scale';
import { SortField, SortOrder } from '../sort';
import { BaseSpec } from '../spec';
import { Transform } from '../transform';
import { Dict } from '../util';
import { VgData, VgMarkGroup, VgScale, VgAxis, VgLegend } from '../vega.schema';
import { DataComponent } from './data/data';
import { LayoutComponent } from './layout';
import { ScaleComponents } from './scale';
import { Formula } from '../transform';
import { OneOfFilter, EqualFilter, RangeFilter } from '../filter';
export interface Component {
    data: DataComponent;
    layout: LayoutComponent;
    scale: Dict<ScaleComponents>;
    axis: Dict<VgAxis>;
    legend: Dict<VgLegend>;
    axisGroup: Dict<VgMarkGroup>;
    gridGroup: Dict<VgMarkGroup[]>;
    mark: VgMarkGroup[];
}
export interface NameMapInterface {
    rename(oldname: string, newName: string): void;
    has(name: string): boolean;
    get(name: string): string;
}
export declare abstract class Model {
    protected _parent: Model;
    protected _name: string;
    protected _description: string;
    protected _data: Data;
    protected _dataNameMap: NameMapInterface;
    protected _scaleNameMap: NameMapInterface;
    protected _sizeNameMap: NameMapInterface;
    protected _transform: Transform;
    protected _scale: Dict<Scale>;
    protected _axis: Dict<Axis>;
    protected _legend: Dict<Legend>;
    protected _config: Config;
    protected _warnings: string[];
    component: Component;
    constructor(spec: BaseSpec, parent: Model, parentGivenName: string);
    parse(): void;
    abstract parseData(): any;
    abstract parseSelectionData(): any;
    abstract parseLayoutData(): any;
    abstract parseScale(): any;
    abstract parseMark(): any;
    abstract parseAxis(): any;
    abstract parseLegend(): any;
    abstract parseAxisGroup(): any;
    abstract parseGridGroup(): any;
    abstract assembleData(data: VgData[]): VgData[];
    abstract assembleLayout(layoutData: VgData[]): VgData[];
    assembleScales(): VgScale[];
    abstract assembleMarks(): any[];
    assembleAxes(): VgAxis[];
    assembleLegends(): any[];
    assembleGroup(): any;
    abstract assembleParentGroupProperties(cellConfig: CellConfig): any;
    abstract channels(): Channel[];
    protected abstract mapping(): any;
    reduce(f: (acc: any, fd: FieldDef, c: Channel) => any, init: any, t?: any): any;
    forEach(f: (fd: FieldDef, c: Channel, i: number) => void, t?: any): void;
    abstract has(channel: Channel): boolean;
    parent(): Model;
    name(text: string, delimiter?: string): string;
    description(): string;
    data(): Data;
    renameData(oldName: string, newName: string): void;
    dataName(dataSourceType: DataTable): string;
    renameSize(oldName: string, newName: string): void;
    channelSizeName(channel: Channel): string;
    sizeName(size: string): string;
    abstract dataTable(): string;
    calculate(): Formula[];
    filterInvalid(): any;
    filter(): string | EqualFilter | RangeFilter | OneOfFilter | (string | EqualFilter | RangeFilter | OneOfFilter)[];
    field(channel: Channel, opt?: FieldRefOption): string;
    abstract fieldDef(channel: Channel): FieldDef;
    scale(channel: Channel): Scale;
    isOrdinalScale(channel: Channel): boolean;
    renameScale(oldName: string, newName: string): void;
    scaleName(originalScaleName: Channel | string, parse?: boolean): string;
    sort(channel: Channel): SortField | SortOrder;
    abstract stack(): any;
    axis(channel: Channel): Axis;
    legend(channel: Channel): Legend;
    config(): Config;
    addWarning(message: string): void;
    warnings(): string[];
    isUnit(): boolean;
    isFacet(): boolean;
    isLayer(): boolean;
}
