import { Channel } from '../channel';
import { FieldDef } from '../fielddef';
import { Mark } from '../mark';
import { Scale, ScaleConfig, ScaleType, NiceTime, BandSize } from '../scale';
import { Dict } from '../util';
import { VgScale } from '../vega.schema';
import { Model } from './model';
export declare const COLOR_LEGEND: string;
export declare const COLOR_LEGEND_LABEL: string;
export declare type ScaleComponent = VgScale;
export declare type ScaleComponents = {
    main: ScaleComponent;
    colorLegend?: ScaleComponent;
    binColorLegend?: ScaleComponent;
};
export declare function parseScaleComponent(model: Model): Dict<ScaleComponents>;
export declare function scaleType(scale: Scale, fieldDef: FieldDef, channel: Channel, mark: Mark): ScaleType;
export declare function scaleBandSize(scaleType: ScaleType, bandSize: number | BandSize, scaleConfig: ScaleConfig, topLevelSize: number, mark: Mark, channel: Channel): number | BandSize;
export declare function domain(scale: Scale, model: Model, channel: Channel): any;
export declare function domainSort(model: Model, channel: Channel, scaleType: ScaleType): any;
export declare function rangeMixins(scale: Scale, model: Model, channel: Channel): any;
export declare function clamp(scale: Scale): boolean;
export declare function exponent(scale: Scale): number;
export declare function nice(scale: Scale, channel: Channel, fieldDef: FieldDef): boolean | NiceTime;
export declare function padding(scale: Scale, channel: Channel, __: any, ___: any, scaleDef: any): number;
export declare function points(scale: Scale, channel: Channel, __: any, model: Model): boolean;
export declare function round(scale: Scale, channel: Channel): boolean;
export declare function zero(scale: Scale, channel: Channel, fieldDef: FieldDef): boolean;
