import { Channel } from '../channel';
import { CellConfig } from '../config';
import { Encoding } from '../encoding';
import { FieldDef, FieldRefOption } from '../fielddef';
import { Mark } from '../mark';
import { ExtendedUnitSpec } from '../spec';
import { VgData } from '../vega.schema';
import { Model } from './model';
import { StackProperties } from '../stack';
export declare class UnitModel extends Model {
    private _width;
    private _height;
    private _mark;
    private _encoding;
    private _stack;
    constructor(spec: ExtendedUnitSpec, parent: Model, parentGivenName: string);
    private _initEncoding(mark, encoding);
    private _initConfig(specConfig, parent, mark, encoding, stack);
    private _initScale(mark, encoding, config, topLevelWidth, topLevelHeight);
    private _initSize(mark, scale, width, height, cellConfig, scaleConfig);
    private _initAxis(encoding, config);
    private _initLegend(encoding, config);
    readonly width: number;
    readonly height: number;
    parseData(): void;
    parseSelectionData(): void;
    parseLayoutData(): void;
    parseScale(): void;
    parseMark(): void;
    parseAxis(): void;
    parseAxisGroup(): any;
    parseGridGroup(): any;
    parseLegend(): void;
    assembleData(data: VgData[]): VgData[];
    assembleLayout(layoutData: VgData[]): VgData[];
    assembleMarks(): any[];
    assembleParentGroupProperties(cellConfig: CellConfig): any;
    channels(): Channel[];
    protected mapping(): Encoding;
    stack(): StackProperties;
    toSpec(excludeConfig?: any, excludeData?: any): any;
    mark(): Mark;
    has(channel: Channel): boolean;
    encoding(): Encoding;
    fieldDef(channel: Channel): FieldDef;
    field(channel: Channel, opt?: FieldRefOption): string;
    dataTable(): string;
    isUnit(): boolean;
}
