import { ScaleConfig, FacetScaleConfig } from './scale';
import { AxisConfig } from './axis';
import { LegendConfig } from './legend';
import { StackOffset } from './stack';
export interface CellConfig {
    width?: number;
    height?: number;
    clip?: boolean;
    fill?: string;
    fillOpacity?: number;
    stroke?: string;
    strokeOpacity?: number;
    strokeWidth?: number;
    strokeDash?: number[];
    strokeDashOffset?: number;
}
export declare const defaultCellConfig: CellConfig;
export declare const defaultFacetCellConfig: CellConfig;
export interface FacetConfig {
    scale?: FacetScaleConfig;
    axis?: AxisConfig;
    grid?: FacetGridConfig;
    cell?: CellConfig;
}
export interface FacetGridConfig {
    color?: string;
    opacity?: number;
    offset?: number;
}
export declare const defaultFacetConfig: FacetConfig;
export declare enum FontWeight {
    NORMAL,
    BOLD,
}
export declare enum Shape {
    CIRCLE,
    SQUARE,
    CROSS,
    DIAMOND,
    TRIANGLEUP,
    TRIANGLEDOWN,
}
export declare enum Orient {
    HORIZONTAL,
    VERTICAL,
}
export declare enum HorizontalAlign {
    LEFT,
    RIGHT,
    CENTER,
}
export declare enum VerticalAlign {
    TOP,
    MIDDLE,
    BOTTOM,
}
export declare enum FontStyle {
    NORMAL,
    ITALIC,
}
export declare enum Interpolate {
    LINEAR,
    LINEAR_CLOSED,
    STEP,
    STEP_BEFORE,
    STEP_AFTER,
    BASIS,
    BASIS_OPEN,
    BASIS_CLOSED,
    CARDINAL,
    CARDINAL_OPEN,
    CARDINAL_CLOSED,
    BUNDLE,
    MONOTONE,
}
export declare enum AreaOverlay {
    LINE,
    LINEPOINT,
    NONE,
}
export interface OverlayConfig {
    line?: boolean;
    area?: AreaOverlay;
    pointStyle?: MarkConfig;
    lineStyle?: MarkConfig;
}
export declare const defaultOverlayConfig: OverlayConfig;
export interface MarkConfig {
    filled?: boolean;
    color?: string;
    fill?: string;
    stroke?: string;
    opacity?: number;
    fillOpacity?: number;
    strokeOpacity?: number;
    strokeWidth?: number;
    strokeDash?: number[];
    strokeDashOffset?: number;
    stacked?: StackOffset;
    orient?: Orient;
    interpolate?: Interpolate;
    tension?: number;
    lineSize?: number;
    ruleSize?: number;
    barSize?: number;
    barThinSize?: number;
    shape?: Shape | string;
    size?: number;
    tickSize?: number;
    tickThickness?: number;
    align?: HorizontalAlign;
    angle?: number;
    baseline?: VerticalAlign;
    dx?: number;
    dy?: number;
    radius?: number;
    theta?: number;
    font?: string;
    fontSize?: number;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    format?: string;
    shortTimeLabels?: boolean;
    text?: string;
    applyColorToBackground?: boolean;
}
export declare const defaultMarkConfig: MarkConfig;
export interface Config {
    viewport?: number;
    background?: string;
    numberFormat?: string;
    timeFormat?: string;
    countTitle?: string;
    cell?: CellConfig;
    mark?: MarkConfig;
    overlay?: OverlayConfig;
    scale?: ScaleConfig;
    axis?: AxisConfig;
    legend?: LegendConfig;
    facet?: FacetConfig;
}
export declare const defaultConfig: Config;
