import { Type } from './type';
export interface DataFormat {
    type?: DataFormatType;
    parse?: any;
    property?: string;
    feature?: string;
    mesh?: string;
}
export declare enum DataFormatType {
    JSON,
    CSV,
    TSV,
    TOPOJSON,
}
export interface Data {
    format?: DataFormat;
    url?: string;
    values?: any[];
}
export declare enum DataTable {
    SOURCE,
    SUMMARY,
    STACKED_SCALE,
    LAYOUT,
}
export declare const SUMMARY: DataTable;
export declare const SOURCE: DataTable;
export declare const STACKED_SCALE: DataTable;
export declare const LAYOUT: DataTable;
export declare const types: {
    'boolean': Type;
    'number': Type;
    'integer': Type;
    'date': Type;
    'string': Type;
};
