export declare type Month = number;
export declare type Day = number;
export interface DateTime {
    year?: number;
    quarter?: number;
    month?: Month | string;
    date?: number;
    day?: Day | string;
    hours?: number;
    minutes?: number;
    seconds?: number;
    milliseconds?: number;
}
export interface DateTimeExpr {
    year?: string;
    quarter?: string;
    month?: string;
    date?: string;
    day?: string;
    hours?: string;
    minutes?: string;
    seconds?: string;
    milliseconds?: string;
}
export declare function isDateTime(o: any): o is DateTime;
export declare const MONTHS: string[];
export declare const SHORT_MONTHS: string[];
export declare const DAYS: string[];
export declare const SHORT_DAYS: string[];
export declare function timestamp(d: DateTime, normalize: any): number;
export declare function dateTimeExpr(d: DateTime | DateTimeExpr, normalize?: boolean): string;
