import { FieldDef, PositionChannelDef, FacetChannelDef, ChannelDefWithLegend, OrderChannelDef } from './fielddef';
import { Channel } from './channel';
export interface UnitEncoding {
    x?: PositionChannelDef;
    y?: PositionChannelDef;
    x2?: FieldDef;
    y2?: FieldDef;
    color?: ChannelDefWithLegend;
    opacity?: ChannelDefWithLegend;
    size?: ChannelDefWithLegend;
    shape?: ChannelDefWithLegend;
    detail?: FieldDef | FieldDef[];
    text?: FieldDef;
    label?: FieldDef;
    path?: OrderChannelDef | OrderChannelDef[];
    order?: OrderChannelDef | OrderChannelDef[];
}
export interface Encoding extends UnitEncoding {
    row?: FacetChannelDef;
    column?: FacetChannelDef;
}
export declare function countRetinal(encoding: Encoding): number;
export declare function channels(encoding: Encoding): Channel[];
export declare function has(encoding: Encoding, channel: Channel): boolean;
export declare function isAggregate(encoding: Encoding): boolean;
export declare function isRanged(encoding: Encoding): boolean;
export declare function fieldDefs(encoding: Encoding): FieldDef[];
export declare function forEach(encoding: Encoding, f: (fd: FieldDef, c: Channel, i: number) => void, thisArg?: any): void;
export declare function channelMappingForEach(channels: Channel[], mapping: any, f: (fd: FieldDef, c: Channel, i: number) => void, thisArg?: any): void;
export declare function map(encoding: Encoding, f: (fd: FieldDef, c: Channel, i: number) => any, thisArg?: any): any[];
export declare function channelMappingMap(channels: Channel[], mapping: any, f: (fd: FieldDef, c: Channel, i: number) => any, thisArg?: any): any[];
export declare function reduce(encoding: Encoding, f: (acc: any, fd: FieldDef, c: Channel) => any, init: any, thisArg?: any): any;
export declare function channelMappingReduce(channels: Channel[], mapping: any, f: (acc: any, fd: FieldDef, c: Channel) => any, init: any, thisArg?: any): any;
