import { AggregateOp } from './aggregate';
import { Axis } from './axis';
import { Bin } from './bin';
import { Config } from './config';
import { Legend } from './legend';
import { Scale, ScaleType } from './scale';
import { SortField, SortOrder } from './sort';
import { TimeUnit } from './timeunit';
import { Type } from './type';
export interface FieldDef {
    field?: string;
    type?: Type;
    value?: number | string | boolean;
    timeUnit?: TimeUnit;
    bin?: boolean | Bin;
    aggregate?: AggregateOp;
    title?: string;
}
export interface ChannelDefWithScale extends FieldDef {
    scale?: Scale;
    sort?: SortField | SortOrder;
}
export interface PositionChannelDef extends ChannelDefWithScale {
    axis?: Axis;
}
export interface ChannelDefWithLegend extends ChannelDefWithScale {
    legend?: Legend;
}
export interface OrderChannelDef extends FieldDef {
    sort?: SortOrder;
}
export declare type FacetChannelDef = PositionChannelDef;
export interface FieldRefOption {
    nofn?: boolean;
    noAggregate?: boolean;
    datum?: boolean;
    fn?: string;
    prefix?: string;
    scaleType?: ScaleType;
    binSuffix?: string;
    suffix?: string;
}
export declare function field(fieldDef: FieldDef, opt?: FieldRefOption): string;
export declare function isDimension(fieldDef: FieldDef): boolean;
export declare function isMeasure(fieldDef: FieldDef): boolean;
export declare function count(): FieldDef;
export declare function isCount(fieldDef: FieldDef): boolean;
export declare function title(fieldDef: FieldDef, config: Config): string;
