import { DateTime } from './datetime';
import { TimeUnit } from './timeunit';
export declare type Filter = EqualFilter | RangeFilter | OneOfFilter;
export interface EqualFilter {
    timeUnit?: TimeUnit;
    field: string;
    equal: string | number | boolean | DateTime;
}
export declare function isEqualFilter(filter: any): filter is EqualFilter;
export interface RangeFilter {
    timeUnit?: TimeUnit;
    field: string;
    range: Array<number | DateTime>;
}
export declare function isRangeFilter(filter: any): filter is RangeFilter;
export interface OneOfFilter {
    timeUnit?: TimeUnit;
    field: string;
    oneOf: Array<string | number | boolean | DateTime>;
}
export declare function isOneOfFilter(filter: any): filter is OneOfFilter;
export declare function expression(filter: Filter | string): string;
