import { DateTime } from './datetime';
export declare enum ScaleType {
    LINEAR,
    LOG,
    POW,
    SQRT,
    QUANTILE,
    QUANTIZE,
    ORDINAL,
    TIME,
    UTC,
}
export declare enum NiceTime {
    SECOND,
    MINUTE,
    HOUR,
    DAY,
    WEEK,
    MONTH,
    YEAR,
}
export declare enum BandSize {
    FIT,
}
export declare const BANDSIZE_FIT: BandSize;
export interface ScaleConfig {
    round?: boolean;
    textBandWidth?: number;
    bandSize?: number | BandSize;
    opacity?: number[];
    padding?: number;
    useRawDomain?: boolean;
    nominalColorRange?: string | string[];
    sequentialColorRange?: string | string[];
    shapeRange?: string | string[];
    barSizeRange?: number[];
    fontSizeRange?: number[];
    ruleSizeRange?: number[];
    tickSizeRange?: number[];
    pointSizeRange?: number[];
}
export declare const defaultScaleConfig: ScaleConfig;
export interface FacetScaleConfig {
    round?: boolean;
    padding?: number;
}
export declare const defaultFacetScaleConfig: FacetScaleConfig;
export interface Scale {
    type?: ScaleType;
    domain?: number[] | string[] | DateTime[];
    range?: string | number[] | string[];
    round?: boolean;
    bandSize?: number | BandSize;
    padding?: number;
    clamp?: boolean;
    nice?: boolean | NiceTime;
    exponent?: number;
    zero?: boolean;
    useRawDomain?: boolean;
}
