import { Config } from './config';
import { Data } from './data';
import { Encoding, UnitEncoding } from './encoding';
import { Facet } from './facet';
import { FieldDef } from './fielddef';
import { Mark } from './mark';
import { Transform } from './transform';
export interface BaseSpec {
    name?: string;
    description?: string;
    data?: Data;
    transform?: Transform;
    config?: Config;
}
export interface UnitSpec extends BaseSpec {
    width?: number;
    height?: number;
    mark: Mark;
    encoding?: UnitEncoding;
}
export interface ExtendedUnitSpec extends BaseSpec {
    width?: number;
    height?: number;
    mark: Mark;
    encoding?: Encoding;
}
export interface FacetSpec extends BaseSpec {
    facet: Facet;
    spec: LayerSpec | UnitSpec;
}
export interface LayerSpec extends BaseSpec {
    width?: number;
    height?: number;
    layers: UnitSpec[];
}
export interface ExtendedFacetSpec extends BaseSpec {
    facet: Facet;
    spec: ExtendedUnitSpec | FacetSpec;
}
export declare type ExtendedSpec = ExtendedUnitSpec | FacetSpec | LayerSpec;
export declare type Spec = UnitSpec | FacetSpec | LayerSpec;
export declare function isSomeFacetSpec(spec: ExtendedSpec | ExtendedFacetSpec): spec is FacetSpec | ExtendedFacetSpec;
export declare function isExtendedUnitSpec(spec: ExtendedSpec): spec is ExtendedUnitSpec;
export declare function isUnitSpec(spec: ExtendedSpec): spec is UnitSpec;
export declare function isSomeUnitSpec(spec: ExtendedSpec): spec is ExtendedUnitSpec | UnitSpec;
export declare function isLayerSpec(spec: ExtendedSpec | ExtendedFacetSpec): spec is LayerSpec;
export declare function normalize(spec: ExtendedSpec): Spec;
export declare function normalizeExtendedUnitSpec(spec: ExtendedUnitSpec): Spec;
export declare function normalizeUnitSpec(spec: UnitSpec): Spec;
export declare function normalizeRangedUnitSpec(spec: UnitSpec): Spec;
export declare function normalizeErrorBarUnitSpec(spec: UnitSpec): Spec;
export declare function normalizeOverlay(spec: UnitSpec, overlayWithPoint: boolean, overlayWithLine: boolean): LayerSpec;
export declare function fieldDefs(spec: ExtendedSpec | ExtendedFacetSpec): FieldDef[];
export declare function isStacked(spec: ExtendedUnitSpec): boolean;
