import { Channel } from './channel';
import { ScaleType } from './scale';
export declare enum TimeUnit {
    YEAR,
    MONTH,
    DAY,
    DATE,
    HOURS,
    MINUTES,
    SECONDS,
    MILLISECONDS,
    YEARMONTH,
    YEARMONTHDATE,
    YEARMONTHDATEHOURS,
    YEARMONTHDATEHOURSMINUTES,
    YEARMONTHDATEHOURSMINUTESSECONDS,
    MONTHDATE,
    HOURSMINUTES,
    HOURSMINUTESSECONDS,
    MINUTESSECONDS,
    SECONDSMILLISECONDS,
    QUARTER,
    YEARQUARTER,
    QUARTERMONTH,
    YEARQUARTERMONTH,
}
export declare const SINGLE_TIMEUNITS: TimeUnit[];
export declare function isSingleTimeUnit(timeUnit: TimeUnit): boolean;
export declare function convert(unit: TimeUnit, date: Date): Date;
export declare const MULTI_TIMEUNITS: TimeUnit[];
export declare function isMultiTimeUnit(timeUnit: TimeUnit): boolean;
export declare const TIMEUNITS: TimeUnit[];
export declare function containsTimeUnit(fullTimeUnit: TimeUnit, timeUnit: TimeUnit): boolean;
export declare function defaultScaleType(timeUnit: TimeUnit): ScaleType;
export declare function fieldExpr(fullTimeUnit: TimeUnit, field: string): string;
export declare function imputedDomain(timeUnit: TimeUnit, channel: Channel): number[];
export declare function smallestUnit(timeUnit: any): string;
export declare function template(timeUnit: TimeUnit, field: string, shortTimeLabels: boolean): string;
