import { ScaleType, NiceTime } from './scale';
export interface VgData {
    name: string;
    source?: string;
    values?: any;
    format?: any;
    url?: any;
    transform?: any;
}
export declare type VgParentRef = {
    parent: string;
};
export declare type VgFieldRef = string | VgParentRef | VgParentRef[];
export declare type VgDataRef = {
    data: string;
    field: VgFieldRef;
    sort: boolean | {
        field: VgFieldRef;
        op: string;
    };
};
export declare type VgValueRef = {
    value?: any;
    field?: string | {
        datum?: string;
        group?: string;
        parent?: string;
    };
    template?: string;
    scale?: string;
    mult?: number;
    offset?: number;
    band?: boolean;
};
export declare type UnionedDomain = {
    fields: VgDataRef[];
};
export declare type VgScale = {
    name: string;
    type: ScaleType;
    domain?: any[] | UnionedDomain | VgDataRef;
    domainMin?: any;
    domainMax?: any;
    range?: any[] | VgDataRef | string;
    rangeMin?: any;
    rangeMax?: any;
    bandSize?: number;
    clamp?: boolean;
    exponent?: number;
    nice?: boolean | NiceTime;
    padding?: number;
    points?: boolean;
    reverse?: boolean;
    round?: boolean;
    zero?: boolean;
};
export declare function isUnionedDomain(domain: any[] | UnionedDomain | VgDataRef): domain is UnionedDomain;
export declare function isDataRefDomain(domain: any[] | UnionedDomain | VgDataRef): domain is VgDataRef;
export declare type VgMarkGroup = any;
export declare type VgAxis = any;
export declare type VgLegend = any;
export declare type VgTransform = any;
export interface VgStackTransform {
    type: string;
    offset?: any;
    groupby: any;
    field: any;
    sortby: any;
    output: any;
}
