"use strict";
var chai_1 = require('chai');
var config_1 = require('../../src/compile/config');
var config_2 = require('../../src/config');
var util_1 = require('../util');
describe('Config', function () {
    describe('orient', function () {
        it('should return correct default', function () {
            var model = util_1.parseUnitModel({
                "mark": "bar",
                "encoding": {
                    "y": { "type": "quantitative", "field": "foo" },
                    "x": { "type": "quantitative", "field": "bar" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.VERTICAL);
            var model2 = util_1.parseUnitModel({
                "mark": "bar",
            });
            chai_1.assert.equal(config_1.orient(model2.mark(), model2.encoding()), config_2.Orient.VERTICAL);
        });
        it('should return correct orient for vertical bar', function () {
            var model = util_1.parseUnitModel({
                "mark": "bar",
                "encoding": {
                    "y": { "type": "quantitative", "field": "foo" },
                    "x": { "type": "ordinal", "field": "bar" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.VERTICAL);
        });
        it('should return correct orient for horizontal bar', function () {
            var model = util_1.parseUnitModel({
                "mark": "bar",
                "encoding": {
                    "x": { "type": "quantitative", "field": "foo" },
                    "y": { "type": "ordinal", "field": "bar" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.HORIZONTAL);
        });
        it('should return correct orient for vertical bar with raw temporal dimension', function () {
            var model = util_1.parseUnitModel({
                "mark": "bar",
                "encoding": {
                    "y": { "type": "quantitative", "field": "foo" },
                    "x": { "type": "temporal", "field": "bar" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.VERTICAL);
        });
        it('should return correct orient for horizontal bar with raw temporal dimension', function () {
            var model = util_1.parseUnitModel({
                "mark": "bar",
                "encoding": {
                    "x": { "type": "quantitative", "field": "foo" },
                    "y": { "type": "temporal", "field": "bar" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.HORIZONTAL);
        });
        it('should return correct orient for vertical tick', function () {
            var model = util_1.parseUnitModel({
                "mark": "tick",
                "encoding": {
                    "x": { "type": "quantitative", "field": "foo" },
                    "y": { "type": "ordinal", "field": "bar" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.VERTICAL);
        });
        it('should return correct orient for vertical tick with bin', function () {
            var model = util_1.parseUnitModel({
                "mark": "tick",
                "encoding": {
                    "x": { "type": "quantitative", "field": "foo" },
                    "y": { "type": "quantitative", "field": "bar", "bin": true }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.VERTICAL);
        });
        it('should return correct orient for vertical tick of continuous timeUnit dotplot', function () {
            var model = util_1.parseUnitModel({
                "mark": "tick",
                "encoding": {
                    "x": { "type": "temporal", "field": "foo", "timeUnit": "yearmonthdate" },
                    "y": { "type": "ordinal", "field": "bar" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.VERTICAL);
        });
        it('should return correct orient for horizontal tick', function () {
            var model = util_1.parseUnitModel({
                "mark": "tick",
                "encoding": {
                    "y": { "type": "quantitative", "field": "foo" },
                    "x": { "type": "ordinal", "field": "bar" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.HORIZONTAL);
        });
        it('should return correct orient for vertical rule', function () {
            var model = util_1.parseUnitModel({
                "mark": "rule",
                "encoding": {
                    "x": { "type": "quantitative", "field": "foo" },
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.VERTICAL);
        });
        it('should return correct orient for horizontal rule', function () {
            var model = util_1.parseUnitModel({
                "mark": "rule",
                "encoding": {
                    "y": { "type": "quantitative", "field": "foo" },
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding(), {}), config_2.Orient.HORIZONTAL);
        });
        it('should return correct orient for vertical rule with range', function () {
            var model = util_1.parseUnitModel({
                "mark": "rule",
                "encoding": {
                    "x": { "type": "ordinal", "field": "foo" },
                    "y": { "type": "quanitative", "field": "bar" },
                    "y2": { "type": "quanitative", "field": "baz" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding(), {}), config_2.Orient.VERTICAL);
        });
        it('should return correct orient for horizontal rule with range', function () {
            var model = util_1.parseUnitModel({
                "mark": "rule",
                "encoding": {
                    "y": { "type": "ordinal", "field": "foo" },
                    "x": { "type": "quanitative", "field": "bar" },
                    "x2": { "type": "quanitative", "field": "baz" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding(), {}), config_2.Orient.HORIZONTAL);
        });
        it('should return correct orient for horizontal rule with range and no ordinal', function () {
            var model = util_1.parseUnitModel({
                "mark": "rule",
                "encoding": {
                    "x": { "type": "quanitative", "field": "bar" },
                    "x2": { "type": "quanitative", "field": "baz" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.HORIZONTAL);
        });
        it('should return correct orient for vertical rule with range and no ordinal', function () {
            var model = util_1.parseUnitModel({
                "mark": "rule",
                "encoding": {
                    "y": { "type": "quanitative", "field": "bar" },
                    "y2": { "type": "quanitative", "field": "baz" }
                },
            });
            chai_1.assert.equal(config_1.orient(model.mark(), model.encoding()), config_2.Orient.VERTICAL);
        });
    });
});
//# sourceMappingURL=config.test.js.map