"use strict";
var chai_1 = require('chai');
var util_1 = require('../../util');
var formatparse_1 = require('../../../src/compile/data/formatparse');
describe('compile/data/formatparse', function () {
    describe('parse', function () {
        it('should return a correct parse for encoding mapping', function () {
            var model = util_1.parseUnitModel({
                "data": { "url": "a.json" },
                "mark": "point",
                "encoding": {
                    "x": { "field": "a", "type": "quantitative" },
                    "y": { "field": "b", "type": "temporal" },
                    "color": { "field": "c", "type": "ordinal" },
                    "shape": { "field": "d", "type": "nominal" }
                }
            });
            var parseComponent = formatparse_1.formatParse.parseUnit(model);
            chai_1.assert.deepEqual(parseComponent, {
                a: 'number',
                b: 'date'
            });
        });
    });
    it('should return a correct parse for filtered fields', function () {
        var model = util_1.parseUnitModel({
            "data": { "url": "a.json" },
            "mark": "point",
            "transform": {
                "filter": [
                    { "field": "a", "equal": { year: 2000 } },
                    { "field": "b", "oneOf": ["a", "b"] },
                    { "field": "c", "range": [{ year: 2000 }, { year: 2001 }] },
                    { "field": "d", "range": [1, 2] }
                ]
            }
        });
        var parseComponent = formatparse_1.formatParse.parseUnit(model);
        chai_1.assert.deepEqual(parseComponent, {
            a: 'date',
            b: 'string',
            c: 'date',
            d: 'number'
        });
    });
    it('should return a correct customized parse.', function () {
        var model = util_1.parseUnitModel({
            "data": { "url": "a.json", "format": { "parse": { "c": "number", "d": "date" } } },
            "mark": "point",
            "encoding": {
                "x": { "field": "a", "type": "quantitative" },
                "y": { "field": "b", "type": "temporal" },
                "color": { "field": "c", "type": "ordinal" },
                "shape": { "field": "c", "type": "nominal" }
            }
        });
        var parseComponent = formatparse_1.formatParse.parseUnit(model);
        chai_1.assert.deepEqual(parseComponent, {
            a: 'number',
            b: 'date',
            c: 'number',
            d: 'date'
        });
    });
});
//# sourceMappingURL=formatparse.test.js.map