"use strict";
var chai_1 = require('chai');
var util_1 = require('../../util');
var timeunit_1 = require('../../../src/compile/data/timeunit');
describe('compile/data/timeunitdomain', function () {
    describe('parseUnit', function () {
        it('should return a dictionary of formula transform', function () {
            var model = util_1.parseUnitModel({
                "data": { "value": [] },
                "mark": "point",
                "encoding": {
                    "x": { field: 'a', type: 'temporal', timeUnit: 'month' }
                }
            });
            var timeUnitComponent = timeunit_1.timeUnit.parseUnit(model);
            chai_1.assert.deepEqual(timeUnitComponent, {
                month_a: {
                    type: 'formula',
                    field: 'month_a',
                    expr: 'datetime(0, month(datum["a"]), 1, 0, 0, 0, 0)'
                }
            });
        });
    });
    describe('parseFacet', function () {
    });
    describe('parseLayer', function () {
    });
    describe('assemble', function () {
    });
});
//# sourceMappingURL=timeunit.test.js.map