"use strict";
var chai_1 = require('chai');
var timeunitdomain_1 = require('../../../src/compile/data/timeunitdomain');
var datatestutil_1 = require('./datatestutil');
describe('compile/data/timeunitdomain', function () {
    describe('assemble', function () {
        var component = datatestutil_1.mockDataComponent();
        component.timeUnitDomain = {
            month: true
        };
        it('should return correct data sources', function () {
            chai_1.assert.deepEqual(timeunitdomain_1.timeUnitDomain.assemble(component), [
                {
                    name: 'month',
                    values: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11],
                    transform: [{
                            type: 'formula',
                            field: 'date',
                            expr: 'datetime(0, datum["data"], 1, 0, 0, 0, 0)'
                        }]
                }
            ]);
        });
    });
});
//# sourceMappingURL=timeunitdomain.test.js.map