"use strict";
var chai_1 = require('chai');
var util_1 = require('../../util');
var mark_1 = require('../../../src/compile/mark/mark');
describe('Mark', function () {
    describe('Non-path based Mark', function () {
        it('Aggregated Bar with a color with binned x should stack data correctly', function () {
            var model = util_1.parseUnitModel({
                "mark": "bar",
                "encoding": {
                    "x": { "type": "quantitative", "field": "Cost__Other", "aggregate": "sum" },
                    "y": { "bin": true, "type": "quantitative", "field": "Cost__Total_$" },
                    "color": { "type": "ordinal", "field": "Effect__Amount_of_damage" }
                }
            });
            var markGroup = mark_1.parseMark(model);
            var stackTransform = markGroup[0].from.transform[0];
            chai_1.assert.equal(stackTransform.type, 'stack');
            chai_1.assert.deepEqual(stackTransform.groupby, ['bin_Cost__Total_$_mid']);
            chai_1.assert.deepEqual(stackTransform.field, 'sum_Cost__Other');
            chai_1.assert.deepEqual(stackTransform.sortby, ['-Effect__Amount_of_damage']);
        });
        it('Aggregated with a color with binned x should stack data correctly', function () {
            var model = util_1.parseUnitModel({
                "mark": "bar",
                "encoding": {
                    "y": { "type": "quantitative", "field": "Cost__Other", "aggregate": "sum" },
                    "x": { "bin": true, "type": "quantitative", "field": "Cost__Total_$" },
                    "color": { "type": "ordinal", "field": "Effect__Amount_of_damage" }
                }
            });
            var markGroup = mark_1.parseMark(model);
            var stackTransform = markGroup[0].from.transform[0];
            chai_1.assert.equal(stackTransform.type, 'stack');
            chai_1.assert.deepEqual(stackTransform.groupby, ['bin_Cost__Total_$_mid']);
            chai_1.assert.deepEqual(stackTransform.field, 'sum_Cost__Other');
            chai_1.assert.deepEqual(stackTransform.sortby, ['-Effect__Amount_of_damage']);
        });
    });
});
//# sourceMappingURL=mark.test.js.map