"use strict";
var chai_1 = require('chai');
var util_1 = require('../util');
var channel_1 = require('../../src/channel');
var timeunit_1 = require('../../src/timeunit');
describe('TimeUnit', function () {
    describe('format()', function () {
        it('should get the right time template when shortTimeLabels is specified true', function () {
            var model = util_1.parseUnitModel({
                mark: "point",
                encoding: {
                    x: { timeUnit: 'month', field: 'a', type: "temporal", axis: { shortTimeLabels: true } }
                }
            });
            chai_1.assert.equal(timeunit_1.template(model.encoding().x.timeUnit, 'datum["data"]', model.axis(channel_1.X).shortTimeLabels), '{{datum["data"] | time:\'%b\'}}');
        });
        it('should get the right time template when shortTimeLabels is unspecified', function () {
            var model = util_1.parseUnitModel({
                mark: "point",
                encoding: {
                    x: { timeUnit: 'month', field: 'a', type: "temporal" }
                }
            });
            chai_1.assert.equal(timeunit_1.template(model.encoding().x.timeUnit, 'datum["data"]', model.axis(channel_1.X).shortTimeLabels), '{{datum["data"] | time:\'%b\'}}');
        });
        it('should get the right time template when shortTimeLabels is false', function () {
            var model = util_1.parseUnitModel({
                mark: "point",
                encoding: {
                    x: { timeUnit: 'month', field: 'a', type: "temporal", axis: { shortTimeLabels: false } }
                }
            });
            chai_1.assert.equal(timeunit_1.template(model.encoding().x.timeUnit, 'datum["data"]', model.axis(channel_1.X).shortTimeLabels), '{{datum["data"] | time:\'%B\'}}');
        });
        it('should get the right time template when timeUnit is week and shortTimeLabels is true', function () {
            var model = util_1.parseUnitModel({
                mark: "point",
                encoding: {
                    x: { timeUnit: 'week', field: 'a', type: "temporal", axis: { shortTimeLabels: true } }
                }
            });
            chai_1.assert.equal(timeunit_1.template(model.encoding().x.timeUnit, 'datum["data"]', model.axis(channel_1.X).shortTimeLabels), undefined);
        });
    });
});
//# sourceMappingURL=timeunit.test.js.map