"use strict";
var chai_1 = require('chai');
var unit_1 = require('../../src/compile/unit');
var util_1 = require('../util');
describe('Unit', function () {
    it('should say it is unit', function () {
        var model = new unit_1.UnitModel({}, null, null);
        chai_1.assert(model.isUnit());
        chai_1.assert(!model.isFacet());
        chai_1.assert(!model.isLayer());
    });
    describe('initSize', function () {
        it('should have width, height = provided top-level width, height', function () {
            var model = util_1.parseUnitModel({
                width: 123,
                height: 456,
                mark: 'text',
                encoding: {},
                config: { scale: { textBandWidth: 91 } }
            });
            chai_1.assert.equal(model.width, 123);
            chai_1.assert.equal(model.height, 456);
        });
        it('should have width = default textBandWidth for text mark without x', function () {
            var model = util_1.parseUnitModel({
                mark: 'text',
                encoding: {},
                config: { scale: { textBandWidth: 91 } }
            });
            chai_1.assert.equal(model.width, 91);
        });
        it('should have width/height = config.scalebandSize for non-text mark without x,y', function () {
            var model = util_1.parseUnitModel({
                mark: 'point',
                encoding: {},
                config: { scale: { bandSize: 23 } }
            });
            chai_1.assert.equal(model.width, 23);
            chai_1.assert.equal(model.height, 23);
        });
        it('should have width/height = config.cell.width/height for non-ordinal x,y', function () {
            var model = util_1.parseUnitModel({
                mark: 'point',
                encoding: {
                    x: { field: 'a', type: 'quantitative' },
                    y: { field: 'b', type: 'quantitative' }
                },
                config: { cell: { width: 123, height: 456 } }
            });
            chai_1.assert.equal(model.width, 123);
            chai_1.assert.equal(model.height, 456);
        });
        it('should have width/height = config.cell.width/height for non-ordinal x,y', function () {
            var model = util_1.parseUnitModel({
                mark: 'point',
                encoding: {
                    x: { field: 'a', type: 'ordinal', scale: { bandSize: 'fit' } },
                    y: { field: 'b', type: 'ordinal', scale: { bandSize: 'fit' } }
                },
                config: { cell: { width: 123, height: 456 } }
            });
            chai_1.assert.equal(model.width, 123);
            chai_1.assert.equal(model.height, 456);
        });
        it('should have width/height = undefined for non-ordinal x,y', function () {
            var model = util_1.parseUnitModel({
                mark: 'point',
                encoding: {
                    x: { field: 'a', type: 'ordinal' },
                    y: { field: 'b', type: 'ordinal' }
                },
                config: { cell: { width: 123, height: 456 } }
            });
            chai_1.assert.equal(model.width, undefined);
            chai_1.assert.equal(model.height, undefined);
        });
    });
});
//# sourceMappingURL=unit.test.js.map