"use strict";
var chai_1 = require('chai');
var aggregate_1 = require('../src/aggregate');
var fielddef_1 = require('../src/fielddef');
var timeunit_1 = require('../src/timeunit');
var type_1 = require('../src/type');
describe('fieldDef', function () {
    describe('title()', function () {
        it('should return title if the fieldDef has title', function () {
            var fieldDef = { field: '2', type: type_1.QUANTITATIVE, title: 'baz' };
            chai_1.assert.equal(fielddef_1.title(fieldDef, {}), 'baz');
        });
        it('should return correct title for aggregate', function () {
            var fieldDef = { field: 'f', type: type_1.QUANTITATIVE, aggregate: aggregate_1.AggregateOp.MEAN };
            chai_1.assert.equal(fielddef_1.title(fieldDef, {}), 'MEAN(f)');
        });
        it('should return correct title for count', function () {
            var fieldDef = { field: '*', type: type_1.QUANTITATIVE, aggregate: aggregate_1.AggregateOp.COUNT };
            chai_1.assert.equal(fielddef_1.title(fieldDef, { countTitle: 'baz!' }), 'baz!');
        });
        it('should return correct title for bin', function () {
            var fieldDef = { field: 'f', type: type_1.QUANTITATIVE, bin: true };
            chai_1.assert.equal(fielddef_1.title(fieldDef, {}), 'BIN(f)');
        });
        it('should return correct title for timeUnit', function () {
            var fieldDef = { field: 'f', type: type_1.TEMPORAL, timeUnit: timeunit_1.TimeUnit.MONTH };
            chai_1.assert.equal(fielddef_1.title(fieldDef, {}), 'MONTH(f)');
        });
        it('should return correct title for raw field', function () {
            var fieldDef = { field: 'f', type: type_1.TEMPORAL };
            chai_1.assert.equal(fielddef_1.title(fieldDef, {}), 'f');
        });
    });
});
//# sourceMappingURL=fielddef.test.js.map