"use strict";
var common_1 = require('../src/compile/common');
var unit_1 = require('../src/compile/unit');
var spec_1 = require('../src/spec');
var util_1 = require('../src/util');
function parseModel(inputSpec) {
    var spec = spec_1.normalize(inputSpec);
    return common_1.buildModel(spec, null, '');
}
exports.parseModel = parseModel;
function parseUnitModel(spec) {
    return new unit_1.UnitModel(spec, null, '');
}
exports.parseUnitModel = parseUnitModel;
exports.zSchema = require('z-schema');
exports.zSchema.registerFormat('color', function (str) {
    return util_1.contains(['purple'], str) || /^#([0-9a-f]{3}){1,2}$/i.test(str);
});
exports.zSchema.registerFormat('font', function (str) {
    return false;
});
//# sourceMappingURL=util.js.map