"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var util_1 = require("./util");
/**
 * A dictionary listing whether a certain axis property is applicable for only main axes or only grid axes.
 * (Properties not listed are applicable for both)
 */
exports.AXIS_PROPERTY_TYPE = {
    grid: 'grid',
    labelOverlap: 'main',
    offset: 'main',
    title: 'main'
};
var COMMON_AXIS_PROPERTIES_INDEX = {
    orient: 1,
    domain: 1,
    format: 1,
    grid: 1,
    labelBound: 1,
    labelFlush: 1,
    labelPadding: 1,
    labels: 1,
    labelOverlap: 1,
    maxExtent: 1,
    minExtent: 1,
    offset: 1,
    position: 1,
    tickCount: 1,
    ticks: 1,
    tickSize: 1,
    title: 1,
    titlePadding: 1,
    values: 1,
    zindex: 1,
};
var AXIS_PROPERTIES_INDEX = tslib_1.__assign({}, COMMON_AXIS_PROPERTIES_INDEX, { encoding: 1, labelAngle: 1, titleMaxLength: 1 });
var VG_AXIS_PROPERTIES_INDEX = tslib_1.__assign({ scale: 1 }, COMMON_AXIS_PROPERTIES_INDEX, { gridScale: 1, encode: 1 });
function isAxisProperty(prop) {
    return !!AXIS_PROPERTIES_INDEX[prop];
}
exports.isAxisProperty = isAxisProperty;
exports.VG_AXIS_PROPERTIES = util_1.flagKeys(VG_AXIS_PROPERTIES_INDEX);
// Export for dependent projects
exports.AXIS_PROPERTIES = util_1.flagKeys(AXIS_PROPERTIES_INDEX);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXhpcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9heGlzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLCtCQUFzQztBQThEdEM7OztHQUdHO0FBQ1UsUUFBQSxrQkFBa0IsR0FHM0I7SUFDRixJQUFJLEVBQUUsTUFBTTtJQUNaLFlBQVksRUFBRSxNQUFNO0lBQ3BCLE1BQU0sRUFBRSxNQUFNO0lBQ2QsS0FBSyxFQUFFLE1BQU07Q0FDZCxDQUFDO0FBa0NGLElBQU0sNEJBQTRCLEdBQWdDO0lBQ2hFLE1BQU0sRUFBRSxDQUFDO0lBRVQsTUFBTSxFQUFFLENBQUM7SUFDVCxNQUFNLEVBQUUsQ0FBQztJQUNULElBQUksRUFBRSxDQUFDO0lBQ1AsVUFBVSxFQUFFLENBQUM7SUFDYixVQUFVLEVBQUUsQ0FBQztJQUNiLFlBQVksRUFBRSxDQUFDO0lBQ2YsTUFBTSxFQUFFLENBQUM7SUFDVCxZQUFZLEVBQUUsQ0FBQztJQUNmLFNBQVMsRUFBRSxDQUFDO0lBQ1osU0FBUyxFQUFFLENBQUM7SUFDWixNQUFNLEVBQUUsQ0FBQztJQUNULFFBQVEsRUFBRSxDQUFDO0lBQ1gsU0FBUyxFQUFFLENBQUM7SUFDWixLQUFLLEVBQUUsQ0FBQztJQUNSLFFBQVEsRUFBRSxDQUFDO0lBQ1gsS0FBSyxFQUFFLENBQUM7SUFDUixZQUFZLEVBQUUsQ0FBQztJQUNmLE1BQU0sRUFBRSxDQUFDO0lBQ1QsTUFBTSxFQUFFLENBQUM7Q0FDVixDQUFDO0FBRUYsSUFBTSxxQkFBcUIsd0JBQ3RCLDRCQUE0QixJQUMvQixRQUFRLEVBQUUsQ0FBQyxFQUNYLFVBQVUsRUFBRSxDQUFDLEVBQ2IsY0FBYyxFQUFFLENBQUMsR0FDbEIsQ0FBQztBQUVGLElBQU0sd0JBQXdCLHNCQUM1QixLQUFLLEVBQUUsQ0FBQyxJQUNMLDRCQUE0QixJQUMvQixTQUFTLEVBQUUsQ0FBQyxFQUNaLE1BQU0sRUFBRSxDQUFDLEdBQ1YsQ0FBQztBQUVGLHdCQUErQixJQUFZO0lBQ3pDLE1BQU0sQ0FBQyxDQUFDLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDdkMsQ0FBQztBQUZELHdDQUVDO0FBRVksUUFBQSxrQkFBa0IsR0FBRyxlQUFRLENBQUMsd0JBQXdCLENBQUMsQ0FBQztBQUVyRSxnQ0FBZ0M7QUFDbkIsUUFBQSxlQUFlLEdBQUcsZUFBUSxDQUFDLHFCQUFxQixDQUFDLENBQUMifQ==