import { AggregateOp } from './aggregate';
import { BinParams } from './bin';
import { Data } from './data';
import { Filter } from './filter';
import { LogicalOperand } from './logical';
import { TimeUnit } from './timeunit';
export interface FilterTransform {
    /**
     * The `filter` property must be either (1) a filter object for [equal-filters](filter.html#equalfilter),
     * [range-filters](filter.html#rangefilter), [one-of filters](filter.html#oneoffilter), or [selection filters](filter.html#selectionfilter);
     * (2) a [Vega Expression](filter.html#expression) string,
     * where `datum` can be used to refer to the current data object; or (3) an array of filters (either objects or expression strings) that must all be true for a datum to pass the filter and be included.
     */
    filter: LogicalOperand<Filter>;
}
export declare function isFilter(t: Transform): t is FilterTransform;
export interface CalculateTransform {
    /**
     * A string containing a Vega Expression. Use the variable `datum` to refer to the current data object.
     */
    calculate: string;
    /**
     * The field for storing the computed formula value.
     */
    as: string;
}
export interface BinTransform {
    /**
     * An object indicating bin properties, or simply `true` for using default bin parameters.
     */
    bin: boolean | BinParams;
    /**
     * The data field to bin.
     */
    field: string;
    /**
     * The output fields at which to write the start and end bin values.
     */
    as: string;
}
export interface TimeUnitTransform {
    /**
     * The timeUnit.
     */
    timeUnit: TimeUnit;
    /**
     * The data field to apply time unit.
     */
    field: string;
    /**
     * The output field to write the timeUnit value.
     */
    as: string;
}
export interface AggregateTransform {
    /**
     * Array of objects that define fields to aggregate.
     */
    aggregate: AggregatedFieldDef[];
    /**
     * The data fields to group by. If not specified, a single group containing all data objects will be used.
     */
    groupby?: string[];
}
export interface AggregatedFieldDef {
    /**
     * The aggregation operations to apply to the fields, such as sum, average or count.
     * See the [full list of supported aggregation operations](https://vega.github.io/vega-lite/docs/aggregate.html#supported-aggregation-operations)
     * for more information.
     */
    op: AggregateOp;
    /**
     * The data field for which to compute aggregate function.
     */
    field: string;
    /**
     * The output field names to use for each aggregated field.
     */
    as: string;
}
export interface LookupData {
    /**
     * Secondary data source to lookup in.
     */
    data: Data;
    /**
     * Key in data to lookup.
     */
    key: string;
    /**
     * Fields in foreign data to lookup.
     * If not specificied, the entire object is queried.
     */
    fields?: string[];
}
export interface LookupTransform {
    /**
     * Key in primary data source.
     */
    lookup: string;
    /**
     * Secondary data reference.
     */
    from: LookupData;
    /**
     * The field or fields for storing the computed formula value.
     * If `from.fields` is specified, the transform will use the same names for `as`.
     * If `from.fields` is not specified, `as` has to be a string and we put the whole object into the data under the specified name.
     */
    as?: string | string[];
    /**
     * The default value to use if lookup fails.
     *
     * __Default value:__ `null`
     */
    default?: string;
}
export declare function isLookup(t: Transform): t is LookupTransform;
export declare function isCalculate(t: Transform): t is CalculateTransform;
export declare function isBin(t: Transform): t is BinTransform;
export declare function isTimeUnit(t: Transform): t is TimeUnitTransform;
export declare function isAggregate(t: Transform): t is AggregateTransform;
export declare type Transform = FilterTransform | CalculateTransform | LookupTransform | BinTransform | TimeUnitTransform | AggregateTransform;
export declare function normalizeTransform(transform: Transform[]): (TimeUnitTransform | AggregateTransform | CalculateTransform | LookupTransform | BinTransform | {
    filter: LogicalOperand<Filter>;
})[];
