import { Channel } from '../../channel';
import { Config } from '../../config';
import { ScaleFieldDef, TypedFieldDef } from '../../fielddef';
import { BarConfig, Mark, MarkDef } from '../../mark';
import { Domain, NiceTime, Scale, ScaleConfig, ScaleType } from '../../scale';
import { Sort } from '../../sort';
import { Type } from '../../type';
import { Model } from '../model';
import { ScaleComponentProps } from './component';
export declare function parseScaleProperty(model: Model, property: keyof (Scale | ScaleComponentProps)): void;
export declare function getDefaultValue(property: keyof Scale, channel: Channel, fieldDef: ScaleFieldDef<string, Type>, scaleType: ScaleType, scalePadding: number, scalePaddingInner: number, specifiedDomain: Scale['domain'], markDef: MarkDef, config: Config): any;
export declare function parseScaleRange(model: Model): void;
export declare function parseNonUnitScaleProperty(model: Model, property: keyof (Scale | ScaleComponentProps)): void;
export declare function interpolate(channel: Channel, scaleType: ScaleType): string;
export declare function nice(scaleType: ScaleType, channel: Channel, fieldDef: TypedFieldDef<string>): boolean | NiceTime;
export declare function padding(channel: Channel, scaleType: ScaleType, scaleConfig: ScaleConfig, fieldDef: TypedFieldDef<string>, markDef: MarkDef, barConfig: BarConfig): number;
export declare function paddingInner(paddingValue: number, channel: Channel, mark: Mark, scaleConfig: ScaleConfig): number;
export declare function paddingOuter(paddingValue: number, channel: Channel, scaleType: ScaleType, mark: Mark, paddingInnerValue: number, scaleConfig: ScaleConfig): number;
export declare function reverse(scaleType: ScaleType, sort: Sort<string>): boolean;
export declare function zero(channel: Channel, fieldDef: TypedFieldDef<string>, specifiedScale: Domain, markDef: MarkDef, scaleType: ScaleType): boolean;
