const markColor = '#30a2da';
const axisColor = '#cbcbcb';
const backgroundColor = '#f0f0f0';
const blackTitle = '#1c1c1c';
const fiveThirtyEightTheme = {
    arc: { fill: markColor },
    area: { fill: markColor },
    axisBand: {
        grid: false,
    },
    axisBottom: {
        domain: false,
        domainColor: blackTitle,
        domainWidth: 3,
        grid: true,
        gridColor: axisColor,
        gridWidth: 1,
        labelColor: axisColor,
        labelFontSize: 10,
        labelPadding: 4,
        tickColor: axisColor,
        tickSize: 10,
        titleFontSize: 14,
        titlePadding: 10,
    },
    axisLeft: {
        domainColor: axisColor,
        domainWidth: 1,
        grid: true,
        gridColor: axisColor,
        gridWidth: 1,
        labelColor: axisColor,
        labelFontSize: 10,
        labelPadding: 4,
        tickColor: axisColor,
        tickSize: 10,
        ticks: true,
        titleFontSize: 14,
        titlePadding: 10,
    },
    axisRight: {
        domainColor: blackTitle,
        domainWidth: 1,
        grid: true,
        gridColor: axisColor,
        gridWidth: 1,
        labelColor: axisColor,
        labelFontSize: 10,
        labelPadding: 4,
        tickColor: axisColor,
        tickSize: 10,
        ticks: true,
        titleFontSize: 14,
        titlePadding: 10,
    },
    axisTop: {
        domain: false,
        domainColor: blackTitle,
        domainWidth: 3,
        grid: true,
        gridColor: axisColor,
        gridWidth: 1,
        labelColor: axisColor,
        labelFontSize: 10,
        labelPadding: 4,
        tickColor: axisColor,
        tickSize: 10,
        titleFontSize: 14,
        titlePadding: 10,
    },
    background: backgroundColor,
    group: {
        fill: backgroundColor,
    },
    legend: {
        labelColor: blackTitle,
        labelFontSize: 11,
        padding: 1,
        symbolSize: 30,
        symbolType: 'square',
        titleColor: blackTitle,
        titleFontSize: 14,
        titlePadding: 10,
    },
    line: {
        stroke: markColor,
        strokeWidth: 2,
    },
    path: { stroke: markColor, strokeWidth: 0.5 },
    rect: { fill: markColor },
    range: {
        category: [
            '#30a2da',
            '#fc4f30',
            '#e5ae38',
            '#6d904f',
            '#8b8b8b',
            '#b96db8',
            '#ff9e27',
            '#56cc60',
            '#52d2ca',
            '#52689e',
            '#545454',
            '#9fe4f8',
        ],
        diverging: [
            '#cc0020',
            '#e77866',
            '#f6e7e1',
            '#d6e8ed',
            '#91bfd9',
            '#1d78b5',
        ],
        heatmap: ['#d6e8ed', '#cee0e5', '#91bfd9', '#549cc6', '#1d78b5'],
    },
    symbol: {
        filled: true,
        opacity: 0.5,
        shape: 'circle',
        size: 40,
    },
    shape: { stroke: markColor },
    style: {
        bar: {
            binSpacing: 2,
            fill: markColor,
            stroke: null,
        },
    },
    title: {
        anchor: 'start',
        fontSize: 24,
        fontWeight: 600,
        offset: 20,
    },
};
export default fiveThirtyEightTheme;
//# sourceMappingURL=data:application/json;base64,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