# verb-collections [![NPM version](https://img.shields.io/npm/v/verb-collections.svg?style=flat)](https://www.npmjs.com/package/verb-collections) [![NPM monthly downloads](https://img.shields.io/npm/dm/verb-collections.svg?style=flat)](https://npmjs.org/package/verb-collections)  [![NPM total downloads](https://img.shields.io/npm/dt/verb-collections.svg?style=flat)](https://npmjs.org/package/verb-collections) [![Linux Build Status](https://img.shields.io/travis/verbose/verb-collections.svg?style=flat&label=Travis)](https://travis-ci.org/verbose/verb-collections)

> Verb plugin that adds includes, layouts, badges and docs template collections. Can be used with verb, assemble or generate, in a `*file.js`, or a globally installed generator.

<details>
<summary><strong>Table of Contents</strong></summary>
- [Install](#install)
- [Usage](#usage)
- [Collections](#collections)
- [About](#about)
</details>

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save verb-collections
```

## Usage

This plugin can be used in a `verbfile.js` or a globally installed verb generator.

```js
var collections = require('verb-collections');

// register the plugin
app.use(collections());
```

## Collections

Adds the following view collections to your verb app:

**Renderable**

Templates in these collections can be (automatically) rendered:

* `files`

**Layouts**

Templates in these collections can be used as layouts:

* `layouts`

**Partials**

Templates in these collections can be used as partials:

* `includes`
* `badges`
* `docs`

## About

### Related projects

* [assemble](https://www.npmjs.com/package/assemble): Get the rocks out of your socks! Assemble makes you fast at creating web projects… [more](https://github.com/assemble/assemble) | [homepage](https://github.com/assemble/assemble "Get the rocks out of your socks! Assemble makes you fast at creating web projects. Assemble is used by thousands of projects for rapid prototyping, creating themes, scaffolds, boilerplates, e-books, UI components, API documentation, blogs, building websit")
* [generate](https://www.npmjs.com/package/generate): Command line tool and developer framework for scaffolding out new GitHub projects. Generate offers the… [more](https://github.com/generate/generate) | [homepage](https://github.com/generate/generate "Command line tool and developer framework for scaffolding out new GitHub projects. Generate offers the robustness and configurability of Yeoman, the expressiveness and simplicity of Slush, and more powerful flow control and composability than either.")
* [verb-readme-generator](https://www.npmjs.com/package/verb-readme-generator): Generate your project's readme with verb. Requires verb v0.9.0 or higher. | [homepage](https://github.com/verbose/verb-readme-generator "Generate your project's readme with verb. Requires verb v0.9.0 or higher.")
* [verb](https://www.npmjs.com/package/verb): Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used… [more](https://github.com/verbose/verb) | [homepage](https://github.com/verbose/verb "Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used on hundreds of projects of all sizes to generate everything from API docs to readmes.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
MIT

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.1, on January 27, 2017._