# verb-defaults [![NPM version](https://img.shields.io/npm/v/verb-defaults.svg?style=flat)](https://www.npmjs.com/package/verb-defaults) [![NPM downloads](https://img.shields.io/npm/dm/verb-defaults.svg?style=flat)](https://npmjs.org/package/verb-defaults) [![Build Status](https://img.shields.io/travis/verbose/verb-defaults.svg?style=flat)](https://travis-ci.org/verbose/verb-defaults)

Plugin for setting basic defaults in verb projects.

You might also be interested in [generate](https://github.com/generate/generate).

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save verb-defaults
```

## What does this do?

**Default engine**

Adds a default [template engine](https://github.com/jonschlinkert/engine-base) for rendering templates. This engine is registered with the name `*`.

In a vinyl stream, to force rendering to use this engine, do:

```js
app.src('*.md')
  .pipe(app.renderFile('*')) //<= engine name
```

**Common middleware**

Registers the [common-middleware](https://github.com/jonschlinkert/common-middleware) plugin, which runs `preRender`, `posRender` and `preWrite` middleware that handle escaping and unescaping of templates/delimiters that should not be evaluated at render time (e.g. when writing documentation it's common to have examples of templates that should not be rendered).

## Usage

This plugin can be used in a `verbfile.js` or a globally installed verb generator.

```js
var defaults = require('verb-defaults');

// register the plugin
app.use(defaults());
```

## About

### Related projects

* [assemble](https://www.npmjs.com/package/assemble): Get the rocks out of your socks! Assemble makes you fast at creating web projects… [more](https://github.com/assemble/assemble) | [homepage](https://github.com/assemble/assemble "Get the rocks out of your socks! Assemble makes you fast at creating web projects. Assemble is used by thousands of projects for rapid prototyping, creating themes, scaffolds, boilerplates, e-books, UI components, API documentation, blogs, building websit")
* [generate](https://www.npmjs.com/package/generate): Command line tool and developer framework for scaffolding out new GitHub projects. Generate offers the… [more](https://github.com/generate/generate) | [homepage](https://github.com/generate/generate "Command line tool and developer framework for scaffolding out new GitHub projects. Generate offers the robustness and configurability of Yeoman, the expressiveness and simplicity of Slush, and more powerful flow control and composability than either.")
* [verb-collections](https://www.npmjs.com/package/verb-collections): Verb plugin that adds includes, layouts, badges and docs template collections. Can be used with… [more](https://github.com/verbose/verb-collections) | [homepage](https://github.com/verbose/verb-collections "Verb plugin that adds includes, layouts, badges and docs template collections. Can be used with verb, assemble or generate, in a `*file.js`, or a globally installed generator.")
* [verb-repo-data](https://www.npmjs.com/package/verb-repo-data): Verb plugin that adds repository and package.json data to the context for rendering templates. | [homepage](https://github.com/verbose/verb-repo-data "Verb plugin that adds repository and package.json data to the context for rendering templates.")
* [verb](https://www.npmjs.com/package/verb): Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used… [more](https://github.com/verbose/verb) | [homepage](https://github.com/verbose/verb "Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used on hundreds of projects of all sizes to generate everything from API docs to readmes.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/verbose/verb-defaults/blob/master/LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.1.28, on August 06, 2016._