# verb-generate-readme [![NPM version](https://img.shields.io/npm/v/verb-generate-readme.svg?style=flat)](https://www.npmjs.com/package/verb-generate-readme) [![NPM monthly downloads](https://img.shields.io/npm/dm/verb-generate-readme.svg?style=flat)](https://npmjs.org/package/verb-generate-readme)  [![NPM total downloads](https://img.shields.io/npm/dt/verb-generate-readme.svg?style=flat)](https://npmjs.org/package/verb-generate-readme) [![Linux Build Status](https://img.shields.io/travis/verbose/verb-generate-readme.svg?style=flat&label=Travis)](https://travis-ci.org/verbose/verb-generate-readme)

> Generate your project's readme with verb. Requires verb v0.9.0 or higher.

You might also be interested in [generate](https://github.com/generate/generate).

<details>
<summary><strong>Table of Contents</strong></summary>
- [Heads up!](#heads-up)
- [What is verb?](#what-is-verb)
- [Getting started](#getting-started)
- [Command line](#command-line)
  * [Tasks](#tasks)
    + [default](#default)
    + [readme](#readme)
  * [Options](#options)
    + [run](#run)
    + [silent](#silent)
    + [readme](#readme-1)
    + [times](#times)
    + [toc](#toc)
    + [no-reflinks-cache](#no-reflinks-cache)
    + [layout](#layout)
- [About](#about)
  * [Related projects](#related-projects)
  * [Contributing](#contributing)
  * [Running tests](#running-tests)
  * [Author](#author)
  * [License](#license)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_
</details>

Encourages [readme-driven development](http://tom.preston-werner.com/2010/08/23/readme-driven-development.html)!

## Heads up!

This generator requires **verb 0.9.0** and up, which is currently on the `dev` branch. If you're willing to put up with occassional bugs and would like to provide helpful feedback, install verb with the following command:

```sh
$ npm install --global "verbose/verb#dev"
```

## What is verb?

Verb is a powerful, _open-source developer framework and documentation build-system for GitHub projects_.

**API**

Built on node.js, Verb's API is crafted around the purpose of simplifying how documentation is specified, authored, rendered and generated. The core verb application offers methods for rendering templates, working with the file system, registering and running tasks, and verb can be extended to do anything else using plugins.

**CLI**

Once [installed globally](#cli), verb's CLI is run using the `verb` command.

**verbfile.js**

Each time the `verb` command is run, verb's CLI looks for a `verbfile.js` in the user's current working directory and if found will try to load the file and execute any [tasks](#tasks) specified by the user.

**.verb.md**

If `verb-generate-readme` is installed (locally or globally), and a `verbfile.js` is not found, verb's CLI looks for a `.verb.md` readme template in the user's current working directory. If found, verb will render the file to create a `README.md` using data from the user's environment, such as `package.json` and `.git` config (for username, if necessary).

Visit the [verb](https://github.com/verbose/verb) project to learn more.

## Getting started

**Installing the CLI**

To run the `readme` generator from the command line, you'll need to first install [verb](https://github.com/verbose/verb) globally first. You can that now with the following command:

```sh
$ npm install --global verb
```

This adds the `verb` command to your system path, allowing it to be run from any directory. Visit the [verb](https://github.com/verbose/verb) project and documentation to learn more.

**Run the `readme` generator from the command line**

Once both [verb](https://github.com/verbose/verb) and `verb-generate-readme` are installed globally, you can run the generator with the following command:

Run the `readme` generator from the command line:

```sh
$ verb readme
```

## Command line

### Tasks

The following tasks are defined on `verb-generate-readme`.

#### [default](generator.js#L61)

Alias for the [readme](#readme) task, generates a README.md to the user's working directory.

**Example**

```sh
$ verb readme
```

#### [readme](generator.js#L73)

Generate `README.md` and fix missing [reflinks](#reflinks).

**Example**

```sh
$ verb readme
```

### Options

Configuration options can be:

* passed on the command line
* defined on the `verb` object in package.json, or
* set directly [using the API](https://github.com/verbose/verb/blob/master/docs/api/options.md)

Most of the following examples show how to set configuration values on the `verb` object _via the command line_, but you can also set these manually.

#### run

To automatically run the `readme` generator with the `verb` command (without specifying `readme` on the command line), add the following to package.json:

```js
// --package.json--
{
  // add a verb object with an array of tasks to run
  "verb": {
    "tasks": ["readme"]
  }
}
```

#### silent

Mute progress for tasks and generators from being displayed in the terminal.

**CLI**

```sh
$ verb --silent
```

**verb config**

In your project's package.json:

```json
{
  "verb": {
    "silent": true
  }
}
```

**API**

In your `verbfile.js` or application code:

```js
app.enable('silent');

// equivalent to
app.option('silent', true);
```

**Examples**

![running tasks and generators](https://cloud.githubusercontent.com/assets/383994/14978816/7449a5c6-10ec-11e6-9bac-07e482e915f2.gif)

With `--silent`

![running tasks and generators with the silent flag](https://cloud.githubusercontent.com/assets/383994/14979276/573b5f8a-10ef-11e6-8ce4-6c5bc4563f6b.png)

#### readme

Customize the location of your readme template.

**CLI**

```sh
$ verb --readme="lib/foo.md"
```

**verb config**

In your project's package.json:

```json
{
  "verb": {
    "readme": "docs/foo.md"
  }
}
```

#### times

Display all timings that are typically muted in the terminal.

**CLI**

```sh
$ verb --times
```

**verb config**

Always show timings for a project by adding the following to package.json:

```json
{
  "verb": {
    "times": true
  }
}
```

**API**

In your `verbfile.js` or application code:

```js
app.enable('times');
// equivalent to
app.option('times', true);
```

#### toc

Disable or enable the Table of Contents in the built-in layouts:

**CLI**

One-time only (in-memory)

```sh
# enable
$ verb --toc
# disable
$ verb --toc:false
```

Persist the value to package.json:

```sh
# enable
$ verb --config=toc
# disable
$ verb --config=toc:false
```

Results in:

```json
{
  "name": "my-project",
  "verb": {
    "toc": false
  }
}
```

#### no-reflinks-cache

Disable reflinks caching.

```sh
$ verb --no-reflinks-cache
```

#### layout

Set the layout to use for a project.

```sh
$ verb --config=layout:default
```

**Available layouts**

As with all templates, you can easily override these and/or define your own templates in a `verbfile.js`. Verb does much more than generate readme's!

The following layouts are available:

* `default`: a layout with installation, tests, author, usage, related list, contributing and license sections.
* `global`: same as default, but with global npm installation instructions (verb-generate-readme uses this layout)
* `empty`: noop layout. no content is applied, but all layout-related middleware stages will still run.

Layouts can be defined on a template-by-template basic, and even for includes. If you need more granularity just add a `verbfile.js` with your custom code.

## About

### Related projects

* [assemble](https://www.npmjs.com/package/assemble): Get the rocks out of your socks! Assemble makes you fast at creating web projects… [more](https://github.com/assemble/assemble) | [homepage](https://github.com/assemble/assemble "Get the rocks out of your socks! Assemble makes you fast at creating web projects. Assemble is used by thousands of projects for rapid prototyping, creating themes, scaffolds, boilerplates, e-books, UI components, API documentation, blogs, building websit")
* [generate](https://www.npmjs.com/package/generate): Command line tool and developer framework for scaffolding out new GitHub projects. Generate offers the… [more](https://github.com/generate/generate) | [homepage](https://github.com/generate/generate "Command line tool and developer framework for scaffolding out new GitHub projects. Generate offers the robustness and configurability of Yeoman, the expressiveness and simplicity of Slush, and more powerful flow control and composability than either.")
* [update](https://www.npmjs.com/package/update): Be scalable! Update is a new, open source developer framework and CLI for automating updates… [more](https://github.com/update/update) | [homepage](https://github.com/update/update "Be scalable! Update is a new, open source developer framework and CLI for automating updates of any kind in code projects.")
* [verb-collections](https://www.npmjs.com/package/verb-collections): Verb plugin that adds includes, layouts, badges and docs template collections. Can be used with… [more](https://github.com/verbose/verb-collections) | [homepage](https://github.com/verbose/verb-collections "Verb plugin that adds includes, layouts, badges and docs template collections. Can be used with verb, assemble or generate, in a `*file.js`, or a globally installed generator.")
* [verb-repo-data](https://www.npmjs.com/package/verb-repo-data): Verb plugin that adds repository and package.json data to the context for rendering templates. | [homepage](https://github.com/verbose/verb-repo-data "Verb plugin that adds repository and package.json data to the context for rendering templates.")
* [verb-toc](https://www.npmjs.com/package/verb-toc): Verb plugin that adds middleware for creating and injecting a table of contents into a… [more](https://github.com/verbose/verb-toc) | [homepage](https://github.com/verbose/verb-toc "Verb plugin that adds middleware for creating and injecting a table of contents into a markdown document.")
* [verb](https://www.npmjs.com/package/verb): Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used… [more](https://github.com/verbose/verb) | [homepage](https://github.com/verbose/verb "Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used on hundreds of projects of all sizes to generate everything from API docs to readmes.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Running tests

Install dev dependencies:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.1, on January 27, 2017._