'use strict';

var path = require('path');
var utils = require('./utils');

/**
 * Initialize options
 */

module.exports = function(app) {
  app.option('toc.footer', '\n\n_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_');
  app.option('engineOpts', {delims: ['{%', '%}']});
  app.option('toAlias', function readme(name) {
    var m = /^verb-(generate|helper|plugin)-(\w+)/.exec(name);
    return m ? m[1] : name.slice(name.lastIndexOf('-') + 1);
  });

  app.option('renameKey', function(key, file) {
    var name = file ? file.relative : path.relative(app.cwd, key);
    var ext = path.extname(name);
    var str = name.replace(/^(templates|docs)\/?(layouts|includes)\/?/, '');
    return ext ? str.slice(0, str.length - ext.length) : str;
  });

  app.option('toc.linkify', function(token, name, slug, tocOpts) {
    if (/[{<]%=?/.test(name)) {
      var inst = new app.constructor();
      var opts = app.options;
      inst.engine('*', app.getEngine('*') || app.getEngine('md'));
      opts.engine = '*';
      inst.data(app.cache.data);
      var view = inst.view('toctemp.md', {content: name, layout: false});
      inst.compile(view, opts);
      token.content = view.fn(inst.cache.data);
    }
    utils.toc.linkify(token, name, slug, tocOpts);
    return token;
  });
};
