##  The Bounty

We need a fully functional MusicXML Parser for VexFlow. I am awarding $5,000 (USD) to the first person (or team) that can build one (given the requirements below.) The winner will also be eligible for up to $5,000 of additional development work (so really, this is a $10,000 bounty.)

## The Goal

The goal is to implement a MusicXML parser that generates VexFlow notation, similar to how VexTab does.

- The parser must fully support the MusicXML 2 and 3 specs.
- Code must be written in ES6, well commented, and neatly organized.
- Code must work in all major browsers in both Canvas and SVG.
- Code is expected full test coverage, along with visual tests for each of the features (similar to the VexFlow tests.)
- VexFlow itself might need updates to support various MusicXML features -- you will send PRs to 0xfe/vexflow to implement these features.
- You are encouraged to communicate with me regularly as you work on this bug.

## How this will work

- Submit your finished repository to `mohit@muthanna.com` a `tar.bz2` (or `gz` or `zip` or whatever) archive.
- Make sure to include a `README.md` file with build instructions, test instructions, documentation, etc.
- I will review and evaluate your work, and possibly send it back requesting minor changes, corrections, or more information.
- If I like it, you win! You get a check for $5,000, and we might work together on further improvements or other projects (also for which you will get paid.)

## Logistics

- You must transfer full ownership of the code to me. (Note that I will only maintain ownership if you win. If you don't, you get to keep your code.)
- You must be in a country where such bounties are legal.


Pay for:

$100 overhaul VexTab tutorial.
$200 write new VexFlow tutorial.

$1000 write Guitar Pro (GPX) parser for VexFlow

Features:
- $500 support for Bravura
- $500: better beaming:
  + support for cross-stave beams
  + support for smarter automatic beaming
  + support for nested tuplets
  +
