"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _radium = require("radium");

var _radium2 = _interopRequireDefault(_radium);

var _victoryLabel = require("victory-label");

var _victoryUtil = require("victory-util");

var Tick = (function (_React$Component) {
  _inherits(Tick, _React$Component);

  function Tick() {
    _classCallCheck(this, _Tick);

    _get(Object.getPrototypeOf(_Tick.prototype), "constructor", this).apply(this, arguments);
  }

  _createClass(Tick, [{
    key: "getPosition",
    value: function getPosition(props, isVertical) {
      var orientationSign = { top: -1, left: -1, right: 1, bottom: 1 };
      var style = props.style.ticks;
      var tickSpacing = style.size + style.padding;
      var sign = orientationSign[props.orientation];
      return {
        x: isVertical ? sign * tickSpacing : 0,
        x2: isVertical ? sign * style.size : 0,
        y: isVertical ? 0 : sign * tickSpacing,
        y2: isVertical ? 0 : sign * style.size
      };
    }
  }, {
    key: "getAnchors",
    value: function getAnchors(props, isVertical) {
      var anchorOrientation = { top: "end", left: "end", right: "start", bottom: "start" };
      var anchor = anchorOrientation[props.orientation];
      return {
        textAnchor: isVertical ? anchor : "middle",
        verticalAnchor: isVertical ? "middle" : anchor
      };
    }
  }, {
    key: "renderLabel",
    value: function renderLabel(props, position, isVertical) {
      if (!props.label) {
        return undefined;
      }
      var componentProps = props.label.props ? props.label.props : {};
      var style = componentProps.style || props.style.tickLabels;
      var anchors = this.getAnchors(props, isVertical);
      var newProps = {
        x: position.x,
        y: position.y,
        textAnchor: componentProps.textAnchor || anchors.textAnchor,
        verticalAnchor: componentProps.verticalAnchor || anchors.verticalAnchor,
        style: _victoryUtil.Chart.evaluateStyle(style, props.tick)
      };
      return props.label.props ? _react2["default"].cloneElement(props.label, newProps) : _react2["default"].createElement(_victoryLabel.VictoryLabel, newProps, props.label);
    }
  }, {
    key: "renderTick",
    value: function renderTick(props, position) {
      return _react2["default"].createElement("line", {
        x: position.x,
        x2: position.x2,
        y: position.y,
        y2: position.y2,
        style: _victoryUtil.Chart.evaluateStyle(props.style.ticks, props.ticks)
      });
    }
  }, {
    key: "render",
    value: function render() {
      var isVertical = this.props.orientation === "left" || this.props.orientation === "right";
      var transform = isVertical ? "translate(0, " + this.props.position + ")" : "translate(" + this.props.position + ", 0)";
      var position = this.getPosition(this.props, isVertical);
      return _react2["default"].createElement(
        "g",
        { transform: transform },
        this.renderTick(this.props, position),
        this.renderLabel(this.props, position, isVertical)
      );
    }
  }], [{
    key: "role",
    value: "tick",
    enumerable: true
  }, {
    key: "propTypes",
    value: {
      position: _react.PropTypes.number,
      tick: _react.PropTypes.any,
      orientation: _react.PropTypes.oneOf(["top", "bottom", "left", "right"]),
      style: _react.PropTypes.object,
      label: _react.PropTypes.any
    },
    enumerable: true
  }]);

  var _Tick = Tick;
  Tick = (0, _radium2["default"])(Tick) || Tick;
  return Tick;
})(_react2["default"].Component);

exports["default"] = Tick;
module.exports = exports["default"];