"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

var _lodashObjectPick = require("lodash/object/pick");

var _lodashObjectPick2 = _interopRequireDefault(_lodashObjectPick);

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _radium = require("radium");

var _radium2 = _interopRequireDefault(_radium);

var _victoryLabel = require("victory-label");

var _victoryAnimation = require("victory-animation");

var _axisLine = require("./axis-line");

var _axisLine2 = _interopRequireDefault(_axisLine);

var _grid = require("./grid");

var _grid2 = _interopRequireDefault(_grid);

var _tick = require("./tick");

var _tick2 = _interopRequireDefault(_tick);

var _helperMethods = require("../helper-methods");

var _helperMethods2 = _interopRequireDefault(_helperMethods);

var _victoryUtil = require("victory-util");

var defaultStyles = {
  axis: {
    stroke: "#756f6a",
    fill: "none",
    strokeWidth: 2,
    strokeLinecap: "round"
  },
  axisLabel: {
    stroke: "transparent",
    fill: "#756f6a",
    fontSize: 16,
    fontFamily: "Helvetica"
  },
  grid: {
    stroke: "none",
    fill: "none",
    strokeLinecap: "round"
  },
  ticks: {
    stroke: "#756f6a",
    fill: "none",
    padding: 5,
    strokeWidth: 2,
    strokeLinecap: "round",
    size: 4
  },
  tickLabels: {
    stroke: "transparent",
    fill: "#756f6a",
    fontFamily: "Helvetica",
    fontSize: 10,
    padding: 5
  }
};

var orientationSign = {
  top: -1,
  left: -1,
  right: 1,
  bottom: 1
};

var VictoryAxis = (function (_React$Component) {
  _inherits(VictoryAxis, _React$Component);

  function VictoryAxis() {
    _classCallCheck(this, _VictoryAxis);

    _get(Object.getPrototypeOf(_VictoryAxis.prototype), "constructor", this).apply(this, arguments);
  }

  _createClass(VictoryAxis, [{
    key: "getStyles",
    value: function getStyles(props) {
      var style = props.style || {};
      var parentStyleProps = { height: props.height, width: props.width };
      return {
        parent: (0, _lodashObjectMerge2["default"])(parentStyleProps, defaultStyles.parent, style.parent),
        axis: (0, _lodashObjectMerge2["default"])({}, defaultStyles.axis, style.axis),
        axisLabel: (0, _lodashObjectMerge2["default"])({}, defaultStyles.axisLabel, style.axisLabel),
        grid: (0, _lodashObjectMerge2["default"])({}, defaultStyles.grid, style.grid),
        ticks: (0, _lodashObjectMerge2["default"])({}, defaultStyles.ticks, style.ticks),
        tickLabels: (0, _lodashObjectMerge2["default"])({}, defaultStyles.tickLabels, style.tickLabels)
      };
    }
  }, {
    key: "getTickProps",
    value: function getTickProps(props) {
      var stringTicks = _helperMethods2["default"].stringTicks(props);
      var scale = _helperMethods2["default"].getScale(props);
      var ticks = _helperMethods2["default"].getTicks(props, scale);
      return { scale: scale, ticks: ticks, stringTicks: stringTicks };
    }
  }, {
    key: "getLayoutProps",
    value: function getLayoutProps(props) {
      var style = this.getStyles(props);
      var padding = _victoryUtil.Chart.getPadding(props);
      var orientation = _helperMethods2["default"].getOrientation(props);
      var isVertical = _helperMethods2["default"].isVertical(props);
      var labelPadding = _helperMethods2["default"].getLabelPadding(props, style);
      var offset = _helperMethods2["default"].getOffset(props, style);
      return { style: style, padding: padding, orientation: orientation, isVertical: isVertical, labelPadding: labelPadding, offset: offset };
    }
  }, {
    key: "renderLine",
    value: function renderLine(props, layoutProps) {
      var style = layoutProps.style;
      var padding = layoutProps.padding;
      var isVertical = layoutProps.isVertical;

      return _react2["default"].createElement(_axisLine2["default"], { key: "line",
        style: style.axis,
        x1: isVertical ? null : padding.left,
        x2: isVertical ? null : props.width - padding.right,
        y1: isVertical ? padding.top : null,
        y2: isVertical ? props.height - padding.bottom : null
      });
    }
  }, {
    key: "renderTicks",
    value: function renderTicks(props, layoutProps, tickProps) {
      var _this = this;

      var style = layoutProps.style;
      var orientation = layoutProps.orientation;
      var scale = tickProps.scale;
      var ticks = tickProps.ticks;
      var stringTicks = tickProps.stringTicks;

      var tickFormat = _helperMethods2["default"].getTickFormat(props, tickProps);
      return ticks.map(function (tick, index) {
        var position = scale(tick);
        return _react2["default"].createElement(_tick2["default"], { key: "tick-" + index,
          position: position,
          tick: stringTicks ? props.tickValues[tick - 1] : tick,
          orientation: orientation,
          label: tickFormat.call(_this, tick, index),
          style: {
            ticks: style.ticks,
            tickLabels: style.tickLabels
          }
        });
      });
    }
  }, {
    key: "renderGrid",
    value: function renderGrid(props, layoutProps, tickProps) {
      var scale = tickProps.scale;
      var ticks = tickProps.ticks;
      var stringTicks = tickProps.stringTicks;
      var style = layoutProps.style;
      var padding = layoutProps.padding;
      var isVertical = layoutProps.isVertical;
      var offset = layoutProps.offset;
      var orientation = layoutProps.orientation;

      var xPadding = orientation === "right" ? padding.right : padding.left;
      var yPadding = orientation === "top" ? padding.top : padding.bottom;
      var sign = -orientationSign[orientation];
      var xOffset = props.crossAxis ? offset.x - xPadding : 0;
      var yOffset = props.crossAxis ? offset.y - yPadding : 0;
      var x2 = isVertical ? sign * (props.width - (padding.left + padding.right)) : 0;
      var y2 = isVertical ? 0 : sign * (props.height - (padding.top + padding.bottom));
      return ticks.map(function (tick, index) {
        // determine the position and translation of each gridline
        var position = scale(tick);
        return _react2["default"].createElement(_grid2["default"], { key: "grid-" + index,
          tick: stringTicks ? props.tickValues[tick - 1] : tick,
          x2: x2,
          y2: y2,
          xTransform: isVertical ? -xOffset : position,
          yTransform: isVertical ? position : yOffset,
          style: style.grid
        });
      });
    }
  }, {
    key: "renderLabel",
    value: function renderLabel(props, layoutProps) {
      if (!props.label) {
        return undefined;
      }
      var newProps = this.getLableProps(props, layoutProps);
      return props.label.props ? _react2["default"].cloneElement(props.label, newProps) : _react2["default"].createElement(_victoryLabel.VictoryLabel, newProps, props.label);
    }
  }, {
    key: "getLableProps",
    value: function getLableProps(props, layoutProps) {
      var componentProps = props.label.props || {};
      var style = layoutProps.style;
      var orientation = layoutProps.orientation;
      var padding = layoutProps.padding;
      var labelPadding = layoutProps.labelPadding;
      var isVertical = layoutProps.isVertical;

      var sign = orientationSign[orientation];
      var hPadding = padding.left + padding.right;
      var vPadding = padding.top + padding.bottom;
      var x = isVertical ? -((props.height - vPadding) / 2) - padding.top : (props.width - hPadding) / 2 + padding.left;
      var y = sign * labelPadding;
      var verticalAnchor = sign < 0 ? "end" : "start";
      var transform = isVertical ? "rotate(-90)" : "";
      return {
        key: "label",
        x: componentProps.x || x,
        y: componentProps.y || y,
        textAnchor: componentProps.textAnchor || "middle",
        verticalAnchor: componentProps.verticalAnchor || verticalAnchor,
        style: (0, _lodashObjectMerge2["default"])({}, componentProps.style, style.axisLabel),
        transform: componentProps.transform || transform
      };
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      // If animating, return a `VictoryAnimation` element that will create
      // a new `VictoryAxis` with nearly identical props, except (1) tweened
      // and (2) `animate` set to null so we don't recurse forever.
      if (this.props.animate) {
        // Do less work by having `VictoryAnimation` tween only values that
        // make sense to tween. In the future, allow customization of animated
        // prop whitelist/blacklist?
        var animateData = (0, _lodashObjectPick2["default"])(this.props, ["style", "domain", "range", "tickCount", "tickValues", "labelPadding", "offsetX", "offsetY", "padding", "width", "height"]);
        return _react2["default"].createElement(
          _victoryAnimation.VictoryAnimation,
          _extends({}, this.props.animate, { data: animateData }),
          function (props) {
            return _react2["default"].createElement(VictoryAxis, _extends({}, _this2.props, props, { animate: null }));
          }
        );
      }
      var layoutProps = this.getLayoutProps(this.props);
      var tickProps = this.getTickProps(this.props);
      var style = layoutProps.style;

      var transform = _helperMethods2["default"].getTransform(this.props, layoutProps);
      var group = _react2["default"].createElement(
        "g",
        { style: style.parent, transform: transform },
        this.renderLabel(this.props, layoutProps),
        this.renderTicks(this.props, layoutProps, tickProps),
        this.renderLine(this.props, layoutProps),
        this.renderGrid(this.props, layoutProps, tickProps)
      );
      return this.props.standalone ? _react2["default"].createElement(
        "svg",
        { style: style.parent },
        group
      ) : group;
    }
  }], [{
    key: "role",
    value: "axis",
    enumerable: true
  }, {
    key: "propTypes",
    value: {
      /**
       * The animate prop specifies props for victory-animation to use. It this prop is
       * not given, the axis will not tween between changing data / style props.
       * Large datasets might animate slowly due to the inherent limits of svg rendering.
       * @examples {velocity: 0.02, onEnd: () => alert("done!")}
       */
      animate: _react.PropTypes.object,
      /**
       * This prop specifies whether a given axis is intended to cross another axis.
       */
      crossAxis: _react.PropTypes.bool,
      /**
       * The dependentAxis prop specifies whether the axis corresponds to the
       * dependent variable (usually y). This prop is useful when composing axis
       * with other components to form a chart.
       */
      dependentAxis: _react.PropTypes.bool,
      /**
       * The domain prop describes the range of values your axis will include. This prop should be
       * given as a array of the minimum and maximum expected values for your axis.
       * If this value is not given it will be calculated based on the scale or tickValues.
       * @examples [-1, 1]
       */
      domain: _victoryUtil.PropTypes.domain,
      /**
       * The height prop specifies the height of the chart container element in pixels.
       */
      height: _victoryUtil.PropTypes.nonNegative,
      /**
       * The label prop specifies the label for your axis. This prop can be a string or
       * a label component.
       */
      label: _react.PropTypes.any,
      /**
       * The labelPadding prop specifies the padding in pixels for your axis label.
       */
      labelPadding: _react.PropTypes.number,
      /**
       * This value describes how far from the "edge" of its permitted area each axis
       * will be set back in the x-direction.  If this prop is not given,
       * the offset is calculated based on font size, axis orientation, and label padding.
       */
      offsetX: _react.PropTypes.number,
      /**
       * This value describes how far from the "edge" of its permitted area each axis
       * will be set back in the y-direction.  If this prop is not given,
       * the offset is calculated based on font size, axis orientation, and label padding.
       */
      offsetY: _react.PropTypes.number,
      /**
       * The orientation prop specifies the position and orientation of your axis.
       */
      orientation: _react.PropTypes.oneOf(["top", "bottom", "left", "right"]),
      /**
       * The padding props specifies the amount of padding in number of pixels between
       * the edge of the chart and any rendered child components. This prop can be given
       * as a number or as an object with padding specified for top, bottom, left
       * and right.
       */
      padding: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.shape({
        top: _react.PropTypes.number,
        bottom: _react.PropTypes.number,
        left: _react.PropTypes.number,
        right: _react.PropTypes.number
      })]),
      /**
       * The scale prop determines which scales your axis should use. This prop can be
       * given as a `d3-scale@0.3.0` function or as a string corresponding to a supported d3-string
       * function.
       * @examples d3Scale.time(), "linear", "time", "log", "sqrt"
       */
      scale: _victoryUtil.PropTypes.scale,
      /**
       * The standalone prop determines whether the component will render a standalone svg
       * or a <g> tag that will be included in an external svg. Set standalone to false to
       * compose VictoryAxis with other components within an enclosing <svg> tag.
       */
      standalone: _react.PropTypes.bool,
      /**
       * The style prop specifies styles for your chart. Victory Axis relies on Radium,
       * so valid Radium style objects should work for this prop, however height, width, and margin
       * are used to calculate range, and need to be expressed as a number of pixels.
       * Styles for axis lines, gridlines, and ticks are scoped to separate props.
       * @examples {axis: {stroke: "#756f6a"}, grid: {stroke: "grey"}, ticks: {stroke: "grey"},
       * tickLabels: {fontSize: 10, padding: 5}, axisLabel: {fontSize: 16, padding: 20}}
       */
      style: _react.PropTypes.shape({
        parent: _react.PropTypes.object,
        axis: _react.PropTypes.object,
        axisLabel: _react.PropTypes.object,
        grid: _react.PropTypes.object,
        ticks: _react.PropTypes.object,
        tickLabels: _react.PropTypes.object
      }),
      /**
       * The tickCount prop specifies how many ticks should be drawn on the axis if
       * tickValues are not explicitly provided.
       */
      tickCount: _victoryUtil.PropTypes.nonNegative,
      /**
       * The tickFormat prop specifies how tick values should be expressed visually.
       * tickFormat can be given as a function to be applied to every tickValue, or as
       * an array of display values for each tickValue.
       * @examples d3.time.format("%Y"), (x) => x.toPrecision(2), ["first", "second", "third"]
       */
      tickFormat: _react.PropTypes.oneOfType([_react.PropTypes.func, _victoryUtil.PropTypes.homogeneousArray]),
      /**
       * The tickValues prop explicitly specifies which tick values to draw on the axis.
       * @examples ["apples", "bananas", "oranges"], [2, 4, 6, 8]
       */
      tickValues: _victoryUtil.PropTypes.homogeneousArray,
      /**
       * The width props specifies the width of the chart container element in pixels
       */
      width: _victoryUtil.PropTypes.nonNegative
    },
    enumerable: true
  }, {
    key: "defaultProps",
    value: {
      height: 300,
      padding: 50,
      scale: "linear",
      standalone: true,
      tickCount: 5,
      width: 450
    },
    enumerable: true
  }, {
    key: "getDomain",
    value: _helperMethods2["default"].getDomain.bind(_helperMethods2["default"]),
    enumerable: true
  }, {
    key: "getAxis",
    value: _helperMethods2["default"].getAxis.bind(_helperMethods2["default"]),
    enumerable: true
  }, {
    key: "getScale",
    value: _helperMethods2["default"].getScale.bind(_helperMethods2["default"]),
    enumerable: true
  }]);

  var _VictoryAxis = VictoryAxis;
  VictoryAxis = (0, _radium2["default"])(VictoryAxis) || VictoryAxis;
  return VictoryAxis;
})(_react2["default"].Component);

exports["default"] = VictoryAxis;
module.exports = exports["default"];