"use strict";

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

var _lodashArrayWithout = require("lodash/array/without");

var _lodashArrayWithout2 = _interopRequireDefault(_lodashArrayWithout);

var _lodashCollectionIncludes = require("lodash/collection/includes");

var _lodashCollectionIncludes2 = _interopRequireDefault(_lodashCollectionIncludes);

var _lodashUtilityRange = require("lodash/utility/range");

var _lodashUtilityRange2 = _interopRequireDefault(_lodashUtilityRange);

var _victoryUtil = require("victory-util");

module.exports = {
  // exposed for use by VictoryChart
  getDomain: function getDomain(props, axis) {
    if (axis && axis !== this.getAxis(props)) {
      return undefined;
    }
    if (props.domain) {
      return props.domain;
    } else if (props.tickValues) {
      return this.getDomainFromTickValues(props);
    }
    return undefined;
  },

  // exposed for use by VictoryChart
  getAxis: function getAxis(props, flipped) {
    if (props.orientation) {
      var vertical = { top: "x", bottom: "x", left: "y", right: "y" };
      return vertical[props.orientation];
    }
    var axisType = props.dependentAxis ? "dependent" : "independent";
    var flippedAxis = { dependent: "x", independent: "y" };
    var normalAxis = { independent: "x", dependent: "y" };
    return flipped ? flippedAxis[axisType] : normalAxis[axisType];
  },

  // exposed for use by VictoryChart
  getScale: function getScale(props) {
    var axis = this.getAxis(props);
    var scale = _victoryUtil.Scale.getBaseScale(props, axis);
    var domain = this.getDomain(props) || scale.domain();
    scale.range(_victoryUtil.Chart.getRange(props, axis));
    scale.domain(domain);
    return scale;
  },

  getDomainFromTickValues: function getDomainFromTickValues(props) {
    var domain = undefined;
    if (this.stringTicks(props)) {
      domain = [1, props.tickValues.length];
    } else {
      // coerce ticks to numbers
      var ticks = props.tickValues.map(function (value) {
        return +value;
      });
      domain = [Math.min.apply(Math, _toConsumableArray(ticks)), Math.max.apply(Math, _toConsumableArray(ticks))];
    }
    if (this.isVertical(props)) {
      domain.reverse();
    }
    return domain;
  },

  getOrientation: function getOrientation(props) {
    return props.orientation || (props.dependentAxis ? "left" : "bottom");
  },

  isVertical: function isVertical(props) {
    var orientation = this.getOrientation(props);
    var vertical = { top: false, bottom: false, left: true, right: true };
    return vertical[orientation];
  },

  stringTicks: function stringTicks(props) {
    return props.tickValues !== undefined && _victoryUtil.Collection.containsStrings(props.tickValues);
  },

  getTicks: function getTicks(props, scale) {
    if (props.tickValues) {
      if (this.stringTicks(props)) {
        return (0, _lodashUtilityRange2["default"])(1, props.tickValues.length + 1);
      }
      return props.tickValues;
    } else if (scale.ticks && typeof scale.ticks === "function") {
      var ticks = scale.ticks(props.tickCount);
      if (props.crossAxis) {
        return (0, _lodashCollectionIncludes2["default"])(ticks, 0) ? (0, _lodashArrayWithout2["default"])(ticks, 0) : ticks;
      }
      return ticks;
    }
    return scale.domain();
  },

  getTickFormat: function getTickFormat(props, tickProps) {
    var scale = tickProps.scale;
    var ticks = tickProps.ticks;

    if (props.tickFormat && typeof props.tickFormat === "function") {
      return props.tickFormat;
    } else if (props.tickFormat && Array.isArray(props.tickFormat)) {
      return function (x, index) {
        return props.tickFormat[index];
      };
    } else if (this.stringTicks(props)) {
      return function (x, index) {
        return props.tickValues[index];
      };
    } else if (scale.tickFormat && typeof scale.tickFormat === "function") {
      return scale.tickFormat(ticks.length);
    } else {
      return function (x) {
        return x;
      };
    }
  },

  getLabelPadding: function getLabelPadding(props, style) {
    var labelStyle = style.axisLabel;
    if (typeof labelStyle.padding !== "undefined" && labelStyle.padding !== null) {
      return labelStyle.padding;
    }
    var isVertical = this.isVertical(props);
    // TODO: magic numbers
    return props.label ? labelStyle.fontSize * (isVertical ? 2.3 : 1.6) : 0;
  },

  getOffset: function getOffset(props, style) {
    var padding = _victoryUtil.Chart.getPadding(props);
    var isVertical = this.isVertical(props);
    var orientation = this.getOrientation(props);
    var labelPadding = this.getLabelPadding(props, style);
    var xPadding = orientation === "right" ? padding.right : padding.left;
    var yPadding = orientation === "top" ? padding.top : padding.bottom;
    var fontSize = style.axisLabel.fontSize;
    var offsetX = props.offsetX || xPadding;
    var offsetY = props.offsetY || yPadding;
    var totalPadding = fontSize + 2 * style.ticks.size + labelPadding;
    var minimumPadding = 1.2 * fontSize; // TODO: magic numbers
    var x = isVertical ? totalPadding : minimumPadding;
    var y = isVertical ? minimumPadding : totalPadding;
    return {
      x: offsetX || x,
      y: offsetY || y
    };
  },

  getTransform: function getTransform(props, layoutProps) {
    var offset = layoutProps.offset;
    var orientation = layoutProps.orientation;

    var translate = ({
      top: [0, offset.y],
      bottom: [0, props.height - offset.y],
      left: [offset.x, 0],
      right: [props.width - offset.x, 0]
    })[orientation];
    return "translate(" + translate[0] + ", " + translate[1] + ")";
  }
};